// 
// $Id: svFaceProperties.H,v 1.1.1.1 2006/12/19 22:59:33 christianh Exp $
// 
#ifndef SV_FACEPROPERTIES_H_
#  define SV_FACEPROPERTIES_H_

#  include "svProperty.H"
#  include <iostream>

class svFaceProperties
{
  svProperty* Front;
  svProperty* Back;
  svProperty* SavedBack;
  GLboolean   DistinctFrontAndBack;
  GLboolean   ColorMaterial;
  GLenum      ColorMaterialFace;
  GLenum      ColorMaterialParameter;
  GLbitfield  Debug;

public:
  // 
  svFaceProperties() : Front(0), Back(0), SavedBack(0)
    {
      this->DistinctFrontAndBack   = GL_FALSE;
      this->ColorMaterial          = GL_FALSE; // i.e. disable GL_COLOR_MATERIAL
      this->ColorMaterialFace      = GL_FRONT_AND_BACK;
      this->ColorMaterialParameter = GL_AMBIENT_AND_DIFFUSE;
      this->Debug = 0;
    }
  ~svFaceProperties()
    {
      if(this->Front)     delete this->Front;
      if(this->SavedBack) delete this->SavedBack;
    }
  // 
  void        SetDebug(GLbitfield arg);
  GLbitfield  GetDebug() const;
  void        DebugOn();
  void        DebugOff();
  // 
  svProperty* GetFront();
  svProperty* GetBack();
  // 
  void        SetDistinctFrontAndBack(GLboolean arg);
  GLboolean   GetDistinctFrontAndBack() const;
  void        DistinctFrontAndBackOn();
  void        DistinctFrontAndBackOff();
  // 
  void        SetColorMaterial(GLboolean arg);
  GLboolean   GetColorMaterial() const;
  void        ColorMaterialOn();
  void        ColorMaterialOff();
  // 
  void        SetColorMaterialFace(GLenum arg);
  GLenum      GetColorMaterialFace() const;
  void        SetColorMaterialFaceToFront();
  void        SetColorMaterialFaceToBack();
  void        SetColorMaterialFaceToFrontAndBack();
  // 
  void        SetColorMaterialParameter(GLenum arg);
  GLenum      GetColorMaterialParameter() const;
  void        SetColorMaterialParameterToAmbient();
  void        SetColorMaterialParameterToDiffuse();
  void        SetColorMaterialParameterToAmbientAndDiffuse();
  void        SetColorMaterialParameterToSpecular();
  void        SetColorMaterialParameterToEmission();
  // 
  void        Apply();
  void        ApplyOpaque();
};


// 
inline void
svFaceProperties::SetDebug(GLbitfield arg)
{
  this->Debug = arg;
}

inline GLbitfield
svFaceProperties::GetDebug() const
{
  return this->Debug;
}

inline void
svFaceProperties::DebugOn()
{
  this->Debug = 1;
}

inline void
svFaceProperties::DebugOff()
{
  this->Debug = 0;
}

// 
inline void
svFaceProperties::SetDistinctFrontAndBack(GLboolean arg)
{
  this->DistinctFrontAndBack = arg;
}

inline GLboolean
svFaceProperties::GetDistinctFrontAndBack() const
{
  return this->DistinctFrontAndBack;
}

inline void
svFaceProperties::DistinctFrontAndBackOn()
{
  this->DistinctFrontAndBack = GL_TRUE;
}

inline void
svFaceProperties::DistinctFrontAndBackOff()
{
  this->DistinctFrontAndBack = GL_FALSE;
}

// 
inline svProperty*
svFaceProperties::GetFront()
{
  if(!this->Front) this->Front = new svProperty;
  return this->Front;
}

inline svProperty*
svFaceProperties::GetBack()
{
  if(this->DistinctFrontAndBack == GL_TRUE) {
    if(!this->Back) {
      if(this->SavedBack) this->Back = this->SavedBack;
      else this->Back = this->SavedBack = new svProperty;
    }
  }
  else {
    if(this->Back) this->Back = 0;
  }
  return this->Back;
}

// 
inline void
svFaceProperties::SetColorMaterial(GLboolean arg)
{
  this->ColorMaterial = arg;
}

inline GLboolean
svFaceProperties::GetColorMaterial() const
{
  return this->ColorMaterial;
}

inline void
svFaceProperties::ColorMaterialOn()
{
  this->ColorMaterial = GL_TRUE;
}

inline void
svFaceProperties::ColorMaterialOff()
{
  this->ColorMaterial = GL_FALSE;
}

// 
inline void
svFaceProperties::SetColorMaterialFace(GLenum arg)
{
  this->ColorMaterialFace = arg;
}

inline GLenum
svFaceProperties::GetColorMaterialFace() const
{
  return this->ColorMaterialFace;
}

inline void
svFaceProperties::SetColorMaterialFaceToFront()
{
  this->ColorMaterialFace = GL_FRONT;
}

inline void
svFaceProperties::SetColorMaterialFaceToBack()
{
  this->ColorMaterialFace = GL_BACK;
}

inline void
svFaceProperties::SetColorMaterialFaceToFrontAndBack()
{
  this->ColorMaterialFace = GL_FRONT_AND_BACK;
}

// 
inline void
svFaceProperties::SetColorMaterialParameter(GLenum arg)
{
  this->ColorMaterialParameter = arg;
}

inline GLenum
svFaceProperties::GetColorMaterialParameter() const
{
  return this->ColorMaterialParameter;
}

inline void
svFaceProperties::SetColorMaterialParameterToAmbient()
{
  this->ColorMaterialParameter = GL_AMBIENT;
}

inline void
svFaceProperties::SetColorMaterialParameterToDiffuse()
{
  this->ColorMaterialParameter = GL_DIFFUSE;
}

inline void
svFaceProperties::SetColorMaterialParameterToAmbientAndDiffuse()
{
  this->ColorMaterialParameter = GL_AMBIENT_AND_DIFFUSE;
}

inline void
svFaceProperties::SetColorMaterialParameterToSpecular()
{
  this->ColorMaterialParameter = GL_SPECULAR;
}

inline void
svFaceProperties::SetColorMaterialParameterToEmission()
{
  this->ColorMaterialParameter = GL_EMISSION;
}

// 
inline void
svFaceProperties::Apply()
{
  if(this->Debug)
    cerr << "svFaceProperties(" << this << ")::Apply()\n\n";

  if(this->ColorMaterial == GL_TRUE) {
    glEnable(GL_COLOR_MATERIAL);
    glColorMaterial(this->ColorMaterialFace, this->ColorMaterialParameter);
  }
  else {
    glDisable(GL_COLOR_MATERIAL);
  }

  (this->GetFront())->Apply();
  if(this->DistinctFrontAndBack == GL_TRUE && this->GetBack()) {
    (this->GetBack())->Apply(GL_BACK);
  }
}

// 
inline void
svFaceProperties::ApplyOpaque()
{
  if(this->Debug)
    cerr << "svFaceProperties(" << this << ")::ApplyOpaque()\n\n";

  if(this->ColorMaterial == GL_TRUE) {
    glEnable(GL_COLOR_MATERIAL);
    glColorMaterial(this->ColorMaterialFace, this->ColorMaterialParameter);
  }
  else {
    glDisable(GL_COLOR_MATERIAL);
  }

  (this->GetFront())->ApplyOpaque();
  if(this->DistinctFrontAndBack == GL_TRUE && this->GetBack()) {
    (this->GetBack())->ApplyOpaque(GL_BACK);
  }
}

#endif /* SVFACEPROPERTIES_H_ */
// 
// End of: $Id: svFaceProperties.H,v 1.1.1.1 2006/12/19 22:59:33 christianh Exp $.
// 
