// 
// $Id: svFacePropertiesViewUI_cb.H,v 1.1.1.1 2006/12/19 22:59:34 christianh Exp $
// 
#ifndef SV_FACEPROPERTIESVIEWUI_CB_H_
#  define SV_FACEPROPERTIESVIEWUI_CB_H_

#  include "svDefinedMaterials.H"

static int TotalDefinedMaterials = 0;

inline void
svFacePropertiesViewUI::init()
{
  material* mat = Materials;

  // add the "Previous" material (id=0) first
  while(mat && mat->id != 0) mat++;
  this->frontMaterialsMenu->add(mat->info,0,0,(void*)mat,FL_MENU_VALUE);
  this->backMaterialsMenu->add(mat->info,0,0,(void*)mat,FL_MENU_VALUE);

  mat = Materials;
  while(mat && mat->id != 0) {
    this->frontMaterialsMenu->add(mat->info,0,0,(void*)mat,FL_MENU_VALUE);
    this->backMaterialsMenu->add(mat->info,0,0,(void*)mat,FL_MENU_VALUE);
    mat++;
    TotalDefinedMaterials++;
  }

  //this->UpdateFront();
  //this->UpdateBack();
}

inline void
svFacePropertiesViewUI::Show()
{
  this->mainWindow->show();
}

inline void
svFacePropertiesViewUI::Hide()
{
  this->mainWindow->hide();
}

inline int
svFacePropertiesViewUI::Shown() const
{
  return this->mainWindow->shown();
}

inline svProperty*
svFacePropertiesViewUI::GetFront()
{
  return this->FacePropertiesView->GetFront();
}

inline svProperty*
svFacePropertiesViewUI::GetBack()
{
  return this->FacePropertiesView->GetBack();
}

inline void
svFacePropertiesViewUI::SetAmbientRed()
{
  this->FacePropertiesView->
    SetAmbientRed(GLfloat(this->ambientRed->value()));
}

inline void
svFacePropertiesViewUI::SetAmbientGreen()
{
  this->FacePropertiesView->
    SetAmbientGreen(GLfloat(this->ambientGreen->value()));
}

inline void
svFacePropertiesViewUI::SetAmbientBlue()
{
  this->FacePropertiesView->
    SetAmbientBlue(GLfloat(this->ambientBlue->value()));
}

inline void
svFacePropertiesViewUI::SetLight0Intensity()
{
  this->FacePropertiesView->
    SetLightIntensity(GLfloat(this->light0Intensity->value()));
}

inline void
svFacePropertiesViewUI::SetLight0Red()
{
  this->FacePropertiesView->
    SetLightRed(GLfloat(this->light0Red->value()));
}

inline void
svFacePropertiesViewUI::SetLight0Green()
{
  this->FacePropertiesView->
    SetLightGreen(GLfloat(this->light0Green->value()));
}

inline void
svFacePropertiesViewUI::SetLight0Blue()
{
  this->FacePropertiesView->
    SetLightBlue(GLfloat(this->light0Blue->value()));
}

inline void
svFacePropertiesViewUI::SetLight0FocalPointX()
{
  this->FacePropertiesView->
    SetLightFocalPointX(GLfloat(this->light0FocalPointX->value()));
}

inline void
svFacePropertiesViewUI::SetLight0FocalPointY()
{
  this->FacePropertiesView->
    SetLightFocalPointY(GLfloat(this->light0FocalPointY->value()));
}

inline void
svFacePropertiesViewUI::SetLight0FocalPointZ()
{
  this->FacePropertiesView->
    SetLightFocalPointZ(GLfloat(this->light0FocalPointZ->value()));
}

inline void
svFacePropertiesViewUI::SetLight0PositionX()
{
  this->FacePropertiesView->
    SetLightPositionX(GLfloat(this->light0PositionX->value()));
}

inline void
svFacePropertiesViewUI::SetLight0PositionY()
{
  this->FacePropertiesView->
    SetLightPositionY(GLfloat(this->light0PositionY->value()));
}

inline void
svFacePropertiesViewUI::SetLight0PositionZ()
{
  this->FacePropertiesView->
    SetLightPositionZ(GLfloat(this->light0PositionZ->value()));
}

inline void
svFacePropertiesViewUI::ToggleTwoSidedLighting()
{
  this->FacePropertiesView->
    SetTwoSidedLighting(GLboolean(this->TwoSidedLighting->value()));
}

inline void
svFacePropertiesViewUI::TogglePositionalLighting()
{
  this->FacePropertiesView->
    SetPositionalLighting(GLboolean(this->PositionalLighting->value()));
}

inline void
svFacePropertiesViewUI::ToggleDistinctFrontAndBack()
{
  this->FacePropertiesView->
    SetDistinctFrontAndBack(GLboolean(this->DistinctFrontAndBack->value()));

  if(this->FacePropertiesView->GetDistinctFrontAndBack()) {
    this->backGroup->activate();
  }
  else {
    this->backGroup->deactivate();
  }
}

inline void
svFacePropertiesViewUI::TogglePointSmoothing()
{
  this->FacePropertiesView->
    SetPointSmoothing(GLboolean(this->PointSmoothing->value()));
}

inline void
svFacePropertiesViewUI::ToggleLineSmoothing()
{
  this->FacePropertiesView->
    SetLineSmoothing(GLboolean(this->LineSmoothing->value()));
}

inline void
svFacePropertiesViewUI::TogglePolygonSmoothing()
{
#  if 0
  this->FacePropertiesView->
    SetPolygonSmoothing(GLboolean(this->PolygonSmoothing->value()));
#  endif /* 0 */
}

inline void
svFacePropertiesViewUI::SetModelCb()
{
  const char* strptr = 0;
  switch (this->ModelMenu->value()) {
  case 0:  strptr = "teapot"; break;
  case 1:  strptr = "cow"; break;
  case 2:  strptr = "face"; break;
  case 3:  strptr = "mechanical"; break;
  case 4:  strptr = "motor"; break;
  case 5:  strptr = "pialsurf"; break;
  case 6:  strptr = "spheresurf"; break;
  case 7:  strptr = "inflatedsurf"; break;
  case 8:  strptr = "smoothwmsurf"; break;
  default: strptr = "teapot"; break;
  }

  Fl::check();

  this->FacePropertiesView->SetModel(strptr);
  this->FacePropertiesView->redraw();
}

inline void
svFacePropertiesViewUI::SetShading()
{
  switch (this->ShadingMenu->value()) {
  case 0: (this->GetFront())->SetShadeModelToSmooth(); break;
  case 1: (this->GetFront())->SetShadeModelToFlat(); break;
  }

  this->FacePropertiesView->redraw();
}

inline void
svFacePropertiesViewUI::SetPointSize()
{
  (this->GetFront())->SetPointSize(GLfloat(this->PointSize->value()));
  this->FacePropertiesView->redraw();
}

inline void
svFacePropertiesViewUI::SetLineWidth()
{
  (this->GetFront())->SetLineWidth(GLfloat(this->LineWidth->value()));
  this->FacePropertiesView->redraw();
}

inline void
svFacePropertiesViewUI::SetFrontPolymode()
{
  switch (this->frontPolymodeMenu->value()) {
  case 0: (this->GetFront())->SetPolygonModeToFill(); break;
  case 1: (this->GetFront())->SetPolygonModeToLine(); break;
  case 2: (this->GetFront())->SetPolygonModeToPoint(); break;
  }

  this->FacePropertiesView->redraw();
}

inline void
svFacePropertiesViewUI::SetBackPolymode()
{
  switch (this->backPolymodeMenu->value()) {
  case 0: (this->GetBack())->SetPolygonModeToFill(); break;
  case 1: (this->GetBack())->SetPolygonModeToLine(); break;
  case 2: (this->GetBack())->SetPolygonModeToPoint(); break;
  }

  this->FacePropertiesView->redraw();
}

inline void
svFacePropertiesViewUI::UpdateFront()
{
  const GLfloat* rgb = (this->GetFront())->GetColor();
  this->frontRed->value(double(rgb[0]));
  this->frontGreen->value(double(rgb[1]));
  this->frontBlue->value(double(rgb[2]));

  rgb = (this->GetFront())->GetAmbientColor();
  this->frontAmbient->value(double((this->GetFront())->GetAmbient()));
  this->frontAmbientRed->value(double(rgb[0]));
  this->frontAmbientGreen->value(double(rgb[1]));
  this->frontAmbientBlue->value(double(rgb[2]));

  rgb = (this->GetFront())->GetDiffuseColor();
  this->frontDiffuse->value(double((this->GetFront())->GetDiffuse()));
  this->frontDiffuseRed->value(double(rgb[0]));
  this->frontDiffuseGreen->value(double(rgb[1]));
  this->frontDiffuseBlue->value(double(rgb[2]));

  rgb = (this->GetFront())->GetSpecularColor();
  this->frontSpecular->value(double((this->GetFront())->GetSpecular()));
  this->frontSpecularRed->value(double(rgb[0]));
  this->frontSpecularGreen->value(double(rgb[1]));
  this->frontSpecularBlue->value(double(rgb[2]));

  this->frontShininess->value(double((this->GetFront())->GetShininess()));
  this->frontOpacity->value(double((this->GetFront())->GetOpacity()));

  this->FacePropertiesView->redraw();
}

inline void
svFacePropertiesViewUI::UpdateBack()
{
  const GLfloat* rgb = (this->GetBack())->GetColor();
  this->backRed->value(double(rgb[0]));
  this->backGreen->value(double(rgb[1]));
  this->backBlue->value(double(rgb[2]));

  rgb = (this->GetBack())->GetAmbientColor();
  this->backAmbient->value(double((this->GetBack())->GetAmbient()));
  this->backAmbientRed->value(double(rgb[0]));
  this->backAmbientGreen->value(double(rgb[1]));
  this->backAmbientBlue->value(double(rgb[2]));

  rgb = (this->GetBack())->GetDiffuseColor();
  this->backDiffuse->value(double((this->GetBack())->GetDiffuse()));
  this->backDiffuseRed->value(double(rgb[0]));
  this->backDiffuseGreen->value(double(rgb[1]));
  this->backDiffuseBlue->value(double(rgb[2]));

  rgb = (this->GetBack())->GetSpecularColor();
  this->backSpecular->value(double((this->GetBack())->GetSpecular()));
  this->backSpecularRed->value(double(rgb[0]));
  this->backSpecularGreen->value(double(rgb[1]));
  this->backSpecularBlue->value(double(rgb[2]));

  this->backShininess->value(double((this->GetBack())->GetShininess()));
  this->backOpacity->value(double((this->GetBack())->GetOpacity()));

  this->FacePropertiesView->redraw();
}

#  define MAX2(_a,_b) ((_a)>(_b) ? (_a) : (_b))
#  define MAX3(_v)    MAX2(MAX2(_v[0],_v[1]), MAX2(_v[0],_v[2]))

inline void
svFacePropertiesViewUI::FrontMaterialMenuCb()
{
  const Fl_Menu_Item* item = this->frontMaterialsMenu->mvalue();
  material* prev = (material*)((this->frontMaterialsMenu->menu())->user_data());

  svProperty* prop = this->GetFront();

  if(item) {
    material* curr = (material*)(item->user_data());

    cerr << "prev: Ka = { " << prev->Ka[0] << ", " << prev->Ka[1] << ", "
         << prev->Ka[2] << ", " << prev->Ka[3] << " }\n"
         << "prev: Kd = { " << prev->Kd[0] << ", " << prev->Kd[1] << ", "
         << prev->Kd[2] << ", " << prev->Kd[3] << " }\n"
         << "prev: Ks = { " << prev->Ks[0] << ", " << prev->Ks[1] << ", "
         << prev->Ks[2] << ", " << prev->Ks[3] << " }\n"
         << "prev: Se = " << prev->Se << "\n";
    cerr << "curr: Ka = { " << curr->Ka[0] << ", " << curr->Ka[1] << ", "
         << curr->Ka[2] << ", " << curr->Ka[3] << " }\n"
         << "curr: Kd = { " << curr->Kd[0] << ", " << curr->Kd[1] << ", "
         << curr->Kd[2] << ", " << curr->Kd[3] << " }\n"
         << "curr: Ks = { " << curr->Ks[0] << ", " << curr->Ks[1] << ", "
         << curr->Ks[2] << ", " << curr->Ks[3] << " }\n"
         << "curr: Se = " << curr->Se << "\n";

    prev->Ka[3] = prev->Kd[3] = prev->Ks[3] = prop->GetOpacity();
    prev->Se = prop->GetShininess();

    prop->SetOpacity(curr->Kd[3]);
    prop->SetShininess(curr->Se);

    GLfloat mag = 0.f;

    mag = prop->GetAmbient();
    prop->GetAmbientColor(prev->Ka);
    for(int i=0; i<3; i++) prev->Ka[i] *= mag;
    mag = (MAX3(curr->Ka)<0.2 ? 0.2 : MAX3(curr->Ka));
    prop->SetAmbient(mag);
    prop->SetAmbientColor(curr->Ka[0]/mag, curr->Ka[1]/mag, curr->Ka[2]/mag);

    mag = prop->GetDiffuse();
    prop->GetDiffuseColor(prev->Kd);
    for(int i=0; i<3; i++) prev->Kd[i] *= mag;
    mag = (MAX3(curr->Kd)<0.8 ? 0.8 : MAX3(curr->Kd));
    prop->SetDiffuse(mag);
    prop->SetDiffuseColor(curr->Kd[0]/mag, curr->Kd[1]/mag, curr->Kd[2]/mag);

    mag = prop->GetSpecular();
    prop->GetSpecularColor(prev->Ks);
    for(int i=0; i<3; i++) prev->Ks[i] *= mag;
    mag = (MAX3(curr->Ks)<=0.f ? 0.f : MAX3(curr->Ks));
    prop->SetSpecular(mag);
    prop->SetSpecularColor(curr->Ks[0]/mag, curr->Ks[1]/mag, curr->Ks[2]/mag);

    this->UpdateFront();
  }
}

inline void
svFacePropertiesViewUI::BackMaterialMenuCb()
{
  const Fl_Menu_Item* item = this->backMaterialsMenu->mvalue();
  material* prev = (material*)((this->backMaterialsMenu->menu())->user_data());

  svProperty* prop = this->GetBack();

  if(item) {
    material* curr  = (material*)(item->user_data());

    cerr << "prev: Ka = { " << prev->Ka[0] << ", " << prev->Ka[1] << ", "
         << prev->Ka[2] << ", " << prev->Ka[3] << " }\n"
         << "prev: Kd = { " << prev->Kd[0] << ", " << prev->Kd[1] << ", "
         << prev->Kd[2] << ", " << prev->Kd[3] << " }\n"
         << "prev: Ks = { " << prev->Ks[0] << ", " << prev->Ks[1] << ", "
         << prev->Ks[2] << ", " << prev->Ks[3] << " }\n"
         << "prev: Se = " << prev->Se << "\n";
    cerr << "curr: Ka = { " << curr->Ka[0] << ", " << curr->Ka[1] << ", "
         << curr->Ka[2] << ", " << curr->Ka[3] << " }\n"
         << "curr: Kd = { " << curr->Kd[0] << ", " << curr->Kd[1] << ", "
         << curr->Kd[2] << ", " << curr->Kd[3] << " }\n"
         << "curr: Ks = { " << curr->Ks[0] << ", " << curr->Ks[1] << ", "
         << curr->Ks[2] << ", " << curr->Ks[3] << " }\n"
         << "curr: Se = " << curr->Se << "\n";

    prev->Ka[3] = prev->Kd[3] = prev->Ks[3] = prop->GetOpacity();
    prev->Se = prop->GetShininess();

    prop->SetOpacity(curr->Kd[3]);
    prop->SetShininess(curr->Se);

    GLfloat mag = 0.f;

    mag = prop->GetAmbient();
    prop->GetAmbientColor(prev->Ka);
    for(int i=0; i<3; i++) prev->Ka[i] *= mag;
    mag = (MAX3(curr->Ka)<0.2 ? 0.2 : MAX3(curr->Ka));
    prop->SetAmbient(mag);
    prop->SetAmbientColor(curr->Ka[0]/mag, curr->Ka[1]/mag, curr->Ka[2]/mag);

    mag = prop->GetDiffuse();
    prop->GetDiffuseColor(prev->Kd);
    for(int i=0; i<3; i++) prev->Kd[i] *= mag;
    mag = (MAX3(curr->Kd)<0.8 ? 0.8 : MAX3(curr->Kd));
    prop->SetDiffuse(mag);
    prop->SetDiffuseColor(curr->Kd[0]/mag, curr->Kd[1]/mag, curr->Kd[2]/mag);

    mag = prop->GetSpecular();
    prop->GetSpecularColor(prev->Ks);
    for(int i=0; i<3; i++) prev->Ks[i] *= mag;
    mag = (MAX3(curr->Ks)<=0.f ? 0.f : MAX3(curr->Ks));
    prop->SetSpecular(mag);
    prop->SetSpecularColor(curr->Ks[0]/mag, curr->Ks[1]/mag, curr->Ks[2]/mag);

    this->UpdateBack();
  }
}

inline void
svFacePropertiesViewUI::SetFrontRed()
{
  (this->GetFront())->SetRed(GLfloat(this->frontRed->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontGreen()
{
  (this->GetFront())->SetGreen(GLfloat(this->frontGreen->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontBlue()
{
  (this->GetFront())->SetBlue(GLfloat(this->frontBlue->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontOpacity()
{
  (this->GetFront())->SetOpacity(GLfloat(this->frontOpacity->value()));
  this->FacePropertiesView->redraw();
}

inline void
svFacePropertiesViewUI::SetFrontAmbient()
{
  (this->GetFront())->SetAmbient(GLfloat(this->frontAmbient->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontDiffuse()
{
  (this->GetFront())->SetDiffuse(GLfloat(this->frontDiffuse->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontSpecular()
{
  (this->GetFront())->SetSpecular(GLfloat(this->frontSpecular->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontShininess()
{
  (this->GetFront())->SetShininess(GLfloat(this->frontShininess->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontAmbientRed()
{
  (this->GetFront())->SetAmbientRed(GLfloat(this->frontAmbientRed->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontAmbientGreen()
{
  (this->GetFront())->SetAmbientGreen(GLfloat(this->frontAmbientGreen->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontAmbientBlue()
{
  (this->GetFront())->SetAmbientBlue(GLfloat(this->frontAmbientBlue->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontDiffuseRed()
{
  (this->GetFront())->SetDiffuseRed(GLfloat(this->frontDiffuseRed->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontDiffuseGreen()
{
  (this->GetFront())->SetDiffuseGreen(GLfloat(this->frontDiffuseGreen->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontDiffuseBlue()
{
  (this->GetFront())->SetDiffuseBlue(GLfloat(this->frontDiffuseBlue->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontSpecularRed()
{
  (this->GetFront())->SetSpecularRed(GLfloat(this->frontSpecularRed->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontSpecularGreen()
{
  (this->GetFront())->SetSpecularGreen(GLfloat(this->frontSpecularGreen->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetFrontSpecularBlue()
{
  (this->GetFront())->SetSpecularBlue(GLfloat(this->frontSpecularBlue->value()));
  this->UpdateFront();
}

inline void
svFacePropertiesViewUI::SetBackRed()
{
  (this->GetBack())->SetRed(GLfloat(this->backRed->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackGreen()
{
  (this->GetBack())->SetGreen(GLfloat(this->backGreen->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackBlue()
{
  (this->GetBack())->SetBlue(GLfloat(this->backBlue->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackOpacity()
{
  (this->GetBack())->SetOpacity(GLfloat(this->backOpacity->value()));
  this->FacePropertiesView->redraw();
}

inline void
svFacePropertiesViewUI::SetBackAmbient()
{
  (this->GetBack())->SetAmbient(GLfloat(this->backAmbient->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackDiffuse()
{
  (this->GetBack())->SetDiffuse(GLfloat(this->backDiffuse->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackSpecular()
{
  (this->GetBack())->SetSpecular(GLfloat(this->backSpecular->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackShininess()
{
  (this->GetBack())->SetShininess(GLfloat(this->backShininess->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackAmbientRed()
{
  (this->GetBack())->SetAmbientRed(GLfloat(this->backAmbientRed->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackAmbientGreen()
{
  (this->GetBack())->SetAmbientGreen(GLfloat(this->backAmbientGreen->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackAmbientBlue()
{
  (this->GetBack())->SetAmbientBlue(GLfloat(this->backAmbientBlue->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackDiffuseRed()
{
  (this->GetBack())->SetDiffuseRed(GLfloat(this->backDiffuseRed->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackDiffuseGreen()
{
  (this->GetBack())->SetDiffuseGreen(GLfloat(this->backDiffuseGreen->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackDiffuseBlue()
{
  (this->GetBack())->SetDiffuseBlue(GLfloat(this->backDiffuseBlue->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackSpecularRed()
{
  (this->GetBack())->SetSpecularRed(GLfloat(this->backSpecularRed->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackSpecularGreen()
{
  (this->GetBack())->SetSpecularGreen(GLfloat(this->backSpecularGreen->value()));
  this->UpdateBack();
}

inline void
svFacePropertiesViewUI::SetBackSpecularBlue()
{
  (this->GetBack())->SetSpecularBlue(GLfloat(this->backSpecularBlue->value()));
  this->UpdateBack();
}

#endif /* SV_FACEPROPERTIESVIEWUI_CB_H_ */
// 
// End of: $Id: svFacePropertiesViewUI_cb.H,v 1.1.1.1 2006/12/19 22:59:34 christianh Exp $.
// 
