// 
// $Id: svProperties.H,v 1.1.1.1 2006/12/19 22:59:34 christianh Exp $
// 
#ifndef SVPROPERTIES_H_
#  define SVPROPERTIES_H_

#include "vtkProperty.h"
#include "Fl_VTK_Window.H"


class svProperties : public Fl_VTK_Window
{
  vtkProperty* Front;
  vtkProperty* Back;
  int          DistinctBackFace;

public:
  // 
  svProperties(int X, int Y, int W, int H, const char* l=0)
    : Fl_VTK_Window(X,Y,W,H,l),
      Front(vtkProperty::New()), Back(vtkProperty::New()), DistinctBackFace(0)
    { }
  // 
  vtkProperty* GetFront() { return this->Front; }
  vtkProperty* GetBack()  { return this->Back; }
  vtkProperty* CreateBack()
    { if(!this->Back) this->Back = vtkProperty::New(); return this->Back; }
  void         DeleteBack()  { if(this->Back) this->Back->Delete(); }
  // 
  void         DeepCopyFront(vtkProperty* lut)
    { this->Front->DeepCopy(lut); }
  void         DeepCopyBack(vtkProperty* lut)
    { (this->CreateBack())->DeepCopy(lut); }
  // Description:
  // Set the intensity of ambient lighting.
  virtual void    SetAmbient(float r, float g, float b)
    { (this->GetCurrentRenderer())->SetAmbient(r,g,b); }
  virtual void    SetAmbient(float v[3])
    { (this->GetCurrentRenderer())->SetAmbient(v); }
  virtual float*  GetAmbient()
    { return (this->GetCurrentRenderer())->GetAmbient(); }
  virtual void    GetAmbient(float v[3])
    { (this->GetCurrentRenderer())->GetAmbient(v); }
  // Description:
  // Turn on/off two-sided lighting of surfaces. If two-sided lighting is
  // off, then only the side of the surface facing the light(s) will be lit,
  // and the other side dark. If two-sided lighting on, both sides of the 
  // surface will be lit.
  virtual int     GetTwoSidedLighting()
    { return (this->GetCurrentRenderer())->GetTwoSidedLighting(); }
  virtual void    SetTwoSidedLighting(int v)
    { (this->GetCurrentRenderer())->SetTwoSidedLighting(v); }
  virtual void    TwoSidedLightingOn()
    { (this->GetCurrentRenderer())->TwoSidedLightingOn(); }
  virtual void    TwoSidedLightingOff()
    { (this->GetCurrentRenderer())->TwoSidedLightingOff(); }
  // 
  virtual int     GetDistinctBackFace()
    { return this->DistinctBackFace; }
  virtual void    SetDistinctBackFace(int v)
    { this->DistinctBackFace = (v==0 ? 0 : 1); }
  virtual void    DistinctBackFaceOn()
    { this->DistinctBackFace = 1; }
  virtual void    DistinctBackFaceOff()
    { this->DistinctBackFace = 0; }
};
#endif /* SVPROPERTIES_H_ */
// 
// End of: $Id: svProperties.H,v 1.1.1.1 2006/12/19 22:59:34 christianh Exp $.
// 
