// 
// $Id: svSurface.H,v 1.1.1.1 2006/12/19 22:59:35 christianh Exp $
// 
#ifndef SV_SURFACE_H_
#  define SV_SURFACE_H_

#include "vtkDataSet.h"
#include "vtkPolyData.h"
#include "vtkActor.h"
#include "vtkProp.h"
#include "vtkCamera.h"

#define VERTICES_PER_FACE 3


class Surface
{
  char         Name[MAXPATHLEN+1];
  GLdouble     Color[4];
  vtkPolyData* Data;
  svPolyDataFilterSet* PolyDataFilterSet;

public:
  static vtkDataSet*  ReadAsciiToUGrid(char* fname);
  static vtkPolyData* ReadAsciiToPolys(const char* fname);

  static vtkActor*    MakeSurfaceActor(vtkDataSet*, float c[4]);
  static vtkActor*    MakeSurfaceActor(vtkPolyData*, float c[4], bool b=false);

  static vtkActor*    MakeAxesActor(vtkDataSet* dataSet);
  static vtkActor*    MakeAxesActor(float bounds[6]);

  static void MakeCubeAxes(vtkProp* axes, float bounds[6], vtkCamera* camera);

};

#endif /* SV_SURFACE_H_ */
// 
// End of $Id: svSurface.H,v 1.1.1.1 2006/12/19 22:59:35 christianh Exp $.
// 
