// 
// $Id: svTrackball.H,v 1.1.1.1 2006/12/19 22:59:35 christianh Exp $
// 
#ifndef SV_TRACKBALL_H_
#  define SV_TRACKBALL_H_

#  include "svMath.H"

class svTrackball
{
  GLfloat   currentQuat[4];
  GLfloat   lastQuat[4];
  // This size should really be based on the distance from the center of
  // rotation to the point on the object underneath the mouse.  That
  // point would then track the mouse as closely as possible.  This is a
  // simple example, though, so that is left as an Exercise for the
  // Programmer.
  GLfloat   BallSize;

public:
  // 
  svTrackball(GLfloat size = 0.84f) : BallSize(size)
    {
      svMath::ScreenToQuat(this->currentQuat, 0.0, 0.0, 0.0, 0.0);
    }
  // 
  void    Set(GLfloat p1x, GLfloat p1y, GLfloat p2x, GLfloat p2y);
  void    IncrementRotation();
  void    GetMatrixFromQuaternion(GLfloat m[4][4]);
};

//
inline void
svTrackball::Set(GLfloat p1x, GLfloat p1y, GLfloat p2x, GLfloat p2y)
{
  svMath::ScreenToQuat(this->lastQuat, p1x,p1y, p2x,p2y);
}

inline void
svTrackball::IncrementRotation()
{
  svMath::AddQuats(this->lastQuat, this->currentQuat, this->currentQuat);
}

inline void
svTrackball::GetMatrixFromQuaternion(GLfloat m[4][4])
{
  svMath::QuatToMatrix(m, this->currentQuat);
}

#endif /* SV_TRACKBALL_H_ */
