/* -*- C++ -*-
 * 
 * $Id: svUI_cb.cxx,v 1.1.1.1 2006/12/19 22:59:35 christianh Exp $
 * 
 * 
 * Copyright (c) 2002 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include <cerrno>
#include <cstring>
#include <sys/param.h>
#include <iostream>

#include "vtkActor.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkRendererCollection.h"
#include "vtkCubeAxesActor2D.h"

#include <FL/Fl.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Color_Chooser.H>

#include "sv.H"
#include "svUI.H"
#include "svLoadUI.H"
#include "Surface.H"
#include "svUtils.H"


void
svUI::init()
{
  this->savedName       = 0; // NULL
  this->savedFormat     = SV_NONE;
  this->savedScale      = 1; // int [1..32]
  this->currentRGBA[0]  = 1.f;
  this->currentRGBA[1]  = 0.f;
  this->currentRGBA[2]  = 0.f;
  this->currentRGBA[3]  = 1.f;
  this->RenderWindow    = 0; // NULL
  this->Renderer        = 0; // NULL
  this->ActorCollection = 0; // NULL
  this->loadUI = new svLoadUI;
}

void
svUI::Show()
{
  this->mainWindow->show();

  int x = this->mainWindow->x() + this->mainWindow->w();
  int y = this->mainWindow->y();

  this->viewWindow->position(x,y);
  this->viewWindow->show();
}

void
svUI::Show(int argc,char* argv[])
{
  this->mainWindow->show(argc,argv);

  int x = this->mainWindow->x() + this->mainWindow->w();
  int y = this->mainWindow->y();

  this->viewWindow->position(x,y);
  this->viewWindow->show(argc,argv);
}

void
svUI::Hide()
{
  this->mainWindow->hide();
  this->viewWindow->hide();
}

void
svUI::ShowView()
{
  this->viewWindow->show();
}

void
svUI::HideView()
{
  this->viewWindow->hide();
  this->mainWindow->take_focus();
  Fl::check();
}

void
svUI::ShowExit()
{
  int x =
    this->viewWindow->x() + this->viewWindow->w()/2 - this->exitWindow->w()/2;
  int y =
    this->viewWindow->y() + this->viewWindow->h()/2 - this->exitWindow->h()/2;

  if(x<0 || x > (Fl::w()-this->exitWindow->w()))
    x = Fl::w()/2 - this->exitWindow->w()/2;
  if(y<0 || y > (Fl::h()-this->exitWindow->h()))
    y = Fl::h()/2 - this->exitWindow->h()/2;

  this->exitWindow->position(x,y);
  this->exitWindow->show();
}

void
svUI::HideExit()
{
  this->exitWindow->hide();
  this->mainWindow->take_focus();
  Fl::check();
}

int
svUI::Shown()
{
  return this->mainWindow->shown();
}


void
svUI::SaveCb()
{
  if(this->viewWindow->shown()) {
    if(!(this->savedName=fl_file_chooser("Save to:",0,this->savedName))) {
      return;
    }
    Fl::check();

    char* sfx = strrchr(this->savedName,'.');
    this->savedFormat = GetImageFormatFromSuffix(sfx+1);

    SaveWindow(this->viewArea,this->savedName,this->savedFormat,this->savedScale);
  }
}

void
svUI::LoadCb()
{
  this->loadUI->Show();
}

void
svUI::LoadActorsCb()
{
  if(this->RenderWindow && this->Renderer) {
    
    const char* name   = 0;
    bool        filter = true;
    if(name = fl_input("Enter 'ASCII' surface name:","")) {
      // give FLTK a chance ...
      Fl::check();
      // create surface actor
      vtkActor* actor = GetSurfaceActor(name, this->currentRGBA, filter);
      // give FLTK a chance ...
      Fl::check();
      this->Renderer->AddActor(actor);
      cerr << "Added Actor: (" << actor << ")\n";
      this->Interactor->Render();
      
#if 0
      vtkActorCollection* ac = this->Renderer->GetActors();
      ac->InitTraversal();
      if(actor = ac->GetNextActor()) {
        vtkCubeAxesActor2D* cubeAxes = vtkCubeAxesActor2D::New();
        cubeAxes->SetProp(actor);
        cubeAxes->SetCamera(this->Renderer->GetActiveCamera());
        cubeAxes->SetLabelFormat("%+.1f");
        cubeAxes->ShadowOn();
        cubeAxes->SetFlyModeToOuterEdges();
        // cubeAxes->SetFontFactor(0.8);
        cubeAxes->SetCornerOffset(0.05f);
        (cubeAxes->GetProperty())->SetColor(1.f, 1.f, 1.f);
        (cubeAxes->GetProperty())->SetOpacity(0.8f);
        this->Renderer->AddProp(cubeAxes);
        // update the render window
        this->Interactor->Render();
        Fl::check();
      }
#endif /* 0 */
    }
  }
}

void
svUI::SetInputColor()
{
  double rgb[3];
  for(int n=0; n<3; n++) rgb[n] = double(this->currentRGBA[n]);
  if(fl_color_chooser("SV: surface color", rgb[0], rgb[1], rgb[2])) {
    Fl_Color c=fl_rgb_color(int(rgb[0]*0xff),int(rgb[1]*0xff),int(rgb[2]*0xff));
    this->surfColorButton->color(c,fl_darker(c));
    for(int n=0; n<3; n++) this->currentRGBA[n] = float(rgb[n]);
  }
}

// EOF
