/* 
 * g++ -g -Wno-deprecated -I/usr/local/include/vtk -c 3DMorph.cxx
 * 
 * g++ -g -L/usr/local/lib/vtk 3DMorph.o -o 3DMorph \
 *   -lvtkHybrid -lvtkRendering -lvtkGraphics -lvtkFiltering -lvtkCommon
 *
 */
#include <cstdlib>
#include <cstring>
// VTK Rendering
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkCamera.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
// VTK Hybrid
#include "vtkVectorText.h"
#include "vtkImplicitModeller.h"
// VTK Graphics
#include "vtkSuperquadricSource.h"
#include "vtkInterpolateDataSetAttributes.h"
#include "vtkContourFilter.h"
#include "vtkPolyDataNormals.h"

// 
// use implicit modeller / interpolation to perform 3D morphing
// 

static void
Animate(vtkRenderWindow* rw, vtkInterpolateDataSetAttributes* interp, int m, int n=4)
{
  float t, subIters=float(n);

  for(int i=0; i<m; i++) {
    for(int j=1; j<=subIters; j++) {
      t = float(i) + float(j)/subIters;
      interp->SetT(t);
      rw->Render();
    }
  }
}

static vtkInterpolateDataSetAttributes*
CreateTextMorpher(const char* str)
{
  int length = int(strlen(str));
  char letter[2] = { '\0', '\0' };

  // Interpolate the data
  vtkInterpolateDataSetAttributes* interpolate =
    vtkInterpolateDataSetAttributes::New();
  {
    for(int n=0; n<length; n++) {
      letter[0] = str[n];
      // create implicit model of the letter
      vtkImplicitModeller* pImplicitModeller = vtkImplicitModeller::New();
      {
        // make the vector representation
        vtkVectorText* pVectorText = vtkVectorText::New();
        pVectorText->SetText(letter);
        pImplicitModeller->SetInput(pVectorText->GetOutput());
        pImplicitModeller->SetMaximumDistance(0.2);
        pImplicitModeller->SetSampleDimensions(40, 40, 20);
        pImplicitModeller->SetModelBounds(-0.5, 1.5, -0.5, 1.5, -0.75, 0.75);
        pVectorText->Delete();
      }

      interpolate->AddInput(pImplicitModeller->GetOutput());
      pImplicitModeller->Delete();
    }

    float scale = 0.9;

    vtkImplicitModeller* pImplicitModeller = vtkImplicitModeller::New();
    {
      vtkSuperquadricSource* pSuperquadricSource = vtkSuperquadricSource::New();
      {
        pSuperquadricSource->ToroidalOff();
        pSuperquadricSource->SetThetaResolution(8);
        pSuperquadricSource->SetPhiResolution(8);
        pSuperquadricSource->SetPhiRoundness(2.0);
        pSuperquadricSource->SetThetaRoundness(3.0);
        pSuperquadricSource->SetScale(scale, scale, scale);
        pSuperquadricSource->SetCenter(0.5, 0.5, 0.0);
      }
      pImplicitModeller->SetInput(pSuperquadricSource->GetOutput());
      pImplicitModeller->SetMaximumDistance(0.2);
      pImplicitModeller->SetSampleDimensions(40, 40, 20);
      pImplicitModeller->SetModelBounds(-0.5, 1.5, -0.5, 1.5, -0.75, 0.75);
      pSuperquadricSource->Delete();
    }
    interpolate->AddInput(pImplicitModeller->GetOutput());
    pImplicitModeller->Delete();

    interpolate->SetT(0.0);
  }

  return interpolate;
}

int
main(int argc, char* argv[])
{
  const char* ptr;
  int iter = 8;

  if(argc>1) {
    ptr = argv[1];
    if(argc>2) {
      iter = atoi(argv[2]);
    }
  }
  else {
    ptr = "VTK";
  }

  vtkInterpolateDataSetAttributes* interpolate = CreateTextMorpher(ptr);

  // extract an iso surface
  vtkPolyDataNormals* blobbyNormals = vtkPolyDataNormals::New();
  {
    vtkContourFilter* blobbyIso = vtkContourFilter::New();
    {
      blobbyIso->SetInput(interpolate->GetOutput());
      blobbyIso->SetValue(0, 0.1);
      interpolate->Delete();
    }
    blobbyNormals->SetInput(blobbyIso->GetOutput());
    blobbyIso->Delete();
  }

  // map to rendering primitives
  vtkPolyDataMapper* blobbyMapper = vtkPolyDataMapper::New();
  {
    blobbyMapper->SetInput(blobbyNormals->GetOutput());
    blobbyMapper->ScalarVisibilityOff();
  }
  blobbyNormals->Delete();

  // polished copper
  float Ka1[3] = { 0.229500, 0.088250, 0.027500 };
  float Kd1[4] = { 0.550800, 0.211800, 0.066000, 1.000000 };
  float Ks1[3] = { 0.580594, 0.223257, 0.069570 };
  float Se1    = 51.200001;
  // ruby
  float Ka2[3] = { 0.174500, 0.011750, 0.011750 };
  float Kd2[4] = { 0.614240, 0.041360, 0.041360, 0.550000 };
  float Ks2[3] = { 0.727811, 0.626959, 0.626959 };
  float Se2    = 51.200001;

  // now an actor
  vtkActor* blobby = vtkActor::New();
  {
    blobby->SetMapper(blobbyMapper);
    blobby->GetProperty()->SetAmbient(1.0);
    blobby->GetProperty()->SetDiffuse(1.0);
    blobby->GetProperty()->SetSpecular(1.0);
    blobby->GetProperty()->SetAmbientColor(Ka1);
    blobby->GetProperty()->SetDiffuseColor(Kd1);
    blobby->GetProperty()->SetSpecularColor(Ks1);
    blobby->GetProperty()->SetSpecularPower(Se1);
    blobby->GetProperty()->SetOpacity(Kd1[3]);
  }
  blobbyMapper->Delete();

  // 
  // Create the RenderWindow, Renderer and both Actors
  // 
  vtkRenderer* ren1 = vtkRenderer::New();
  vtkRenderWindow* renWin = vtkRenderWindow::New();
  renWin->AddRenderer(ren1);
  vtkRenderWindowInteractor* iren = vtkRenderWindowInteractor::New();
  iren->SetRenderWindow(renWin);

  vtkCamera* camera = vtkCamera::New();
  {
    camera->SetClippingRange(0.265, 13.2);
    camera->SetFocalPoint(0.6667, 0.47464, 0.0);
    camera->SetPosition(2.0, 4.0, 4.0);
    camera->SetViewUp(0.0, 1.0, 0.0);
  }
  ren1->SetActiveCamera(camera);

  // now  make a renderer and tell it about lights and actors
  renWin->SetSize(300, 350);
  
  ren1->AddActor(blobby);
  ren1->SetBackground(0.1, 0.2, 0.3);
  renWin->Render();

  Animate(renWin, interpolate, strlen(ptr), iter);

  // render the image
  iren->Start();

  blobby->Delete();
  camera->Delete();
  ren1->Delete();
  renWin->Delete();
  iren->Delete();
}
