#ifndef _SURFACE_GLOM_PARALLEL_H_
#  define _SURFACE_GLOM_PARALLEL_H_
#  include <list>
#  include <string>

#  include "vtkMultiProcessController.h"
#  include "vtkPolyDataSource.h"

typedef std::list<std::string>     StringList;
typedef StringList&                StringListRef;
typedef StringList*                StringListPtr;
typedef StringList::iterator       StringListIter;
typedef StringList::const_iterator StringListConstIter;

typedef void (*TaskFunction)(StringListRef inputArgs);

static const int originalPortId  = 1;
static const int originalPortTag = 10000;
static const int glommedPortId   = 2;
static const int glommedPortTag  = 10002;

void SurfaceGlommer0(StringListRef inputArgs);
void SurfaceGlommer1(StringListRef inputArgs);
void SurfaceGlommer2(StringListRef inputArgs);
  
static const int WINDOW_WIDTH  = 512; 
static const int WINDOW_HEIGHT = 384; 

#endif /* _SURFACE_GLOM_PARALLEL_H_ */
