/* 
 * $Id: SurfaceGlommer1.cxx,v 1.1.1.1 2006/12/19 22:59:39 christianh Exp $
 * 
 */
#include <iostream>
// VTK Graphics
#include "vtkAppendPolyData.h"
#if 1
#  include "vtkPolyDataStreamer.h"
#endif /* 0 */
// vtkExtensions
#include "vtkPolyDataFileSource.h"
// SV
#include "svController.H"
// SurfaceGlommer
#include "SurfaceGlomParallel.H"
// VTK Parallel
#include "vtkOutputPort.h"


// SurfaceGlommer 1 for SurfaceGlomParallel.
// See SurfaceGlomParallel.cxx for more information.
void
SurfaceGlommer1(StringListRef inputArgs)
{
  // Output port
  vtkOutputPort* pOutputPort = vtkOutputPort::New();
  {
    vtkAppendPolyData* pAppender = 0;
#if 1
    vtkPolyDataStreamer* pStreamer = 0;
#endif /* 0 */

    if(inputArgs.empty()) {
      vtkGenericWarningMacro(<< "SurfaceGlommer0(): filename list is empty!");
    }
    else {
      // Create the AppendFilter and add the inputs to it.
      pAppender = vtkAppendPolyData::New();
      {
	vtkPolyDataFileSource* pSource;
	StringListConstIter    s;

	for(s=inputArgs.begin(); s!=inputArgs.end(); s++) {
	  if((*s) == "-i") {
	    for(s++; s!=inputArgs.end() && (*s).substr(0,1)!="-"; s++) {
	      if(pSource = sv.MakeSurfaceDataSource((*s).c_str())) {
		pAppender->AddInput(pSource->GetOutput());
	      }
	      else {
		vtkGenericWarningMacro(<< "SurfaceGlommer0(): failed to make"
				       << " surface data source from \""
				       << (*s) << "\"!");
	      }
	    }
	  }
	}
      }
      // Make sure that there is at least one valid input.
      if(pAppender->GetNumberOfInputs() > 1) {
#if 1
	pStreamer = vtkPolyDataStreamer::New();
	pStreamer->SetInput(pAppender->GetOutput());
	// Clean up.
	pAppender->Delete();
#else
	// If there was more than one input, make the streamer ask for 
	// a different piece from each of its inputs.
	pAppender->SetParallelStreaming();
#endif /* 0 */
      }
      else if(pAppender->GetNumberOfInputs() < 1) {
	vtkGenericWarningMacro(<< "SurfaceGlommer0(): poly data appender"
			       << " received no valid inputs!");
	// Clean up.
	pAppender->Delete();
	pAppender = 0;
      }
    }
#if 1
    if(pStreamer) {
      pOutputPort->SetInput(pAppender->GetOutput());
      // Clean up.
      pStreamer->Delete();
    }
    // If we have an appender full of inputs, plug it in ...
    else if(pAppender) {
#else
    // If we have an appender full of inputs, plug it in ...
    if(pAppender) {
#endif /* 0 */
      pOutputPort->SetInput(pAppender->GetOutput());
      // Clean up.
      pAppender->Delete();
    }
    // 
    pOutputPort->SetTag(originalPortTag);
    // Process requests
    pOutputPort->WaitForUpdate();
  }

  // Clean up.
  pOutputPort->Delete();
}

/* 
 * End of: $Id: SurfaceGlommer1.cxx,v 1.1.1.1 2006/12/19 22:59:39 christianh Exp $.
 * 
 */
