/* 
 * $Id: Task1.cxx,v 1.1.1.1 2006/12/19 22:59:39 christianh Exp $
 * 
 */
#include "TestParallel.H"

#include "vtkImageData.h"
#include "vtkPolyData.h"
#include "vtkAppendPolyData.h"
#include "vtkInputPort.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkPolyDataMapper.h"

// Task 1 for TestParallel.
// See TestParallel.cxx for more information.
void
Task1(double data)
{
  double extent = data;
  int iextent = static_cast<int>(data);

  // Input port
  vtkInputPort* pInputPort = vtkInputPort::New();
  {
    pInputPort->SetRemoteProcessId(1);
    pInputPort->SetTag(11);
  }

  // Rendering objects.
  vtkActor* pActor = vtkActor::New();
  {
    vtkPolyDataMapper* pPolyDataMapper = vtkPolyDataMapper::New();
    {
      // Append the local and remote data
      vtkAppendPolyData* pAppendPolyData = vtkAppendPolyData::New();
      {
        // Probe magnitude with iso-surface.
        vtkProbeFilter* pProbeFilter = vtkProbeFilter::New();
        {
          // Synthetic image source.
          vtkRTAnalyticSource* pRTAnalyticSource = vtkRTAnalyticSource::New();
          {
            pRTAnalyticSource->SetWholeExtent( -1*iextent, iextent,
                                               -1*iextent, iextent, 
                                               -1*iextent, iextent );
            pRTAnalyticSource->SetCenter(0, 0, 0);
            pRTAnalyticSource->SetStandardDeviation( 0.5 );
            pRTAnalyticSource->SetMaximum( 255.0 );
            pRTAnalyticSource->SetXFreq( 60 );
            pRTAnalyticSource->SetXMag( 10 );
            pRTAnalyticSource->SetYFreq( 30 );
            pRTAnalyticSource->SetYMag( 18 );
            pRTAnalyticSource->SetZFreq( 40 );
            pRTAnalyticSource->SetZMag( 5 );
            pRTAnalyticSource->GetOutput()->
              SetSpacing(2.0/extent, 2.0/extent, 2.0/extent);
          }
          // Iso-surfacing.
          vtkContourFilter* pContourFilter = vtkContourFilter::New();
          {
            pContourFilter->SetInput(pRTAnalyticSource->GetOutput());
            pContourFilter->SetNumberOfContours(1);
            pContourFilter->SetValue(0, 220);
          }
          // Magnitude of the gradient vector.
          vtkImageGradientMagnitude* pGradientMagnitude =
            vtkImageGradientMagnitude::New();
          {
            pGradientMagnitude->SetInput(pRTAnalyticSource->GetOutput());
            pGradientMagnitude->SetDimensionality(3);
          }
          pProbeFilter->SetInput(pContourFilter->GetOutput());
          pProbeFilter->SetSource(pGradientMagnitude->GetOutput());
          pProbeFilter->SpatialMatchOn();
          // Clean up.
          pRTAnalyticSource->Delete();
          pContourFilter->Delete();
          pGradientMagnitude->Delete();
        }
        pAppendPolyData->AddInput(pInputPort->GetPolyDataOutput());
        pAppendPolyData->AddInput(pProbeFilter->GetPolyDataOutput());
        // Clean up.
        pProbeFilter->Delete();
      }
      pPolyDataMapper->SetInput(pAppendPolyData->GetOutput());
      pPolyDataMapper->SetScalarRange(50, 180);
      pPolyDataMapper->ImmediateModeRenderingOn();
      // Clean up.
      pAppendPolyData->Delete();
    }
    pActor->SetMapper(pPolyDataMapper);
    // Clean up.
    pPolyDataMapper->Delete();
  }

  // Create the render objects
  vtkRenderWindow* pRenderWindow = vtkRenderWindow::New();
  pRenderWindow->SetSize(WINDOW_WIDTH, WINDOW_HEIGHT);

  vtkRenderWindowInteractor* pInteractor = vtkRenderWindowInteractor::New();
  pInteractor->SetRenderWindow(pRenderWindow);

  vtkRenderer* pRenderer = vtkRenderer::New();
  pRenderWindow->AddRenderer(pRenderer);

  pRenderer->AddActor(pActor);

  pInteractor->Initialize();
  pInteractor->Start();

  // Tell the other process we are done
  pInputPort->GetController()->
    TriggerRMI(1, vtkMultiProcessController::BREAK_RMI_TAG); 

  // Cleanup
  pInputPort->Delete();
  pInteractor->Delete();
  pRenderWindow->Delete();
  pActor->Delete();
  pRenderer->Delete();
}

/* 
 * End of: $Id: Task1.cxx,v 1.1.1.1 2006/12/19 22:59:39 christianh Exp $.
 * 
 */
