/* 
 * $Id: SurfaceWarp.H,v 1.1.1.1 2006/12/19 22:59:40 christianh Exp $
 * 
 */
#ifndef _SURFACE_WARP_H_
#  define _SURFACE_WARP_H_
// STL
#  include <list>
#  include <string>
// VTK Parallel
#  include "vtkCommunicator.h"
#  include "vtkMultiProcessController.h"


typedef std::list<std::string>     StringList;
typedef StringList&                StringListRef;
typedef StringList*                StringListPtr;
typedef StringList::iterator       StringListIter;
typedef StringList::const_iterator StringListConstIter;


static const int mainPortId      = 0;
static const int mainPortTag     = 10000;
static const int originalPortId  = 1;
static const int originalPortTag = 10002;
static const int inflatedPortId  = 2;
static const int inflatedPortTag = 10004;
static const int deflatedPortId  = 3;
static const int deflatedPortTag = 10006;

static const int scalingFractionTag = 10100;
static const int scalingFactorTag   = 10102;
static const int originalBoundsTag  = 10202;


void Warper0(vtkMultiProcessController*, void*);
void Warper1(vtkMultiProcessController*, void*);
void Warper2(vtkMultiProcessController*, void*);
void Warper3(vtkMultiProcessController*, void*);

  
static const int WINDOW_WIDTH  = 512; 
static const int WINDOW_HEIGHT = 512; 

#endif /* _SURFACE_WARP_H_ */
/* 
 * End of: $Id: SurfaceWarp.H,v 1.1.1.1 2006/12/19 22:59:40 christianh Exp $.
 * 
 */
