/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: Warper2.cxx,v 1.1.1.1 2006/12/19 22:59:40 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
// VTK Common
#include "vtkPolyData.h"
// VTK Filtering
#include "vtkDataSetToDataSetFilter.h"
#include "vtkPolyDataSource.h"
// VTK Parallel
#include "vtkInputPort.h"
#include "vtkOutputPort.h"
// SurfaceWarp
#include "SurfaceWarp.H"

extern vtkDataSetToDataSetFilter* CreateInflatedSurface (vtkPolyData*, float);
extern vtkDataSetToDataSetFilter* CreateInflatedSurface2 (vtkPolyData*, float);

// ----------------------------------------------------------------------------
void
Warper2 (vtkMultiProcessController* aController, void* vtkNotUsed(userData))
{
  vtkCommunicator* communicator = aController->GetCommunicator();

  // Input port
  vtkInputPort* originalInputPort = vtkInputPort::New();
    {
    originalInputPort->SetController(aController);
    originalInputPort->SetRemoteProcessId(originalPortId);
    originalInputPort->SetTag(originalPortTag);
    }

  // Output port
  vtkOutputPort* inflatedOutputPort = vtkOutputPort::New();
    {
    float scalingFactor;
    // Blocks until receiving the scaling factor (input data has been read).
    if ( !communicator->Receive( &scalingFactor, 1,
                                 originalPortId, scalingFactorTag ) )
      {
      vtkGenericWarningMacro(<< "Server: Error receiving scaling factor.");
      }
    else
      {
      // Inflate the input data.
      vtkDataSetToDataSetFilter* inflatedSource =
        CreateInflatedSurface2( originalInputPort->GetPolyDataOutput(),
                                scalingFactor );
      // Output port
      inflatedOutputPort->SetInput(inflatedSource->GetPolyDataOutput());
      inflatedSource->Delete();
      // Pass the scaling factor along to the deflater ...
      if ( !communicator->Send( &scalingFactor, 1,
                                deflatedPortId, scalingFactorTag ) )
        {
        vtkGenericWarningMacro(<< "Server: Error sending scaling factor.");
        }
      }
    // Access to the global controller.
    inflatedOutputPort->SetController(aController);
    // Identify this output port of this process.
    inflatedOutputPort->SetTag(inflatedPortTag);
    // Turn this on for pipeline parallelism.
    inflatedOutputPort->PipelineFlagOn();
    // Process requests ...
    inflatedOutputPort->WaitForUpdate();
    }

  originalInputPort->Delete();
  inflatedOutputPort->Delete();
}


/* 
 * End of: $Id: Warper2.cxx,v 1.1.1.1 2006/12/19 22:59:40 christianh Exp $.
 * 
 */
