//|
//| RGBA color button for the Fast Light Tool Kit (FLTK).
//|
//| Copyright 1998-1999 by Vivality llc, Venice, CA, U.S.A. 
//|  and Matthias Melcher.
//|
//| This library is free software; you can redistribute it and/or
//| modify it under the terms of the GNU Library General Public
//| License as published by the Free Software Foundation; either
//| version 2 of the License, or (at your option) any later version.
//|
//| This library is distributed in the hope that it will be useful,
//| but WITHOUT ANY WARRANTY; without even the implied warranty of
//| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//| Library General Public License for more details.
//|
//| You should have received a copy of the GNU Library General Public
//| License along with this library; if not, write to the Free Software
//| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
//| USA.
//|
//| Please report all bugs and problems to "matthias@mediaone.net".
//|


#ifdef MO_ONCE
#pragma once
#endif

#ifndef FL_COLOR_BUTTON_H
#define FL_COLOR_BUTTON_H

#include <FL/Fl_Button.H>


class Fl_Color_Button : public Fl_Button {
  uchar		r_, g_, b_, a_;
  float		r, g, b, a;
  int		th;
  static void	generate_achip(void*, int, int, int, uchar*);
public:
  Fl_Color_Button(int, int, int, int, char const *t=0L);
  void		color(uchar, uchar, uchar, uchar a=255);
  void		color(float, float, float, float a=1.0f);
  void		color(Fl_Color);
  void		color(Fl_Color, Fl_Color);
  void		draw();
};


#endif
