//|
//| RGBA color button for the Fast Light Tool Kit (FLTK).
//|
//| Copyright 1998-1999 by Vivality llc, Venice, CA, U.S.A. 
//|  and Matthias Melcher.
//|
//| This library is free software; you can redistribute it and/or
//| modify it under the terms of the GNU Library General Public
//| License as published by the Free Software Foundation; either
//| version 2 of the License, or (at your option) any later version.
//|
//| This library is distributed in the hope that it will be useful,
//| but WITHOUT ANY WARRANTY; without even the implied warranty of
//| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//| Library General Public License for more details.
//|
//| You should have received a copy of the GNU Library General Public
//| License along with this library; if not, write to the Free Software
//| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
//| USA.
//|
//| Please report all bugs and problems to "matthias@mediaone.net".
//|

#include "Fl_Color_Button.H"
#include <FL/Fl.H>
#include <FL/fl_draw.H>


Fl_Color_Button::Fl_Color_Button(int x, int y, int w, int h, char const *t) 
: Fl_Button(x, y, w, h, t) {
  color(FL_GRAY);
}

void Fl_Color_Button::color(uchar R, uchar G, uchar B, uchar A) {
  r_ = R; g_ = G; b_ = B; a_ = A;
  r = R/255.0f; g = G/255.0f; b = B/255.0f; a = A/255.0f; 
  redraw();
}

void Fl_Color_Button::color(float R, float G, float B, float A) {
  r = R; g = G; b = B; a = A;
  r_ = (uchar)(R*255.0f);
  g_ = (uchar)(G*255.0f);
  b_ = (uchar)(B*255.0f);
  a_ = (uchar)(A*255.0f);
  redraw();
}

void Fl_Color_Button::color(Fl_Color col) {
  Fl_Button::color(col);
  Fl::get_color(col, r_, g_, b_);
}

void Fl_Color_Button::color(Fl_Color col1, Fl_Color col2) {
  color(col1); selection_color(col2);
}

void Fl_Color_Button::draw() {
  if (a_==255) {
  fl_rectf(x()+Fl::box_dx(box()),
	   y()+Fl::box_dy(box()),
	   w()-Fl::box_dw(box()),
	   h()-Fl::box_dh(box()), r_, g_, b_);
  } else {
    th = h()-Fl::box_dh(box());
    fl_draw_image(generate_achip, this, 
	   x()+Fl::box_dx(box()),
	   y()+Fl::box_dy(box()),
	   w()-Fl::box_dw(box()), th);
  }
  draw_box();
  draw_label();
}


void Fl_Color_Button::generate_achip(void* vv, int X, int Y, int W, uchar* buf) {
  Fl_Color_Button *v = (Fl_Color_Button*)vv;
  if (v->th==0) return;
  float a = v->a, ia = 1.0f-a;
  float vr = v->r, vg = v->g, vb = v->b;
  uchar ro = (uchar)(vr*255.0f);
  uchar go = (uchar)(vg*255.0f);
  uchar bo = (uchar)(vb*255.0f);
  uchar rg = (uchar)(255*(a*vr + ia*0.8f));
  uchar gg = (uchar)(255*(a*vg + ia*0.4f));
  uchar bg = (uchar)(255*(a*vb + ia*0.4f));
  uchar r, g, b;
  if ((Y&0x07)==4) {
    r = rg; g = gg; b = bg;
  } else {
    r = (uchar)(255*(a*vr + ia*0.8f));
    g = (uchar)(255*(a*vg + ia*0.8f));
    b = (uchar)(255*(a*vb + ia*0.8f));
  }
  int xa = (int)((float)W/(float)v->th*(float)Y);
  for (int x = X; x < X+W; x++) {
    if (x>xa) {
      if ((x&0x07)==4) {
	*buf++ = rg; *buf++ = gg; *buf++ = bg;
      } else {
	*buf++ = r; *buf++ = g; *buf++ = b;
      }
    } else {
      *buf++ = ro; *buf++ = go; *buf++ = bo;
    }
  }
}

