//|
//| Color chooser for the Fast Light Tool Kit (FLTK).
//|
//| Copyright 1998-1999 by Bill Spitzak, Vivality llc., Venice, 
//| CA, U.S.A., Matthias Melcher and others.
//|
//| This library is free software; you can redistribute it and/or
//| modify it under the terms of the GNU Library General Public
//| License as published by the Free Software Foundation; either
//| version 2 of the License, or (at your option) any later version.
//|
//| This library is distributed in the hope that it will be useful,
//| but WITHOUT ANY WARRANTY; without even the implied warranty of
//| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//| Library General Public License for more details.
//|
//| You should have received a copy of the GNU Library General Public
//| License along with this library; if not, write to the Free Software
//| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
//| USA.
//|
//| Please report all bugs and problems to "matthias@mediaone.net".
//|

// The color chooser object and the color chooser popup.  The popup
// is just a window containing a single color chooser and some boxes
// to indicate the current and cancelled color.

#ifndef Fl_Color_Chooser_A_H
#define Fl_Color_Chooser_A_H

#include <FL/Fl_Group.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Value_Input.H>


#define FL_EXPORT 
class Flcc_HueBox_A : public Fl_Widget {
  FL_EXPORT int handle(int);
  FL_EXPORT void draw();
  int px, py;
public:
  Flcc_HueBox_A(int X, int Y, int W, int H) : Fl_Widget(X,Y,W,H) {
  px = py = 0;}
};

class Flcc_ValueBox_A : public Fl_Widget {
  FL_EXPORT int handle(int);
  FL_EXPORT void draw();
  int py;
public:
  Flcc_ValueBox_A(int X, int Y, int W, int H) : Fl_Widget(X,Y,W,H) {
  py = 0;}
};

class Flcc_AlphaBox_A : public Fl_Widget {
  FL_EXPORT int handle(int);
  FL_EXPORT void draw();
  int py;
public:
  Flcc_AlphaBox_A(int X, int Y, int W, int H) : Fl_Widget(X,Y,W,H) {
  py = 0;}
};

class Flcc_Value_Input_A : public Fl_Value_Input {
public:
  FL_EXPORT int format(char*);
  Flcc_Value_Input_A(int X, int Y, int W, int H) : Fl_Value_Input(X,Y,W,H) {}
};

class Fl_Color_Chooser_A : public Fl_Group {
  Flcc_HueBox_A huebox;
  Flcc_ValueBox_A valuebox;
  Flcc_AlphaBox_A alphabox;
  Fl_Choice choice;
  Flcc_Value_Input_A rvalue;
  Flcc_Value_Input_A gvalue;
  Flcc_Value_Input_A bvalue;
  Flcc_Value_Input_A avalue;
  Fl_Box resize_box;
  double hue_, saturation_, value_;
  double r_, g_, b_, a_;
  uchar hasAlpha;
  FL_EXPORT void set_valuators();
  static FL_EXPORT void rgb_cb(Fl_Widget*, void*);
  static FL_EXPORT void mode_cb(Fl_Widget*, void*);
public:
  int mode() {return choice.value();}
  double hue() const {return hue_;}
  double saturation() const {return saturation_;}
  double value() const {return value_;}
  double r() const {return r_;}
  double g() const {return g_;}
  double b() const {return b_;}
  double a() const {return a_;}
  FL_EXPORT int hsv(double,double,double,double a=-1.0);
  FL_EXPORT int rgb(double,double,double,double a=-1.0);
  static FL_EXPORT void hsv2rgb(double, double, double,double&,double&,double&);
  static FL_EXPORT void rgb2hsv(double, double, double,double&,double&,double&);
  FL_EXPORT Fl_Color_Chooser_A(int,int,int,int,const char* = 0);
};

FL_EXPORT int fl_color_chooser_a(const char* name, double& r, double& g, double& b, double& a);
FL_EXPORT int fl_color_chooser_a(const char* name, uchar& r, uchar& g, uchar& b, uchar& a);

#endif
