/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: LightUI.H,v 1.1.1.1 2006/12/19 22:59:43 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef LIGHT_UI_H_
#  define LIGHT_UI_H_
// FLTK
#  include <FL/Fl.H>
#  include <FL/Fl_Group.H>
#  include <FL/Fl_Value_Input.H>
#  include <FL/Fl_Button.H>
#  include <FL/Fl_Menu_Button.H>
// vtkExtensions
#  include "vtkRenderingContextFwd.h"

class vtkObject;
class vtkLight;
class vtkLightCollection;
class vtkRenderer;

class LightUI : public Fl_Group
{
private:
  Fl_Button             mLightToggle;
  Fl_Menu_Button        mLightTypeMenu;
  Fl_Button             mPositionalToggle;
  Fl_Button             mFollowCameraToggle;

  Fl_Group              mPositionGroup;
  Fl_Value_Input        mPositionX;
  Fl_Value_Input        mPositionY;
  Fl_Value_Input        mPositionZ;
  Fl_End                mPositionEnd;

  Fl_Group              mFocalPointGroup;
  Fl_Value_Input        mFocalPointX;
  Fl_Value_Input        mFocalPointY;
  Fl_Value_Input        mFocalPointZ;
  Fl_End                mFocalPointEnd;

  Fl_Group              mColorGroup;
  Fl_Value_Input        mIntensity;
  Fl_Value_Input        mRed;
  Fl_Value_Input        mGreen;
  Fl_Value_Input        mBlue;
  Fl_End                mColorEnd;

  Fl_Group              mPositionalGroup;
  Fl_Value_Input        mExponent;
  Fl_Value_Input        mConeAngle;
  Fl_Group              mAttenuationGroup;
  Fl_Value_Input        mConstantAttenuation;
  Fl_Value_Input        mLinearAttenuation;
  Fl_Value_Input        mQuadraticAttenuation;
  Fl_End                mAttenuationEnd;
  Fl_End                mPositionalEnd;
  Fl_End                mLightUIEnd;

  VTK_EXTENSIONS_NAMESPACE_QUALIFIER
  vtkRenderingContext*  ClientRenderingContext;

  vtkLight*             Light;

  char*                 Name;

  static Fl_Menu_Item mLightTypeMenuItems[];

  static void LightToggleCb (Fl_Button*, void*);
  static void LightTypeCb (Fl_Menu_Button*, void*);
  static void PositionalToggleCb (Fl_Button*, void*);
  static void FollowCameraToggleCb (Fl_Button*, void*);
  static void PositionXCb (Fl_Value_Input*, void*);
  static void PositionYCb (Fl_Value_Input*, void*);
  static void PositionZCb (Fl_Value_Input*, void*);
  static void FocalPointXCb (Fl_Value_Input*, void*);
  static void FocalPointYCb (Fl_Value_Input*, void*);
  static void FocalPointZCb (Fl_Value_Input*, void*);
  static void IntensityCb (Fl_Value_Input*, void*);
  static void RedCb (Fl_Value_Input*, void*);
  static void GreenCb (Fl_Value_Input*, void*);
  static void BlueCb (Fl_Value_Input*, void*);
  static void ExponentCb (Fl_Value_Input*, void*);
  static void ConeAngleCb (Fl_Value_Input*, void*);
  static void ConstantAttenuationCb (Fl_Value_Input*, void*);
  static void LinearAttenuationCb (Fl_Value_Input*, void*);
  static void QuadraticAttenuationCb (Fl_Value_Input*, void*);

public:
  LightUI (int, int, int, int, const char* = 0);
  ~LightUI() { if (this->Name != (char *) 0) delete [] this->Name; }

  /** Set RenderingContext and Light clients of this interface. */
  void Initialize (VTK_EXTENSIONS_NAMESPACE_QUALIFIER vtkRenderingContext*,
                   vtkLight*);

  /** Bring the client up-to-date with the interface. */
  void          UpdateClientRenderingContext (void);

  /** Get the RenderingContext which is the client of this interface. */
  VTK_EXTENSIONS_NAMESPACE_QUALIFIER vtkRenderingContext*
  GetClientRenderingContext (void);

  /** Get the current Renderer. */
  vtkRenderer*          GetCurrentClientRenderer (void);

  /** Get the current LightCollection. */
  vtkLightCollection*   GetCurrentLights (void);

  /** Get the Light. */
  vtkLight*     GetLight (void);

  /**  */
  void          Send (vtkObject* = 0);

  /**  */
  void          Receive (vtkObject* = 0);

  /**  */
  void          Default (vtkObject* = 0);
};
#endif /* LIGHT_UI_H_ */
/* 
 * End of: $Id: LightUI.H,v 1.1.1.1 2006/12/19 22:59:43 christianh Exp $.
 * 
 */
