/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: SvvHelpCb.cxx,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "svvConfiguration.h"
// SVV widgets
#include "vtkAboutUI.h"
#include "svvMessagesUI.h"
// FLTK
#include <FL/Fl_Widget.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Menu_.H>
#include <FL/Fl_Help_View.H>

// ----------------------------------------------------------------------------
static const char*      docdir_varname  = "SVV_DOC_DIR";
static const char*      docdir_pathname = "/usr/local/doc/svv";

static Fl_Help_View*    sHelpViewer     = NULL;
static vtkAboutUI*      sAboutUI        = NULL;

static void
show_help (const char* aName)
{
  const char* docdir;
  char	      filename[1024/* MAXPATHLEN */];
  
  if (sHelpViewer == NULL)
    {
    sHelpViewer = new Fl_Help_View(128, 64, 768, 576, "Help");
    }

  if ((docdir = getenv(docdir_varname)) == NULL)
    {
    docdir = docdir_pathname;
    }

  (void) snprintf(filename, sizeof filename, "%s/%s", docdir, aName);  

  svvDebug(<< "Help viewer loading: '" << filename << "'");

  sHelpViewer->load(filename);
  sHelpViewer->show();
}

static void
show_about (void)
{
  if (sAboutUI == NULL)
    {
    sAboutUI = vtkAboutUI::New();
    }

  svvDebug(<< "Displaying \"About\" dialog");

  //if (sAboutUI->Shown())
  //  {
  //  sAboutUI->Hide();
  //  }
  //else
  //  {
    sAboutUI->Show();
  //  }
}

// ----------------------------------------------------------------------------
void
SvvHelpUserCb (Fl_Widget*, void*)
{
  show_help("html/index.html");
}

void
SvvHelpUserCb (Fl_Button* aButton, void* aPtr)
{ SvvHelpUserCb(static_cast<Fl_Widget*>(aButton),aPtr); }

void
SvvHelpUserCb (Fl_Menu_* aMenu, void*)
{ SvvHelpUserCb(static_cast<Fl_Widget*>(aMenu), aMenu->user_data()); }

// ----------------------------------------------------------------------------
void
SvvHelpDeveloperCb (Fl_Widget*, void*)
{
  show_help("html/index.html");
}

void
SvvHelpDeveloperCb (Fl_Button* aButton, void* aPtr)
{ SvvHelpDeveloperCb(static_cast<Fl_Widget*>(aButton), aPtr); }

void
SvvHelpDeveloperCb (Fl_Menu_* aMenu, void*)
{ SvvHelpDeveloperCb(static_cast<Fl_Widget*>(aMenu), aMenu->user_data()); }

// ----------------------------------------------------------------------------
void
SvvHelpAboutCb (Fl_Widget*, void*)
{
  show_about();
}

void
SvvHelpAboutCb (Fl_Button* aButton, void* aPtr)
{ SvvHelpAboutCb(static_cast<Fl_Widget*>(aButton), aPtr); }

void
SvvHelpAboutCb (Fl_Menu_* aMenu, void*)
{ SvvHelpAboutCb(static_cast<Fl_Widget*>(aMenu), aMenu->user_data()); }

/* 
 * End of: $Id: SvvHelpCb.cxx,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $.
 * 
 */
