/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: SvvMenuItemType.h,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_MENU_ITEM_TYPE_UI_H_
#  define SVV_MENU_ITEM_TYPE_UI_H_

typedef enum
{
  SVV_MENU_NONE                         = 0x00000000,

  SVV_MENU_FILE_SUBMENU                 = 0x01000000,
  SVV_MENU_FILE_WRITE_IMAGE             = 0x01010000,

  SVV_MENU_FILE_LOAD_SUBMENU            = 0x01020000,
  SVV_MENU_FILE_LOAD_SURFACE            = 0x01020100,
  SVV_MENU_FILE_LOAD_VOLUME             = 0x01020200,
  SVV_MENU_FILE_LOAD_LIST               = 0x01020400,

  SVV_MENU_FILE_SAVE_SUBMENU            = 0x01040000,
  SVV_MENU_FILE_SAVE_SURFACE            = 0x01040100,
  SVV_MENU_FILE_SAVE_VOLUME             = 0x01040200,
  SVV_MENU_FILE_SAVE_LIST               = 0x01040400,

  SVV_MENU_FILE_IMPORT                  = 0x01080000,
  SVV_MENU_FILE_EXPORT                  = 0x01100000,
  SVV_MENU_FILE_EXIT                    = 0x01200000,

  SVV_MENU_VISTAS_SUBMENU               = 0x02000000,

  SVV_MENU_VISTAS_SOURCES_SUBMENU       = 0x02010000,
  SVV_MENU_VISTAS_SOURCES_LOAD_SUBMENU  = 0x02010100,
  SVV_MENU_VISTAS_SOURCES_LOAD_SURFACE  = 0x02010101,
  SVV_MENU_VISTAS_SOURCES_LOAD_VOLUME   = 0x02010102,
  SVV_MENU_VISTAS_SOURCES_LOAD_LIST     = 0x02010104,
  SVV_MENU_VISTAS_SOURCES_REMOVE        = 0x02010200,
  SVV_MENU_VISTAS_SOURCES_SHOW          = 0x02010400,

  SVV_MENU_VISTAS_NODES_SUBMENU         = 0x02020000,
  SVV_MENU_VISTAS_NODES_PROPERTIES      = 0x02020100,
  SVV_MENU_VISTAS_NODES_ATTRIBUTES      = 0x02020200,
  SVV_MENU_VISTAS_NODES_FILTERING       = 0x02020400,
  SVV_MENU_VISTAS_NODES_GROUP           = 0x02020800,
  SVV_MENU_VISTAS_NODES_REMOVE          = 0x02021000,
  SVV_MENU_VISTAS_NODES_SHOW            = 0x02022000,

  SVV_MENU_VISTAS_RENDERER_SUBMENU      = 0x02040000,
  SVV_MENU_VISTAS_RENDERER_LIGHTING     = 0x02040100,
  SVV_MENU_VISTAS_RENDERER_CAMERA       = 0x02040200,
  SVV_MENU_VISTAS_RENDERER_VIEWPORT     = 0x02040400,
  SVV_MENU_VISTAS_RENDERER_SHOW         = 0x02040800,

  SVV_MENU_VISTAS_MESSAGE_CONSOLE       = 0x02080000,

  SVV_MENU_HELP_SUBMENU                 = 0x04000000,
  SVV_MENU_HELP_USER                    = 0x04010000,
  SVV_MENU_HELP_DEVELOPER               = 0x04020000,
  SVV_MENU_HELP_ABOUT                   = 0x04040000

} SvvMenuItemType;

#endif /* SVV_MENU_ITEM_TYPE_UI_H_ */
/*
 * End of: $Id: SvvMenuItemType.h,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $.
 *
 */
