/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: SvvToolBarMenu.cxx,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "SvvToolBarMenu.h"

/*
 * struct Fl_Menu_Item
 * {
 *   const char*        text; // label()
 *   ulong              shortcut_;
 *   Fl_Callback*       callback_;
 *   void*              user_data_;
 *   int                flags;
 *   uchar              labeltype_;
 *   uchar              labelfont_;
 *   uchar              labelsize_;
 *   uchar              labelcolor_;
 * };
 *
 */

Fl_Menu_Item* SvvToolBarViewsSubmenu[16] = { {0} };

Fl_Menu_Item SvvToolBarMenu[] =
{
  {"&File", 0, NULL, NULL, FL_SUBMENU},
  {"&Write Image", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_WRITEIMAGE, FL_MENU_DIVIDER},
  {"Surface", 0, NULL, NULL, FL_SUBMENU},
  {"Add", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_ADD_SURFACE, 0},
  {"Save", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_SAVE_SURFACE, 0},
  {0},

  {"Volume", 0, NULL, NULL, FL_SUBMENU|FL_MENU_DIVIDER},
  {"Add", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_ADD_VOLUME, 0},
  {"Save", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_SAVE_VOLUME, 0},
  {0},

  {"Dave ...", 0, NULL, NULL, FL_SUBMENU},
  {"Load", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_DAVE_LOAD, 0},
  {"Save", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_DAVE_SAVE, 0},
  {0},

  {"Scene", 0, NULL, NULL, FL_SUBMENU},
  {"&Import", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_SCENE_IMPORT, 0},
  {"&Export", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_SCENE_EXPORT, 0},
  {0},

  {"Session", 0, NULL, NULL, FL_SUBMENU|FL_MENU_DIVIDER},
  {"Restore", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_SESSION_RESTORE, 0},
  {"Record", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_SESSION_RECORD, 0},
  {0},

  {"E&xit", 0,
   (Fl_Callback *) VtkAbstractToolBarFileMenuCb,
   (void *) SVV_FILE_EXIT, 0},
  {0},

  {"&Node", 0, NULL, NULL, FL_SUBMENU},
  {"&Properties", 0,
   (Fl_Callback *) VtkAbstractToolBarNodesMenuCb,
   (void *) SVV_NODE_PROPERTIES, 0},
  {"&Attributes", 0,
   (Fl_Callback *) VtkAbstractToolBarNodesMenuCb,
   (void *) SVV_NODE_ATTRIBUTES, 0},
  {"&Filtering", 0,
   (Fl_Callback *) VtkAbstractToolBarNodesMenuCb,
   (void *) SVV_NODE_FILTERING, FL_MENU_DIVIDER},
  {"&Group", 0,
   (Fl_Callback *) VtkAbstractToolBarNodesMenuCb,
   (void *) SVV_NODE_GROUP, FL_MENU_DIVIDER},
  {"Promote", 0,
   (Fl_Callback *) VtkAbstractToolBarNodesMenuCb,
   (void *) SVV_NODE_PROMOTE, 0},
  {"Demote", 0,
   (Fl_Callback *) VtkAbstractToolBarNodesMenuCb,
   (void *) SVV_NODE_DEMOTE, FL_MENU_DIVIDER},
  {"Remove", 0,
   (Fl_Callback *) VtkAbstractToolBarNodesMenuCb,
   (void *) SVV_NODE_REMOVE, 0},
  {0},

  {"&Renderer", 0, NULL, NULL, FL_SUBMENU},
  {"interface", 0, NULL, NULL, FL_SUBMENU},
  {"&Lighting", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_INTERFACE_LIGHTING, 0},
  {"&Camera", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_INTERFACE_CAMERA, 0},
  {"&Viewport", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_INTERFACE_VIEWPORT, 0},
  {"&Tree", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_INTERFACE_TREE, 0},
  {"Create", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_INTERFACE_CREATE, FL_MENU_INACTIVE},
  {0},

  {"interaction", 0, NULL, NULL, FL_SUBMENU},
  {"Inertia", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_INTERACTION_INERTIA, FL_MENU_TOGGLE|FL_MENU_VALUE},
  {"Rotation", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_INTERACTION_ROTATION, FL_MENU_TOGGLE|FL_MENU_VALUE},
  {"Translation", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_INTERACTION_TRANSLATION, FL_MENU_TOGGLE|FL_MENU_VALUE},
  {"Scaling", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_INTERACTION_SCALING, FL_MENU_TOGGLE|FL_MENU_VALUE},
  {0},

  {"context", 0, NULL, NULL, FL_SUBMENU},
  {"Axes", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_CONTEXT_AXES, FL_MENU_TOGGLE},
  {"Bounding Box", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_CONTEXT_BOUNDINGBOX, FL_MENU_TOGGLE},
  {0},

  {"Depth Sort", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SVV_RENDERER_DEPTHSORT, FL_MENU_DIVIDER|FL_MENU_TOGGLE},
  {"Views", 0,
   (Fl_Callback *) VtkAbstractToolBarRendererMenuCb,
   (void *) SvvToolBarViewsSubmenu, FL_SUBMENU_POINTER},
  {0},

  {"&Help", 0, NULL, NULL, FL_SUBMENU},
  {"Message Console", 0,
   (Fl_Callback *) VtkAbstractToolBarHelpMenuCb,
   (void *) WIDGETS_HELP_MESSAGES, FL_MENU_DIVIDER},
  {"User Guide", 0,
   (Fl_Callback *) VtkAbstractToolBarHelpMenuCb,
   (void *) WIDGETS_HELP_USER, 0},
  {"Developer Dox", 0,
   (Fl_Callback *) VtkAbstractToolBarHelpMenuCb,
   (void *) WIDGETS_HELP_DEVELOPER, FL_MENU_DIVIDER},
  {"About ...", 0,
   (Fl_Callback *) VtkAbstractToolBarHelpMenuCb,
   (void *) WIDGETS_HELP_ABOUT, 0},
  {0},

  {0}
};

/*
 * End of: $Id: SvvToolBarMenu.cxx,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $.
 *
 */
