/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: SvvToolBarMenu.h,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_TOOL_BAR_MENU_H_
#  define SVV_TOOL_BAR_MENU_H_
// FLTK
#  include <FL/Fl_Menu_Item.H>

enum SvvToolBarMenuItemType
{
  /* 'File' menu items. */
  SVV_FILE_MENU                         = 0x01000000,
  SVV_FILE_WRITEIMAGE                   = 0x01010000,
  SVV_FILE_SURFACE                      = 0x01020000,
  SVV_FILE_SURFACE_ADD                  = 0x01020100,
  SVV_FILE_SURFACE_SAVE                 = 0x01020200,
  SVV_FILE_VOLUME                       = 0x01040000,
  SVV_FILE_VOLUME_ADD                   = 0x01040100,
  SVV_FILE_VOLUME_SAVE                  = 0x01040200,
  SVV_FILE_DAVE                         = 0x01080000,
  SVV_FILE_DAVE_LOAD                    = 0x01080100,
  SVV_FILE_DAVE_SAVE                    = 0x01080200,
  SVV_FILE_SCENE                        = 0x01100000,
  SVV_FILE_SCENE_IMPORT                 = 0x01100100,
  SVV_FILE_SCENE_EXPORT                 = 0x01100200,
  SVV_FILE_SESSION                      = 0x01200000,
  SVV_FILE_SESSION_RESTORE              = 0x01200100,
  SVV_FILE_SESSION_RECORD               = 0x01200200,
  SVV_FILE_EXIT                         = 0x01400000,
  /* 'Node' menu items. */
  SVV_NODE_MENU                         = 0x02000000,
  SVV_NODE_PROPERTIES                   = 0x02010000,
  SVV_NODE_ATTRIBUTES                   = 0x02020000,
  SVV_NODE_FILTERING                    = 0x02040000,
  SVV_NODE_GROUP                        = 0x02080000,
  SVV_NODE_PROMOTE                      = 0x02100000,
  SVV_NODE_DEMOTE                       = 0x02200000,
  SVV_NODE_REMOVE                       = 0x02400000,
  /* 'Renderer' menu items. */
  SVV_RENDERER_MENU                     = 0x04000000,
  SVV_RENDERER_INTERFACE                = 0x04010000,
  SVV_RENDERER_INTERFACE_LIGHTING       = 0x04010100,
  SVV_RENDERER_INTERFACE_CAMERA         = 0x04010200,
  SVV_RENDERER_INTERFACE_VIEWPORT       = 0x04010400,
  SVV_RENDERER_INTERFACE_TREE           = 0x04010800,
  SVV_RENDERER_INTERFACE_CREATE         = 0x04011000,
  SVV_RENDERER_INTERACTION              = 0x04020000,
  SVV_RENDERER_INTERACTION_INERTIA      = 0x04020100,
  SVV_RENDERER_INTERACTION_ROTATION     = 0x04020200,
  SVV_RENDERER_INTERACTION_TRANSLATION  = 0x04020400,
  SVV_RENDERER_INTERACTION_SCALING      = 0x04020800,
  SVV_RENDERER_CONTEXT                  = 0x04040000,
  SVV_RENDERER_CONTEXT_AXES             = 0x04040100,
  SVV_RENDERER_CONTEXT_BOUNDINGBOX      = 0x04040200,
  SVV_RENDERER_DEPTHSORT                = 0x04080000,
  SVV_RENDERER_VIEWS                    = 0x04200000,
  /* 'Help' menu items. */
  SVV_HELP_MENU                         = 0x08000000,
  SVV_HELP_MESSAGES                     = 0x08010000,
  SVV_HELP_USER                         = 0x08020000,
  SVV_HELP_DEVELOPER                    = 0x08040000,
  SVV_HELP_ABOUT                        = 0x08080000
};

extern Fl_Menu_Item     SvvToolBarViewsSubmenu[16];
extern Fl_Menu_Item     SvvToolBarMenu[];

#endif /* SVV_TOOL_BAR_MENU_H_ */
/*
 * End of: $Id: SvvToolBarMenu.h,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $.
 *
 */
