/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svvExitUI.cxx,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "svvExitUI.h"
#include "svvMessagesUI.h"
// C++ forwarding ANSI C
#include <cstdlib>
#include <cerrno>
// C++ allocator
#include <new>


// ----------------------------------------------------------------------------
#ifdef SVV_UNIX
SVV_BEGIN_EXTERN_C
void
SvvSignalHandler (SIGARG aSigNum)
{
  switch (aSigNum)
    {
    case SIGILL:
      SvvMsg.log( svvMessagesUI::FATAL,
                  "Illegal instruction." );
      break;

    case SIGFPE:
      SvvMsg.log( svvMessagesUI::FATAL,
                  "Arithmetic Exception (division by zero?)." );
      break;

    case SIGSEGV:
      SvvMsg.log( svvMessagesUI::FATAL,
                  "Segmentation Fault (invalid memory reference)\n"
                  "------------------------------------------------------\n"
                  "You have discovered a bug in SV! You may report it\n"
                  "by e-mail (together with any helpful data permitting\n"
                  "to reproduce it) to <anvil@acm.org>." );
      break;

    case SIGBUS:
      SvvMsg.log( svvMessagesUI::FATAL,
                  "Bus Error (invalid memory reference)\n"
                  "------------------------------------------------------\n"
                  "You have discovered a bug in SV! You may report it\n"
                  "by e-mail (together with any helpful data permitting\n"
                  "to reproduce it) to <anvil@acm.org>." );
      break;

    case SIGQUIT:
    case SIGTERM:
    case SIGHUP:
    case SIGINT:
      SvvMsg.log( svvMessagesUI::INFO,
                  "Interrupt (generated from terminal special character)." );
      svvExitUI::ExitSignalCb((Fl_Widget *) NULL, (void *) NULL);
      break;

    default:
      SvvMsg.log( svvMessagesUI::FATAL, "Unknown signal" );
      break;
    }
}
SVV_END_EXTERN_C
#endif /* SVV_UNIX */

// ----------------------------------------------------------------------------
void
svvExitUI::ExitCb (Fl_Button*, void* a)
{
  Fl_Window* w;

  if((w = reinterpret_cast<Fl_Window*>(a)) == NULL)
    return;

  std::exit(errno);
}

void
svvExitUI::ContinueCb (Fl_Return_Button*, void* a)
{
  Fl_Window* dialog;
  Fl_Window* top;

  if ((dialog = reinterpret_cast<Fl_Window*>(a)) == NULL)
    return;

  if ((top = reinterpret_cast<Fl_Window*>(dialog->user_data())) != NULL)
    {
    top->show();
    }

  dialog->hide();
}

void
svvExitUI::ExitSignalCb (Fl_Widget*, void* a)
{
  int x, y;

  Fl::get_mouse(x, y);
  
  SvvExit.position(x,y);
  SvvExit.user_data(a);
  SvvExit.show();
}

///////////////////////////////////////////////////////////////////////////////
// Begin class singleton internals
///////////////////////////////////////////////////////////////////////////////

/** \internal
 * this is for fake initialization
 */
template<class T>
union _aligned_buffer_t
{
  char buf[sizeof(T)];
  struct { double a; double b; } padding;
};

long svvExitUI::Init::TranslationUnits;

// Singleton static space.
static _aligned_buffer_t<svvExitUI> fake;
// Singleton instance reference.
svvExitUI& SvvExit = *(reinterpret_cast<svvExitUI*>(&fake));

// ----------------------------------------------------------------------------
svvExitUI::Init::Init(void)
{ if(TranslationUnits++ == 0) svvExitUI::ClassInitialize(); }

svvExitUI::Init::~Init(void)
{ if(--TranslationUnits == 0) svvExitUI::ClassFinalize(); }

void
svvExitUI::ClassInitialize(void)
{
  svvExitUI* ptr = new((void *) &fake) svvExitUI;
  ptr->hide();
}

void
svvExitUI::ClassFinalize(void)
{
  svvExitUI* ptr = reinterpret_cast<svvExitUI*>(&SvvExit);
  ptr->hide();

  std::exit(errno);

  // EXPLICIT DESTRUCTOR CALL AHEAD ... think thrice!!!
  ptr->~svvExitUI();
}

///////////////////////////////////////////////////////////////////////////////
// End of class singleton internals
///////////////////////////////////////////////////////////////////////////////

svvExitUI::svvExitUI(void)
  : Fl_Window(162, 38, "SV: Exit?"),
    mExitButton(4, 4, 50, 30, "exit"),
    mContinueButton(58, 4, 100, 30, "continue"),
    mEnd()
{
  this->user_data(0);
  this->color(FL_RED);
  this->align(FL_ALIGN_CENTER);

  this->mExitButton.labelfont(FL_HELVETICA_BOLD);
  this->mExitButton.labelcolor(FL_FOREGROUND_COLOR);
  this->mExitButton.callback((Fl_Callback *) svvExitUI::ExitCb, this);
  this->mExitButton.align(FL_ALIGN_CENTER | FL_ALIGN_INSIDE);

  this->mContinueButton.labelfont(FL_HELVETICA_BOLD);
  this->mContinueButton.labelcolor(FL_FOREGROUND_COLOR);
  this->mContinueButton.callback((Fl_Callback *) svvExitUI::ContinueCb, this);
  this->mContinueButton.align(FL_ALIGN_CENTER | FL_ALIGN_INSIDE);

  this->set_modal();
  this->mContinueButton.show();
  this->hotspot(&(this->mContinueButton));
}

void
svvExitUI::resize(int aX, int aY, int aWidth, int aHeight)
{
  aX -= (this->mContinueButton.x() + this->mContinueButton.w() / 2);
  aY -= (this->mContinueButton.y() + this->mContinueButton.h() / 2);
  this->Fl_Window::resize(aX, aY, aWidth, aHeight);
}

/* 
 * End of: $Id: svvExitUI.cxx,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $.
 * 
 */
