/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svvExitUI.h,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_EXIT_UI_H_
#  define SVV_EXIT_UI_H_
#  include "svvConfiguration.h"
// FLTK
#  include <FL/Fl.H>
#  include <FL/Fl_Window.H>
#  include <FL/Fl_Button.H>
#  include <FL/Fl_Return_Button.H>

#  ifdef SVV_UNIX
#    include <signal.h>
#    ifdef _sigargs
#      define SIGARG _sigargs
#    else
#      ifdef __sigargs
#        define SIGARG __sigargs
#      else
#        define SIGARG int // you may need to fix this for older systems
#      endif
#    endif

SVV_BEGIN_EXTERN_C
void SvvSignalHandler (SIGARG sigNum);
SVV_END_EXTERN_C
#  endif /* SVV_UNIX */

class svvExitUI : public Fl_Window
{
  Fl_Button        mExitButton;
  Fl_Return_Button mContinueButton;
  Fl_End           mEnd;

protected:
  svvExitUI (void);

  static void   ClassInitialize (void);
  static void   ClassFinalize (void);

  static void   ExitCb (Fl_Button*, void*);
  static void   ContinueCb (Fl_Return_Button*, void*);
  static void   ExitSignalCb (Fl_Widget*, void*);

public:
  void  resize (int x, int y, int w, int h);

  /** \internal Nested initializer class. */
  class Init
  {
  public:
    Init (void);
    ~Init();
  private:
    static long TranslationUnits;
    friend class svvExitUI;
  };

  friend class Init;

#  ifdef SVV_UNIX
  friend void SvvSignalHandler (SIGARG sigNum);
#  endif /* SVV_UNIX */
};

#  ifndef SVV_EXIT_UI_INITIALIZED_
#    define SVV_EXIT_UI_INITIALIZED_
/** \internal Global initializer; ensure construction of static objects. */
static svvExitUI::Init svvExitUISingletonInitInstance;
#  endif /* SVV_EXIT_UI_INITIALIZED_ */

/** Singleton instance reference. */
extern svvExitUI& SvvExit;

#endif /* SVV_EXIT_UI_H_ */
/* 
 * End of: $Id: svvExitUI.h,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $.
 * 
 */
