/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svv_file_chooser.h,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

/** Call the file chooser and return the number of files chosen. */
int     svv_file_chooser (const char* message, const char* pattern, int type);

/** Set the file chooser callback. */
void    svv_file_chooser_callback (void (*cb)(const char*));

/** Return the number of filename values held by the file chooser. */
int     svv_file_chooser_count (void);

/** Return the filename value at the specified index. */
char*   svv_file_chooser_value (int index, int relative = 0);

/** Call the file chooser and return the directory chosen. */
char*   svv_dir_chooser (const char* message, int relative = 0);

/** Call the file chooser and return the file chosen. */
char*   svv_singlefile_chooser (const char* msg, const char* pat, int rel = 0);

/** Call the file chooser and return the number of files chosen. */
int     svv_multifile_chooser (const char* message, const char* pattern);

/** Call the file chooser and return the new directory name. */
char*   svv_newdir_chooser (const char* message, int relative = 0);

/** Call the file chooser and return the new file name. */
char*   svv_newfile_chooser (const char* msg, const char* pat, int rel = 0);

/* 
 * End of: $Id: svv_file_chooser.h,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $.
 * 
 */
