/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractCameraUI.h,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_ABSTRACT_CAMERA_UI_H_
#  define VTK_ABSTRACT_CAMERA_UI_H_
#  include "vtkAbstractUI.h"

class vtkAbstractCameraUI : public vtkAbstractUI
{
public:
  static vtkAbstractCameraUI* New (void);
  vtkTypeRevisionMacro (vtkAbstractCameraUI, vtkAbstractUI);
  void PrintSelf (ostream& aTarget, vtkIndent aIndent);

  void                  Default (vtkObject* = 0);
  void                  Receive (vtkObject* = 0);
  void                  Send (vtkObject* = 0);

  virtual void          Check (void) = 0;

  virtual void          GetWindowCenter (double a[2]) = 0;
  virtual void          SetWindowCenter (double a[2]) = 0;

  virtual void          GetFocalPoint (double a[3]) = 0;
  virtual void          SetFocalPoint (double a[3]) = 0;

  virtual void          GetPosition (double a[3]) = 0;
  virtual void          SetPosition (double a[3]) = 0;

  virtual void          GetClippingRange (double a[2]) = 0;
  virtual void          SetClippingRange (double a[2]) = 0;

  virtual void          GetViewUp (double a[3]) = 0;
  virtual void          SetViewUp (double a[3]) = 0;

  virtual void          GetViewAngle (double& a) = 0;
  virtual void          SetViewAngle (double a) = 0;

  virtual void          GetViewShear (double a[3]) = 0;
  virtual void          SetViewShear (double a[3]) = 0;

  virtual void          GetFocalDisk (double& a) = 0;
  virtual void          SetFocalDisk (double a) = 0;

  virtual void          GetEyeAngle (double& a) = 0;
  virtual void          SetEyeAngle (double a) = 0;

  virtual void          GetParallelProjection (int& a) = 0;
  virtual void          SetParallelProjection (int a) = 0;

  virtual void          GetUseHorizontalViewAngle (int& a) = 0;
  virtual void          SetUseHorizontalViewAngle (int a) = 0;

  virtual void          GetParallelScale (double& a) = 0;
  virtual void          SetParallelScale (double a) = 0;

  virtual void          GetDolly (double& a) = 0;
  virtual void          SetDolly (double a) = 0;

  virtual void          GetRoll (double& a) = 0;
  virtual void          SetRoll (double a) = 0;

  virtual void          GetElevation (double& a) = 0;
  virtual void          SetElevation (double a) = 0;

  virtual void          GetPitch (double& a) = 0;
  virtual void          SetPitch (double a) = 0;

  virtual void          GetAzimuth (double& a) = 0;
  virtual void          SetAzimuth (double a) = 0;

  virtual void          GetYaw (double& a) = 0;
  virtual void          SetYaw (double a) = 0;

  virtual void          GetZoom (double& a) = 0;
  virtual void          SetZoom (double a) = 0;

  virtual void          GetObliqueAngles (double a[2]) = 0;
  virtual void          SetObliqueAngles (double a[2]) = 0;

  inline void           SetLastDolly (void)
    { double d; this->GetDolly(d); this->LastDolly = d; }
  inline void           SetLastRoll (void)
    { double d; this->GetRoll(d); this->LastRoll = d; }
  inline void           SetLastElevation (void)
    { double d; this->GetElevation(d); this->LastElevation = d; }
  inline void           SetLastPitch (void)
    { double d; this->GetPitch(d); this->LastPitch = d; }
  inline void           SetLastAzimuth (void)
    { double d; this->GetAzimuth(d); this->LastAzimuth = d; }
  inline void           SetLastYaw (void)
    { double d; this->GetYaw(d); this->LastYaw = d; }
  inline void           SetLastZoom (void)
    { double d; this->GetZoom(d); this->LastZoom = d; }

  inline void           SetLastDolly (double a)
    { this->SetDolly(a); this->LastDolly = a; }
  inline void           SetLastRoll (double a)
    { this->SetRoll(a); this->LastRoll = a; }
  inline void           SetLastElevation (double a)
    { this->SetElevation(a); this->LastElevation = a; }
  inline void           SetLastPitch (double a)
    { this->SetPitch(a); this->LastPitch = a; }
  inline void           SetLastAzimuth (double a)
    { this->SetAzimuth(a); this->LastAzimuth = a; }
  inline void           SetLastYaw (double a)
    { this->SetYaw(a); this->LastYaw = a; }
  inline void           SetLastZoom (double a)
    { this->SetZoom(a); this->LastZoom = a; }

  inline double         GetLastDolly (void) const
    { return this->LastDolly; }
  inline double         GetLastRoll (void) const
    { return this->LastRoll; }
  inline double         GetLastElevation (void) const
    { return this->LastElevation; }
  inline double         GetLastPitch (void) const
    { return this->LastPitch; }
  inline double         GetLastAzimuth (void) const
    { return this->LastAzimuth; }
  inline double         GetLastYaw (void) const
    { return this->LastYaw; }
  inline double         GetLastZoom (void) const
    { return this->LastZoom; }

protected:
  vtkAbstractCameraUI (void)
    : LastDolly(0.0),
      LastRoll(0.0),
      LastElevation(0.0),
      LastPitch(0.0),
      LastAzimuth(0.0),
      LastYaw(0.0),
      LastZoom(1.0)
    {}

  ~vtkAbstractCameraUI() {}

  double        LastDolly;
  double        LastRoll;
  double        LastElevation;
  double        LastPitch;
  double        LastAzimuth;
  double        LastYaw;
  double        LastZoom;

private:
  vtkAbstractCameraUI (const vtkAbstractCameraUI&); // Not implemented.
  void operator= (const vtkAbstractCameraUI&); // Not implemented.
};

#  define VTK_CAMERA_UI_INTERFACE               \
  void  Check (void);                           \
  void  GetWindowCenter (double [2]);           \
  void  SetWindowCenter (double [2]);           \
  void  GetFocalPoint (double [3]);             \
  void  SetFocalPoint (double [3]);             \
  void  GetPosition (double [3]);               \
  void  SetPosition (double [3]);               \
  void  GetClippingRange (double [2]);          \
  void  SetClippingRange (double [2]);          \
  void  GetViewUp (double [3]);                 \
  void  SetViewUp (double [3]);                 \
  void  GetViewAngle (double&);                 \
  void  SetViewAngle (double);                  \
  void  GetViewShear (double [3]);              \
  void  SetViewShear (double [3]);              \
  void  GetFocalDisk (double&);                 \
  void  SetFocalDisk (double);                  \
  void  GetEyeAngle (double&);                  \
  void  SetEyeAngle (double);                   \
  void  GetParallelProjection (int&);           \
  void  SetParallelProjection (int);            \
  void  GetUseHorizontalViewAngle (int&);       \
  void  SetUseHorizontalViewAngle (int);        \
  void  GetParallelScale (double&);             \
  void  SetParallelScale (double);              \
  void  GetDolly (double&);                     \
  void  SetDolly (double);                      \
  void  GetRoll (double&);                      \
  void  SetRoll (double);                       \
  void  GetElevation (double&);                 \
  void  SetElevation (double);                  \
  void  GetPitch (double&);                     \
  void  SetPitch (double);                      \
  void  GetAzimuth (double&);                   \
  void  SetAzimuth (double);                    \
  void  GetYaw (double&);                       \
  void  SetYaw (double);                        \
  void  GetZoom (double&);                      \
  void  SetZoom (double);                       \
  void  GetObliqueAngles (double [2]);          \
  void  SetObliqueAngles (double [2])


#endif /* VTK_ABSTRACT_CAMERA_UI_H_ */
/*
 * End of: $Id: vtkAbstractCameraUI.h,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $.
 *
 */
