/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractLightingUI.h,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_ABSTRACT_LIGHTING_UI_H_
#  define VTK_ABSTRACT_LIGHTING_UI_H_
#  include "vtkAbstractUI.h"

class vtkLight;

class vtkAbstractLightingUI : public vtkAbstractUI
{
public:
  static vtkAbstractLightingUI* New (void);
  vtkTypeRevisionMacro (vtkAbstractLightingUI, vtkAbstractUI);
  void PrintSelf (ostream&, vtkIndent);

  void  Default (vtkObject* aObject = 0);
  void  Receive (vtkObject* aObject = 0);
  void  Send (vtkObject* aObject = 0);

  virtual void          Check (void) = 0;

  virtual void          GetAmbient (float [3]) = 0;
  virtual void          SetAmbient (float [3]) = 0;

  virtual void          GetBackground (float [3]) = 0;
  virtual void          SetBackground (float [3]) = 0;

  virtual vtkLight*     GetLight0 (void) = 0;
  virtual void          InitializeLight0 (void) = 0;

  virtual void          DefaultToLight0 (vtkObject* = 0) = 0;
  virtual void          ReceiveToLight0 (vtkObject* = 0) = 0;
  virtual void          SendFromLight0 (vtkObject* = 0) = 0;

protected:
  vtkAbstractLightingUI (void) {}
  ~vtkAbstractLightingUI() {}

private:
  vtkAbstractLightingUI (const vtkAbstractLightingUI&); // Not implemented.
  void operator= (const vtkAbstractLightingUI&); // Not implemented.
};

#  define VTK_LIGHTING_UI_INTERFACE                     \
  void          Check (void);                           \
  void          GetAmbient (float [3]);                 \
  void          SetAmbient (float [3]);                 \
  void          GetBackground (float [3]);              \
  void          SetBackground (float [3]);              \
  vtkLight*     GetLight0 (void);                       \
  void          InitializeLight0 (void);                \
  void          DefaultToLight0 (vtkObject* = 0);       \
  void          ReceiveToLight0 (vtkObject* = 0);       \
  void          SendFromLight0 (vtkObject* = 0)

#endif /* VTK_ABSTRACT_LIGHTING_UI_H_ */
/*
 * End of: $Id: vtkAbstractLightingUI.h,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $.
 *
 */
