/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractLoadDialogUI.cxx,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $
 * 
 * Copyright (c) 2003, 2004 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkLoadDialogUI.h"
#include "svv_file_chooser.h"
// VTK Common
#include "vtkDebugLeaks.h"
#include "vtkObjectFactory.h"

// ----------------------------------------------------------------------------
//      v t k A b s t r a c t L o a d D i a l o g U I
// ----------------------------------------------------------------------------
vtkCxxRevisionMacro (vtkAbstractLoadDialogUI, "$Revision: 1.1.1.1 $");
vtkInstantiatorNewMacro (vtkAbstractLoadDialogUI);

// ----------------------------------------------------------------------------
vtkAbstractLoadDialogUI*
vtkAbstractLoadDialogUI::New (void)
{
  vtkObject* result =
    vtkObjectFactory::CreateInstance("vtkAbstractLoadDialogUI");

  if (result != NULL)
    {
    return static_cast<vtkAbstractLoadDialogUI*>(result);
    }

  vtkDebugLeaks::DestructClass("vtkAbstractLoadDialogUI");

  return vtkLoadDialogUI::New();
}

// ----------------------------------------------------------------------------
void
vtkAbstractLoadDialogUI::Default (vtkObject* vtkNotUsed(a))
{
  this->SetSingleGroupToDefault();
  this->SetMultipleGroupToDefault();
  this->SetSeriesGroupToDefault();
  this->SetDirectoryGroupToDefault();
  this->SetFilePatternGroupToDefault();

  this->SetInputTypeToDefault();
  this->SetSelectionTypeToDefault();

  this->Check();
}

void
vtkAbstractLoadDialogUI::Receive (vtkObject* vtkNotUsed(a))
{
  long          type;
  long          radio;
  const char*   pattern;
  const char*   message = NULL;

  this->GetInputTypeValue(type);
  this->GetInputTypeText(pattern);
  this->GetSelectionTypeValue(radio);

  switch (radio)
    {

    case vtkAbstractLoadDialogUI::VTK_SELECTION_TYPE_MULTIPLE:
      {
      } break;

    case vtkAbstractLoadDialogUI::VTK_SELECTION_TYPE_SERIES:
      this->ReceiveFromSeriesGroup();
      break;

    case vtkAbstractLoadDialogUI::VTK_SELECTION_TYPE_DIRECTORY:
      this->ReceiveFromDirectoryGroup();
      break;

    case vtkAbstractLoadDialogUI::VTK_SELECTION_TYPE_SINGLE:
    default:
      {
      } break;

    } // switch (radio)

  this->Check();
}

void
vtkAbstractLoadDialogUI::Send (vtkObject* vtkNotUsed(a))
{
  //this->Check();
}

// ----------------------------------------------------------------------------
void
vtkAbstractLoadDialogUI::Show (int aArgc, char* aArgv[])
{
  if (this->FltkWindow != (Fl_Window *) 0)
    {
    if (!this->Shown()) this->Default();
    this->FltkWindow->show(aArgc, aArgv);
    }
}

void
vtkAbstractLoadDialogUI::Show (void)
{
  if (this->FltkWindow != (Fl_Window *) 0)
    {
    if (!this->Shown()) this->Default();
    this->FltkWindow->show();
    }
}

/*
 * End of: $Id: vtkAbstractLoadDialogUI.cxx,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $.
 *
 */
