/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractLoadDialogUI.h,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $
 * 
 * Copyright (c) 2003, 2004 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_ABSTRACT_LOAD_DIALOG_UI_H_
#  define VTK_ABSTRACT_LOAD_DIALOG_UI_H_
#  include "vtkAbstractUI.h"

class vtkAbstractLoadDialogUI : public vtkAbstractUI
{
public:
  static vtkAbstractLoadDialogUI* New (void);
  vtkTypeRevisionMacro (vtkAbstractLoadDialogUI, vtkAbstractUI);

  void          Default (vtkObject* = 0);
  void          Receive (vtkObject* = 0);
  void          Send (vtkObject* = 0);

  void          Show (int argc, char* argv[]);
  void          Show (void);

  typedef enum InputTypeEnum
  {
    VTK_INPUT_TYPE_AUTOMATIC                           = 0x00000000,
    VTK_INPUT_TYPE_POLYDATA                            = 0x10000000,
    VTK_INPUT_TYPE_POLYDATA_VTK                        = 0x10100000,
    VTK_INPUT_TYPE_POLYDATA_VTK_VTK                    = 0x10100001,
    VTK_INPUT_TYPE_POLYDATA_VTK_VTP                    = 0x10100002,
    VTK_INPUT_TYPE_POLYDATA_VTK_PVTP                   = 0x10100004,
    VTK_INPUT_TYPE_POLYDATA_FREESURFER                 = 0x10200000,
    VTK_INPUT_TYPE_POLYDATA_OTHER                      = 0x10400000,
    VTK_INPUT_TYPE_POLYDATA_OTHER_BYU                  = 0x10401000,
    VTK_INPUT_TYPE_POLYDATA_OTHER_BYU_G                = 0x10401001,
    VTK_INPUT_TYPE_POLYDATA_OTHER_BYU_S                = 0x10401002,
    VTK_INPUT_TYPE_POLYDATA_OTHER_BYU_T                = 0x10401004,
    VTK_INPUT_TYPE_POLYDATA_OTHER_BYU_D                = 0x10401008,
    VTK_INPUT_TYPE_POLYDATA_OTHER_CGM                  = 0x10400001,
    VTK_INPUT_TYPE_POLYDATA_OTHER_OBJ                  = 0x10400002,
    VTK_INPUT_TYPE_POLYDATA_OTHER_PLY                  = 0x10400004,
    VTK_INPUT_TYPE_POLYDATA_OTHER_PRT                  = 0x10400008,
    VTK_INPUT_TYPE_POLYDATA_OTHER_STL                  = 0x10400010,
    VTK_INPUT_TYPE_POLYDATA_OTHER_TRI                  = 0x10400020,
    VTK_INPUT_TYPE_POLYDATA_OTHER_LIM                  = 0x10400040,
    VTK_INPUT_TYPE_POLYDATA_OTHER_ASCII                = 0x10400080,
    VTK_INPUT_TYPE_IMAGEDATA                           = 0x20000000,
    VTK_INPUT_TYPE_IMAGEDATA_VTK                       = 0x20100000,
    VTK_INPUT_TYPE_IMAGEDATA_VTK_VTK                   = 0x20100001,
    VTK_INPUT_TYPE_IMAGEDATA_VTK_VTI                   = 0x20100002,
    VTK_INPUT_TYPE_IMAGEDATA_VTK_PVTI                  = 0x20100004,
    VTK_INPUT_TYPE_IMAGEDATA_MEDICAL                   = 0x20200000,
    VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_GESIGNA           = 0x20201000,
    VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_GESIGNA_MR        = 0x20201001,
    VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_GESIGNA_CT        = 0x20201002,
    VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_DICOM             = 0x20202000,
    VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_BLOCK             = 0x20204000,
    VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_BLOCK_BUCHAR      = 0x20204001,
    VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_BLOCK_BSHORT      = 0x20204002,
    VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_BLOCK_BUSHORT     = 0x20204004,
    VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_BLOCK_BFLOAT      = 0x20204008,
    VTK_INPUT_TYPE_IMAGEDATA_FREESURFER                = 0x20400000,
    VTK_INPUT_TYPE_IMAGEDATA_FREESURFER_COR            = 0x20400001,
    VTK_INPUT_TYPE_IMAGEDATA_OTHER                     = 0x20800000,
    VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D                  = 0x20801000,
    VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_BMP              = 0x20801001,
    VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_PNM              = 0x20801002,
    VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_JPEG             = 0x20801004,
    VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_PNG              = 0x20801008,
    VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_TIFF             = 0x20801010,
    VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_DEM              = 0x20801020,
    VTK_INPUT_TYPE_IMAGEDATA_OTHER_3D                  = 0x20802000,
    VTK_INPUT_TYPE_IMAGEDATA_OTHER_3D_SLC              = 0x20802001,
  };

  typedef enum SelectionTypeEnum
  {
    VTK_SELECTION_TYPE_SINGLE = 0,
    VTK_SELECTION_TYPE_MULTIPLE,
    VTK_SELECTION_TYPE_SERIES,
    VTK_SELECTION_TYPE_DIRECTORY
  };

  virtual void  Check (void) = 0;

  virtual void  ShowSingleGroup (void) = 0;
  virtual void  ShowMultipleGroup (void) = 0;
  virtual void  ShowSeriesGroup (void) = 0;
  virtual void  ShowDirectoryGroup (void) = 0;

  virtual void  SetSingleGroupToDefault (void) = 0;
  virtual void  SetMultipleGroupToDefault (void) = 0;
  virtual void  SetSeriesGroupToDefault (void) = 0;
  virtual void  SetDirectoryGroupToDefault (void) = 0;
  virtual void  SetFilePatternGroupToDefault (void) = 0;

  virtual void  ReceiveFromSeriesGroup (void) = 0;
  virtual void  ReceiveFromDirectoryGroup (void) = 0;
  virtual void  ReceiveFromPatternGroup (void) = 0;

  virtual void  SyncInputType (void) = 0;
  virtual void  SetInputTypeToDefault (void) = 0;
  virtual void  GetInputTypeValue (long & a) const = 0;
  virtual void  GetInputTypeText (const char* & a) const = 0;

  virtual void  SetSelectionTypeToDefault (void) = 0;
  virtual void  SetSelectionTypeToSingle (void) = 0;
  virtual void  SetSelectionTypeToMultiple (void) = 0;
  virtual void  SetSelectionTypeToSeries (void) = 0;
  virtual void  SetSelectionTypeToDirectory (void) = 0;
  virtual void  GetSelectionTypeValue (long & a) const = 0;

  virtual void  GetSingleFileInput (const char* & a) const = 0;
  virtual void  SetSingleFileInput (const char* const& a) = 0;


  virtual void  GetMultipleFileBrowserSize (int & a) const = 0;

  virtual void  GetMultipleFileFilter (const char* & a) const = 0;
  virtual void  SetMultipleFileFilter (const char* const& a) = 0;

  virtual void  GetMultipleFileSelection (int const& n,const char* & a) const=0;
  virtual void  SetMultipleFileSelection (int const& n, const char* const& a)=0;

  virtual void  AddToMultipleFileBrowser (const char* const& a) = 0;

  virtual void  GetFirstFileInput (const char* & a) const = 0;
  virtual void  SetFirstFileInput (const char* const& a) = 0;

  virtual void  GetLastFileInput (const char* & a) const = 0;
  virtual void  SetLastFileInput (const char* const& a) = 0;

  virtual void  GetDirectoryNameInput (const char* & a) const = 0;
  virtual void  SetDirectoryNameInput (const char* const& a) = 0;

  virtual void  ClearSingleFileInput (void) = 0;
  virtual void  ClearMultipleFileBrowser (void) = 0;
  virtual void  ClearFirstFileInput (void) = 0;
  virtual void  ClearLastFileInput (void) = 0;
  virtual void  ClearDirectoryNameInput (void) = 0;

  virtual void  GetFilePatternPrefix (const char* & a) const = 0;
  virtual void  SetFilePatternPrefix (const char* const& a) = 0;

  virtual void  GetFilePatternDigits (int & a) const = 0;
  virtual void  SetFilePatternDigits (int const& a) = 0;

  virtual void  GetFilePatternInfix (const char* & a) const = 0;
  virtual void  SetFilePatternInfix (const char* const& a) = 0;

  virtual void  GetFilePatternSuffix (const char* & a) const = 0;
  virtual void  SetFilePatternSuffix (const char* const& a) = 0;

  virtual void  GetFilePatternOffset (int & a) const = 0;
  virtual void  SetFilePatternOffset (int const& a) = 0;

  virtual void  GetFilePatternCount (int & a) const = 0;
  virtual void  SetFilePatternCount (int const& a) = 0;

protected:
  vtkAbstractLoadDialogUI (void) {}
  ~vtkAbstractLoadDialogUI() {}

  InputTypeEnum         InputType;
  SelectionTypeEnum     SelectionType;

private:
  vtkAbstractLoadDialogUI (const vtkAbstractLoadDialogUI&); //Not implemented.
  void operator= (const vtkAbstractLoadDialogUI&); //Not implemented.
};

#  define VTK_LOAD_DIALOG_UI_INTERFACE                                  \
  void  Check (void);                                                   \
  void  ShowSingleGroup (void);                                         \
  void  ShowMultipleGroup (void);                                       \
  void  ShowSeriesGroup (void);                                         \
  void  ShowDirectoryGroup (void);                                      \
  void  SetSingleGroupToDefault (void);                                 \
  void  SetMultipleGroupToDefault (void);                               \
  void  SetSeriesGroupToDefault (void);                                 \
  void  SetDirectoryGroupToDefault (void);                              \
  void  SetFilePatternGroupToDefault (void);                            \
  void  ReceiveFromSeriesGroup (void);                                  \
  void  ReceiveFromDirectoryGroup (void);                               \
  void  ReceiveFromPatternGroup (void);                                 \
  void  SyncInputType (void);                                           \
  void  SetInputTypeToDefault (void);                                   \
  void  GetInputTypeValue (long &) const;                               \
  void  GetInputTypeText (const char* &) const;                         \
  void  SetSelectionTypeToDefault (void);                               \
  void  SetSelectionTypeToSingle (void);                                \
  void  SetSelectionTypeToMultiple (void);                              \
  void  SetSelectionTypeToSeries (void);                                \
  void  SetSelectionTypeToDirectory (void);                             \
  void  GetSelectionTypeValue (long &) const;                           \
  void  GetSingleFileInput (const char* &) const;                       \
  void  SetSingleFileInput (const char* const&);                        \
  void  GetMultipleFileBrowserSize (int &) const;                       \
  void  GetMultipleFileFilter (const char* &) const;                    \
  void  SetMultipleFileFilter (const char* const&);                     \
  void  GetMultipleFileSelection (int const&, const char* &) const;     \
  void  SetMultipleFileSelection (int const&, const char* const&);      \
  void  AddToMultipleFileBrowser (const char* const&);                  \
  void  GetFirstFileInput (const char* &) const;                        \
  void  SetFirstFileInput (const char* const&);                         \
  void  GetLastFileInput (const char* &) const;                         \
  void  SetLastFileInput (const char* const&);                          \
  void  GetDirectoryNameInput (const char* &) const;                    \
  void  SetDirectoryNameInput (const char* const&);                     \
  void  ClearSingleFileInput (void);                                    \
  void  ClearMultipleFileBrowser (void);                                \
  void  ClearFirstFileInput (void);                                     \
  void  ClearLastFileInput (void);                                      \
  void  ClearDirectoryNameInput (void);                                 \
  void  GetFilePatternPrefix (const char* &) const;                     \
  void  SetFilePatternPrefix (const char* const&);                      \
  void  GetFilePatternDigits (int &) const;                             \
  void  SetFilePatternDigits (int const&);                              \
  void  GetFilePatternInfix (const char* &) const;                      \
  void  SetFilePatternInfix (const char* const&);                       \
  void  GetFilePatternSuffix (const char* &) const;                     \
  void  SetFilePatternSuffix (const char* const&);                      \
  void  GetFilePatternOffset (int &) const;                             \
  void  SetFilePatternOffset (int const&);                              \
  void  GetFilePatternCount (int &) const;                              \
  void  SetFilePatternCount (int const&)

#endif /* VTK_ABSTRACT_LOAD_DIALOG_UI_H_ */
/*
 * End of: $Id: vtkAbstractLoadDialogUI.h,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $.
 *
 */
