/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractSourceBrowserUI.h,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_ABSTRACT_SOURCE_BROWSER_UI_H_
#  define VTK_ABSTRACT_SOURCE_BROWSER_UI_H_
#  include "vtkAbstractUI.h"

class vtkAbstractSourceBrowserUI : public vtkAbstractUI
{
public:
  static vtkAbstractSourceBrowserUI* New (void);
  vtkTypeRevisionMacro (vtkAbstractSourceBrowserUI, vtkAbstractUI);

  void          Default (vtkObject* = 0);
  void          Receive (vtkObject* = 0);
  void          Send (vtkObject* = 0);

  virtual void  Check (void) = 0;

protected:
  vtkAbstractSourceBrowserUI (void) {}
  ~vtkAbstractSourceBrowserUI() {}

private:
  vtkAbstractSourceBrowserUI (const vtkAbstractSourceBrowserUI&); // Not implemented.
  void operator= (const vtkAbstractSourceBrowserUI&); // Not implemented.
};

#  define VTK_SOURCE_BROWSER_UI_INTERFACE       \
  void  Check (void)

#endif /* VTK_ABSTRACT_SOURCE_BROWSER_UI_H_ */
/*
 * End of: $Id: vtkAbstractSourceBrowserUI.h,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $.
 *
 */
