/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractSurfacePropertiesUI.h,v 1.1.1.1 2006/12/19 22:59:46 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_ABSTRACT_SURFACE_PROPERTIES_UI_H_
#  define VTK_ABSTRACT_SURFACE_PROPERTIES_UI_H_
#  include "vtkAbstractUI.h"

class vtkProperty;
class vtkTexture;
class vtkActor;
class Fl_Menu_;

class vtkDataSetToDataSetFilter;
class vtkTransformTextureCoords;

SVV_NAMESPACE_BEGIN

class svvMaterialNameMap;
class svvModelSource;

SVV_NAMESPACE_END

class SVV_EXPORT vtkAbstractSurfacePropertiesUI : public vtkAbstractUI
{
public:
  static vtkAbstractSurfacePropertiesUI* New (void);
  vtkTypeRevisionMacro (vtkAbstractSurfacePropertiesUI, vtkAbstractUI);
  void PrintSelf (ostream&, vtkIndent);

  void  Receive (vtkObject* object = 0);

  inline void   ReceiveFront (void);
  inline void   ReceiveBack (void);

  inline void   ReceiveComposite (void);
  inline void   ReceiveReflectance (void);
  inline void   ReceiveFeatures (void);

  virtual void  ReceiveFrontComposite (void) = 0;
  virtual void  ReceiveFrontReflectance (void) = 0;
  virtual void  ReceiveFrontFeatures (void) = 0;

  virtual void  ReceiveBackComposite (void) = 0;
  virtual void  ReceiveBackReflectance (void) = 0;
  virtual void  ReceiveBackFeatures (void) = 0;

  virtual void  ReceiveTexture (void) = 0;

  virtual void  ActivateBackGroups (void) = 0;
  virtual void  DeactivateBackGroups (void) = 0;

  virtual void  UpdateDemoRenderingContext (void) = 0;

  virtual vtkRenderWindow*      GetDemoRenderWindow (void) = 0;
  virtual vtkRenderer*          GetCurrentDemoRenderer (void) = 0;

  /*@{*/
  /**  */
  vtkSetMacro (Initialized,int);
  vtkGetMacro (Initialized,int);
  vtkBooleanMacro (Initialized,int);
  /*@}*/

  /**  */
  vtkGetObjectMacro (ModelSource, SVV_NAMESPACE_QUALIFIER svvModelSource);

  /**  */
  vtkGetObjectMacro (DemoActor,vtkActor);

  /*@{*/
  /**  */
  void SetDemoFrontProperty (vtkProperty* aProperty);
  vtkProperty* GetDemoFrontProperty (void);
  /*@}*/

  /*@{*/
  /**  */
  void SetDemoBackProperty (vtkProperty* aProperty);
  vtkProperty* GetDemoBackProperty (void);
  /*@}*/

  /*@{*/
  /**  */
  void SetStashedProperty (vtkProperty* aProperty);
  vtkGetObjectMacro (StashedProperty,vtkProperty);
  /*@}*/

  /*@{*/
  /**  */
  void SetOriginalFrontProperty (vtkProperty* aProperty);
  vtkGetObjectMacro (OriginalFrontProperty,vtkProperty);
  /*@}*/

  /*@{*/
  /**  */
  void SetOriginalBackProperty (vtkProperty* aProperty);
  vtkGetObjectMacro (OriginalBackProperty,vtkProperty);
  /*@}*/

  /*@{*/
  /**  */
  void SetDemoTexture (vtkTexture* aTexture);
  vtkTexture* GetDemoTexture (void);
  /*@}*/

  /**  */
  vtkActor* GetCurrentClientActor (void);

  void InitializeDemo (void);
  void Update (void);

  /*@{*/
  /**  */
  void Show (int argc, char* argv[]);
  void Show (void);
  /**  */

  void UpdateDemoGroups (void);

  static void   MaterialToProperty (vtkProperty*& property,
                                    SvvMaterial&  material);
  static void   BuildNamedMaterialsMenu (Fl_Menu_* menu);
  static bool   FindNamedMaterial (const char* name, SvvMaterial& material);

  static vtkDataSetToDataSetFilter*
  FindTextureCoordsGenerator (vtkActor*                   actor,
                              vtkTransformTextureCoords** texTxPtr = NULL);

protected:
  vtkAbstractSurfacePropertiesUI (void);
  ~vtkAbstractSurfacePropertiesUI();

  int Initialized;
  SVV_NAMESPACE_QUALIFIER svvModelSource*       ModelSource;
  vtkActor*                     DemoActor;
  vtkProperty*                  StashedProperty;
  vtkProperty*                  OriginalFrontProperty;
  vtkProperty*                  OriginalBackProperty;

  static SVV_NAMESPACE_QUALIFIER svvMaterialNameMap* NamedMaterials;

  static void   ClassInitialize (void);
  static void   ClassFinalize (void);

public:
  /** \internal
   * Nested initializer class.
   * The static initializer object is declared below.
   */
  class Init
  {
  public:
    Init (void);
    ~Init();
  private:
    static long TranslationUnits;
    friend class vtkAbstractSurfacePropertiesUI;
  };

  friend class Init;
  /*@}*/

private:
  /*@{*/
  /** \internal
   * Copy, assignement, comparison methods are \e NOT implemented.
   */
  vtkAbstractSurfacePropertiesUI (const vtkAbstractSurfacePropertiesUI&);
  void operator= (const vtkAbstractSurfacePropertiesUI&);
  bool operator== (const vtkAbstractSurfacePropertiesUI&);
  /*@}*/
};

inline void
vtkAbstractSurfacePropertiesUI::ReceiveFront (void)
{
  // Update front composite RGBA values.
  this->ReceiveFrontComposite();
  // Update front ambient, diffuse, and specular values.
  this->ReceiveFrontReflectance();
  // Update front features values.
  this->ReceiveFrontFeatures();
}

inline void
vtkAbstractSurfacePropertiesUI::ReceiveBack (void)
{
  // Update back composite RGBA values.
  this->ReceiveBackComposite();
  // Update back ambient, diffuse, and specular values.
  this->ReceiveBackReflectance();
  // Update back features values.
  this->ReceiveBackFeatures();
}

inline void
vtkAbstractSurfacePropertiesUI::ReceiveComposite (void)
{
  this->ReceiveFrontComposite();
  this->ReceiveBackComposite();
}

inline void
vtkAbstractSurfacePropertiesUI::ReceiveReflectance (void)
{
  this->ReceiveFront();
  this->ReceiveBack();
}

inline void
vtkAbstractSurfacePropertiesUI::ReceiveFeatures (void)
{
  this->ReceiveFrontFeatures();
  this->ReceiveBackFeatures();
}

#  ifndef VTK_ABSTRACT_SURFACE_PROPERTIES_UI_INITIALIZED_
#    define VTK_ABSTRACT_SURFACE_PROPERTIES_UI_INITIALIZED_
/** \internal
 * Global initializer object, to ensure construction of static objects.
 */
static vtkAbstractSurfacePropertiesUI::Init
vtkAbstractSurfacePropertiesUIInitInstance;
#  endif /* VTK_ABSTRACT_SURFACE_PROPERTIES_UI_INITIALIZED_ */

#endif /* VTK_ABSTRACT_SURFACE_PROPERTIES_UI_H_ */
/*
 * End of: $Id: vtkAbstractSurfacePropertiesUI.h,v 1.1.1.1 2006/12/19 22:59:46 christianh Exp $.
 *
 */
