/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractToolBarCb.cxx,v 1.1.1.1 2006/12/19 22:59:46 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
// SVV
#include "svvController.h"
#include "svv_file_chooser.h"
// SVV widgets
#include "svvExitUI.h"                  // SvvExit
#include "svvMessagesUI.h"              // SvvMsg
#include "SvvMenuItemType.h"
#include "Fl_VTK_View.H"
#include "vtkAbstractToolBarUI.h"
#include "vtkAbstractViewUI.h"
#include "vtkAbstractSurfacePropertiesUI.h"
#include "vtkAbstractLightingUI.h"
#include "vtkAbstractCameraUI.h"
#include "vtkAbstractViewportUI.h"
#include "vtkAbstractNodeBrowserUI.h"
#include "vtkAbstractSourceBrowserUI.h"
#include "vtkAbstractMatrix4x4UI.h"
// VTK Common
#include "vtkPolyData.h"
#include "vtkProcessObject.h"
#include "vtkProp.h"
// VTK Filtering
#include "vtkPolyDataSource.h"
// VTK Rendering
#include "vtkPolyDataMapper.h"
#include "vtkProperty.h"
#include "vtkProp3D.h"
#include "vtkActor.h"
#include "vtkAssembly.h"
#include "vtkActorCollection.h"
#include "vtkRenderer.h"
// VTK Hybrid
#include "vtkDepthSortPolyData.h"
// FLTK
#include <FL/Fl.H>                      // Fl:: methods
#include <FL/Fl_Widget.H>               // Fl_Widget
#include <FL/Fl_Button.H>               // Fl_Button
#include <FL/Fl_Menu_.H>                // Fl_Menu_
#include <FL/Fl_Window.H>               // Fl_Window
#include <FL/filename.H>                // for fl_filename_name(), etc.
#include <FL/fl_ask.H>                  // fl_alert()
// SVV widgets/Fl_Toggle_Tree
#include "Fl_Toggle_Node.H"
#include "Fl_Toggle_Tree.H"
// vtkExtensions
#include "vtkTraversal.h"

VTK_EXTENSIONS_NAMESPACE_USING(vtkTraversal);

SVV_NAMESPACE_USING(svv);


// ----------------------------------------------------------------------------
extern void     SvvLoadListCb (Fl_Menu_* menu, void*);
extern void     SvvSaveListCb (Fl_Menu_* menu, void*);
extern void     SvvLoadSurfaceCb (Fl_Menu_* menu, void*);
extern void     SvvLoadVolumeCb (Fl_Menu_* menu, void*);
extern void     SvvImportCb (Fl_Menu_* menu, void*);
extern void     SvvExportCb (Fl_Menu_* menu, void*);
extern void     SvvNodeAttributesCb (Fl_Menu_* menu, void*);
extern void     SvvNodeFilteringCb (Fl_Menu_* menu, void*);
extern void     SvvNodeGroupCb (Fl_Menu_* menu, void*);
extern void     SvvNodeRemoveCb (Fl_Menu_* menu, void*);

extern void     SvvHelpUserCb (Fl_Menu_* menu, void*);
extern void     SvvHelpDeveloperCb (Fl_Menu_* menu, void*);
extern void     SvvHelpAboutCb (Fl_Menu_* menu, void*);


// ----------------------------------------------------------------------------
static inline vtkAbstractViewUI*
sgGetViewUI (vtkAbstractToolBarUI*& aGUI)
{ return vtkAbstractViewUI::SafeDownCast(aGUI->GetViewUI()); }

static inline vtkAbstractSurfacePropertiesUI*
sgGetSurfacePropertiesUI (vtkAbstractToolBarUI*& aGUI)
{ return vtkAbstractSurfacePropertiesUI::
    SafeDownCast(aGUI->GetSurfacePropertiesUI()); }

static inline vtkAbstractLightingUI*
sgGetLightingUI (vtkAbstractToolBarUI*& aGUI)
{ return vtkAbstractLightingUI::SafeDownCast(aGUI->GetLightingUI()); }

static inline vtkAbstractCameraUI*
sgGetCameraUI (vtkAbstractToolBarUI*& aGUI)
{ return vtkAbstractCameraUI::SafeDownCast(aGUI->GetCameraUI()); }

static inline vtkAbstractViewportUI*
sgGetViewportUI (vtkAbstractToolBarUI*& aGUI)
{ return vtkAbstractViewportUI::SafeDownCast(aGUI->GetViewportUI()); }

static inline vtkAbstractNodeBrowserUI*
sgGetNodeBrowserUI (vtkAbstractToolBarUI*& aGUI)
{ return vtkAbstractNodeBrowserUI::SafeDownCast(aGUI->GetNodeBrowserUI()); }

static inline vtkAbstractSourceBrowserUI*
sgGetSourceBrowserUI (vtkAbstractToolBarUI*& aGUI)
{ return vtkAbstractSourceBrowserUI::SafeDownCast(aGUI->GetSourceBrowserUI()); }

static inline vtkAbstractMatrix4x4UI*
sgGetMatrix4x4UI (vtkAbstractToolBarUI*& aGUI)
{ return vtkAbstractMatrix4x4UI::SafeDownCast(aGUI->GetMatrix4x4UI()); }


// ----------------------------------------------------------------------------
void
VtkAbstractToolBarViewCb (Fl_Widget*, void* aPtr)
{
#if 0
  vtkAbstractToolBarUI* gui;
  vtkAbstractViewUI*    viewUI;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((viewUI = ::sgGetViewUI(gui)) == NULL)
    return;

  if (viewUI->Shown())
    viewUI->Hide();
  else
    viewUI->Show();
#else
  vtkAbstractToolBarUI* gui;
  Fl_Window*            viewWindow;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((viewWindow = gui->GetViewWindow()) == NULL)
    return;

  if (viewWindow->shown())
    viewWindow->hide();
  else
    viewWindow->show();
#endif /* 0 */
}

void
VtkAbstractToolBarViewCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarViewCb(static_cast<Fl_Widget*>(aButton), aPtr); }

void
VtkAbstractToolBarViewCb (Fl_Menu_* aMenu, void*)
{ VtkAbstractToolBarViewCb(static_cast<Fl_Widget*>(aMenu), aMenu->user_data()); }

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarSurfacePropertiesCb (Fl_Widget*, void* aPtr)
{
  vtkAbstractToolBarUI* gui;
  Fl_VTK_View*          view;
  Fl_Toggle_Tree*       toggleTree;
  Fl_Toggle_Node*       selectedNode;
  vtkObject*            object;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((view = gui->GetView()) == NULL)
    return;
  if ((toggleTree = gui->GetNodeBrowser()) == NULL)
    return;
  if ((selectedNode = toggleTree->selected_node()) == NULL)
    return;

  toggleTree->traverse_start(selectedNode);

  if ((object = reinterpret_cast<vtkObject*>(selectedNode->user_data()))!= NULL)
    {
    vtkActor*    actor;
    vtkAssembly* assembly;
    
    if      ((actor = vtkActor::SafeDownCast(object)) != NULL)
      {
      vtkAbstractSurfacePropertiesUI* surfacePropertiesUI;

      view->SetCurrentProp(actor);

      if ((surfacePropertiesUI = ::sgGetSurfacePropertiesUI(gui)) == NULL)
        return;

      if (surfacePropertiesUI->Shown())
        surfacePropertiesUI->Hide();
      else
        surfacePropertiesUI->Show();
      }
    else if ((assembly = vtkAssembly::SafeDownCast(object)) != NULL)
      {
      Fl::warning("NodePropertiesCb() not yet implemented for Groups.");
      }
    }
}

void
VtkAbstractToolBarSurfacePropertiesCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarSurfacePropertiesCb(static_cast<Fl_Widget*>(aButton), aPtr); }

void
VtkAbstractToolBarSurfacePropertiesCb (Fl_Menu_* aMenu, void*)
{
  VtkAbstractToolBarSurfacePropertiesCb( static_cast<Fl_Widget*>(aMenu),
                              aMenu->user_data() );
}

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarLightingCb (Fl_Widget*, void* aPtr)
{
  vtkAbstractToolBarUI*         gui;
  vtkAbstractLightingUI*        lightingUI;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((lightingUI = ::sgGetLightingUI(gui)) == NULL)
    return;

  if (lightingUI->Shown())
    lightingUI->Hide();
  else
    lightingUI->Show();
}

void
VtkAbstractToolBarLightingCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarLightingCb(static_cast<Fl_Widget*>(aButton), aPtr); }

void
VtkAbstractToolBarLightingCb (Fl_Menu_* aMenu, void*)
{ VtkAbstractToolBarLightingCb(static_cast<Fl_Widget*>(aMenu), aMenu->user_data()); }

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarCameraCb (Fl_Widget*, void* aPtr)
{
  vtkAbstractToolBarUI* gui;
  vtkAbstractCameraUI*  cameraUI;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((cameraUI = ::sgGetCameraUI(gui)) == NULL)
    return;

  if (cameraUI->Shown())
    cameraUI->Hide();
  else
    cameraUI->Show();
}

void
VtkAbstractToolBarCameraCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarCameraCb(static_cast<Fl_Widget*>(aButton), aPtr); }

void
VtkAbstractToolBarCameraCb (Fl_Menu_* aMenu, void*)
{ VtkAbstractToolBarCameraCb(static_cast<Fl_Widget*>(aMenu), aMenu->user_data()); }

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarViewportCb (Fl_Widget*, void* aPtr)
{
  vtkAbstractToolBarUI*         gui;
  vtkAbstractViewportUI*        viewportUI;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((viewportUI = ::sgGetViewportUI(gui)) == NULL)
    return;

  if (viewportUI->Shown())
    viewportUI->Hide();
  else
    viewportUI->Show();
}

void
VtkAbstractToolBarViewportCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarViewportCb(static_cast<Fl_Widget*>(aButton), aPtr); }

void
VtkAbstractToolBarViewportCb (Fl_Menu_* aMenu, void*)
{ VtkAbstractToolBarViewportCb(static_cast<Fl_Widget*>(aMenu), aMenu->user_data()); }

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarNodeBrowserCb (Fl_Widget*, void* aPtr)
{
  vtkAbstractToolBarUI*         gui;
  vtkAbstractNodeBrowserUI*     nodeBrowserUI;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((nodeBrowserUI = ::sgGetNodeBrowserUI(gui)) == NULL)
    return;

  if (nodeBrowserUI->Shown())
    nodeBrowserUI->Hide();
  else
    nodeBrowserUI->Show();
}

void
VtkAbstractToolBarNodeBrowserCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarNodeBrowserCb(static_cast<Fl_Widget*>(aButton), aPtr); }

void
VtkAbstractToolBarNodeBrowserCb (Fl_Menu_* aMenu, void*)
{ VtkAbstractToolBarNodeBrowserCb(static_cast<Fl_Widget*>(aMenu), aMenu->user_data()); }

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarSourceBrowserCb (Fl_Widget*, void* aPtr)
{
  vtkAbstractToolBarUI*         gui;
  vtkAbstractSourceBrowserUI*   sourceBrowserUI;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((sourceBrowserUI = ::sgGetSourceBrowserUI(gui)) == NULL)
    return;

  if (sourceBrowserUI->Shown())
    sourceBrowserUI->Hide();
  else
    sourceBrowserUI->Show();
}

void
VtkAbstractToolBarSourceBrowserCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarSourceBrowserCb(static_cast<Fl_Widget*>(aButton), aPtr); }

void
VtkAbstractToolBarSourceBrowserCb (Fl_Menu_* aMenu, void*)
{
  VtkAbstractToolBarSourceBrowserCb( static_cast<Fl_Widget*>(aMenu),
                             aMenu->user_data() );
}

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarMessagesCb (Fl_Widget*, void*)
{
  if (SvvMsg.shown())
    SvvMsg.hide();
  else
    SvvMsg.show();
}

void
VtkAbstractToolBarMessagesCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarMessagesCb(static_cast<Fl_Widget*>(aButton),aPtr); }

void
VtkAbstractToolBarMessagesCb (Fl_Menu_* aMenu, void*)
{ VtkAbstractToolBarMessagesCb(static_cast<Fl_Widget*>(aMenu), aMenu->user_data()); }

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarExitCb (Fl_Widget*, void* aPtr)
{
  int x, y;

  Fl::get_mouse(x,y);
  
  SvvExit.position(x,y);
  SvvExit.user_data(aPtr);
  SvvExit.show();
}

void
VtkAbstractToolBarExitCb (Fl_Window* aWindow, void*)
{
  VtkAbstractToolBarExitCb((Fl_Widget *) 0, (void *) aWindow);
}

void
VtkAbstractToolBarExitCb (Fl_Button*, void* aPtr)
{
  vtkAbstractToolBarUI*  gui;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;

  VtkAbstractToolBarExitCb((Fl_Widget *) 0, aPtr);
}

void
VtkAbstractToolBarExitCb (Fl_Menu_* aMenu, void*)
{
  vtkAbstractToolBarUI*  gui;

  if (aMenu == NULL)
    return;
  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aMenu->user_data()))==NULL)
    return;

  VtkAbstractToolBarExitCb((Fl_Widget *) 0, (void *) gui->GetTopWindow());
}

void
VtkAbstractToolBarExitCheck (void* aPtr)
{
  vtkAbstractToolBarUI* gui;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;

  if (!gui->Shown() && !SvvExit.shown())
    {
    VtkAbstractToolBarExitCb((Fl_Widget *) 0, (void *) gui->GetTopWindow());
    }
}

// ----------------------------------------------------------------------------
// Write the render window contents to a 2D image file.
// ----------------------------------------------------------------------------
void
VtkAbstractToolBarWriteImageCb (Fl_Widget*, void* aPtr)
{
  vtkAbstractToolBarUI* gui;
  Fl_VTK_View*          view;
  char*                 pathName = NULL;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((view = gui->GetView()) == NULL)
    return;

  if ( (pathName = svv_newfile_chooser(
          "Write 2D Image of the Current View?",
          "Image Files (*.{bmp,jpg,jpeg,pgm,png,ppm,ps,eps,tif,tiff})" ))
       == NULL )
    return;

  const char* fileName = fl_filename_name(pathName);

  svvInfo(<< "Writing image: '" << pathName << "'");
  svvStatus(<< "Writing image: '" << fileName << "'");

  gui->ShowViewWindow(1/*wait till shown*/);

  // 

  if (view->WriteImage(pathName, 0/*type*/) == 0)
    {
    Fl::warning("Failed to write image file: '%s'",pathName);
    fl_alert("Failed to write image file: '%s'",pathName);
    }
}

void
VtkAbstractToolBarWriteImageCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarWriteImageCb(static_cast<Fl_Widget*>(aButton),aPtr); }

void
VtkAbstractToolBarWriteImageCb (Fl_Menu_* aMenu, void*)
{ VtkAbstractToolBarWriteImageCb(static_cast<Fl_Widget*>(aMenu), aMenu->user_data()); }

// ----------------------------------------------------------------------------
// Save/restore the contents of the renderer(s) to/from 3D file format.
// ----------------------------------------------------------------------------
void
VtkAbstractToolBarSaveDataCb (Fl_Widget*, void* aPtr)
{
  vtkAbstractToolBarUI* gui;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;

  // surface or voxel
  Fl::warning("VtkAbstractToolBarSaveDataCb() not yet implemented.");
}

void
VtkAbstractToolBarSaveDataCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarSaveDataCb(static_cast<Fl_Widget*>(aButton),aPtr); }

void
VtkAbstractToolBarSaveDataCb (Fl_Menu_* aMenu, void*)
{
  VtkAbstractToolBarSaveDataCb( static_cast<Fl_Widget*>(aMenu),
                                aMenu->user_data() );
}

void
VtkAbstractToolBarSaveSurfaceCb (Fl_Menu_* aMenu, void* aPtr)
{ VtkAbstractToolBarSaveDataCb(aMenu, aPtr); }

void
VtkAbstractToolBarSaveVolumeCb (Fl_Menu_* aMenu, void* aPtr)
{ VtkAbstractToolBarSaveDataCb(aMenu, aPtr); }

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarRotateToggleCb (Fl_Button* aButton, void* aPtr)
{
  vtkAbstractToolBarUI*      gui;
  Fl_VTK_View*               view;

  if (aButton == NULL)
    return;
  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((view = gui->GetView()) == NULL)
    return;

  if (aButton->value())
    view->append_push_enabled(FL_BUTTON1 | FL_CTRL);
  else
    view->clear_push_enabled(FL_BUTTON1 | FL_CTRL);
}

void
VtkAbstractToolBarTranslateToggleCb (Fl_Button* aButton, void* aPtr)
{
  vtkAbstractToolBarUI*      gui;
  Fl_VTK_View*               view;

  if (aButton == NULL)
    return;
  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((view = gui->GetView()) == NULL)
    return;

  if (aButton->value())
    view->append_push_enabled(FL_BUTTON2 | FL_SHIFT | FL_CTRL);
  else
    view->clear_push_enabled(FL_BUTTON2 | FL_SHIFT | FL_CTRL);
}

void
VtkAbstractToolBarScaleToggleCb (Fl_Button* aButton, void* aPtr)
{
  vtkAbstractToolBarUI*      gui;
  Fl_VTK_View*               view;

  if (aButton == NULL)
    return;
  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((view = gui->GetView()) == NULL)
    return;

  if (aButton->value())
    view->append_push_enabled(FL_BUTTON3 | FL_SHIFT | FL_CTRL);
  else
    view->clear_push_enabled(FL_BUTTON3 | FL_SHIFT | FL_CTRL);
}

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarCubeAxesToggleCb (Fl_Widget* aWidget, void* aPtr)
{
  vtkAbstractToolBarUI* gui;
  Fl_VTK_View*          view;
  Fl_Toggle_Tree*       toggleTree;
  vtkRenderer*          renderer;
  vtkProp*              axes = NULL;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((view = gui->GetView()) == NULL)
    return;
  if ((toggleTree = gui->GetNodeBrowser()) == NULL)
    return;
  if ((renderer = view->GetCurrentRenderer()) == NULL)
    return;

  Fl_Toggle_Node* rendererNode;
  Fl_Toggle_Node* axesNode;

  if ((rendererNode = toggleTree->find(renderer)) == NULL)
    {
    vtkGenericWarningMacro(<< "Failed to get renderer node.");
    return;
    }

  if (svv.ToggleAxes(renderer, &axes))
    {
    svvDebug(<< "Axes ON (" << axes << ")");
    svvStatus(<< "Axes ON");

    if ((axesNode = toggleTree->find(axes)) == NULL)
      {
      toggleTree->traverse_start(rendererNode);
      toggleTree->add_next_child("Axes", false, NULL, axes);
      }

    axes->Delete();
    }
  else
    {
    svvDebug(<< "Axes OFF (" << axes << ")");
    svvStatus(<< "Axes OFF");

    if (axes != NULL)
      {
      if ((axesNode = toggleTree->find(axes)) != NULL)
        {
        toggleTree->remove(axesNode);
        }

      axes->Delete();
      }
    }

  view->Update();
}

void
VtkAbstractToolBarCubeAxesToggleCb (Fl_Button* aButton, void* aPtr)
{
  if (aButton == NULL || aButton->type() != FL_TOGGLE_BUTTON)
    {
    VtkAbstractToolBarCubeAxesToggleCb(static_cast<Fl_Widget*>(aButton), aPtr);
    return;
    }

  vtkAbstractToolBarUI* gui;
  Fl_VTK_View*          view;
  Fl_Toggle_Tree*       toggleTree;
  vtkRenderer*          renderer;
  vtkProp*              axes = NULL;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((view = gui->GetView()) == NULL)
    return;
  if ((toggleTree = gui->GetNodeBrowser()) == NULL)
    return;
  if ((renderer = view->GetCurrentRenderer()) == NULL)
    return;

  Fl_Toggle_Node* rendererNode;
  Fl_Toggle_Node* axesNode;

  if ((rendererNode = toggleTree->find(renderer)) == NULL)
    {
    vtkGenericWarningMacro(<< "Failed to get renderer node.");
    return;
    }

  if (aButton->value())
    {
    if ((axes = svv.UpdateAxes(renderer)) == NULL)
      {
      vtkGenericWarningMacro(<< "Failed to create axes.");
      return;
      }

    svvDebug(<< "Axes ON (" << axes << ")");
    svvStatus(<< "Axes ON");

    if ((axesNode = toggleTree->find(axes)) == NULL)
      {
      toggleTree->traverse_start(rendererNode);
      toggleTree->add_next_child("Axes", false, NULL, axes);
      }
    }
  else
    {
    if ((axes = svv.GetAxes(renderer)) != NULL)
      {
      svvDebug(<< "Axes OFF (" << axes << ")");
      svvStatus(<< "Axes OFF");

      if ((axesNode = toggleTree->find(axes)) != NULL)
        {
        toggleTree->remove(axesNode);
        }

      renderer->RemoveProp(axes);
      }
    }

  view->Update();
}

void
VtkAbstractToolBarCubeAxesToggleCb (Fl_Menu_* aMenu, void*)
{
  VtkAbstractToolBarCubeAxesToggleCb( static_cast<Fl_Widget*>(aMenu),
                                      aMenu->user_data() );
}

void
VtkAbstractToolBarBoundingBoxToggleCb (Fl_Button*, void* aPtr)
{
  vtkAbstractToolBarUI* gui;
  Fl_VTK_View*          view;
  Fl_Toggle_Tree*       toggleTree;
  vtkRenderer*          renderer;
  vtkProp3D*            boundingBox = NULL;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((view = gui->GetView()) == NULL)
    return;
  if ((toggleTree = gui->GetNodeBrowser()) == NULL)
    return;
  if ((renderer = view->GetCurrentRenderer()) == NULL)
    return;

  if ((boundingBox = svv.GetBoundingBox()) == NULL)
    {
    if ((boundingBox = svv.GetBoundingBox(renderer)) == NULL)
      {
      vtkGenericWarningMacro(<< "Failed to create bounding box.");
      return;
      }

    Fl_Toggle_Node* rendererNode;

    if ((rendererNode = toggleTree->find(renderer)) == NULL)
      {
      vtkGenericWarningMacro(<< "Failed to get renderer node.");
      return;
      }

    view->AddProp(boundingBox);
    toggleTree->traverse_start(rendererNode);
    toggleTree->add_next_child("Bounding Box", false, NULL, boundingBox);
    }
  else
    {
    Fl_Toggle_Node* node;

    if ((node = toggleTree->find(boundingBox)) == NULL)
      {
      if ((boundingBox = svv.GetBoundingBox(renderer)) == NULL)
        {
        vtkGenericWarningMacro(<< "Failed to create bounding box.");
        return;
        }

      Fl_Toggle_Node* rendererNode;

      if ((rendererNode = toggleTree->find(renderer)) == NULL)
        {
        vtkGenericWarningMacro(<< "Failed to get renderer node.");
        return;
        }

      view->AddProp(boundingBox);
      toggleTree->traverse_start(rendererNode);
      toggleTree->add_next_child("Bounding Box", false, NULL, boundingBox);
      }
    else
      {
      toggleTree->remove(node);
      view->RemoveProp(boundingBox);
      }
    }

  gui->GetView()->Update();
}

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarDepthSortToggleCb (Fl_Widget*, void* aPtr)
{
  vtkAbstractToolBarUI* gui;
  Fl_VTK_View*          view;
  vtkRenderer*          renderer;

  if ((gui = reinterpret_cast<vtkAbstractToolBarUI*>(aPtr)) == NULL)
    return;
  if ((view = gui->GetView()) == NULL)
    return;
  if ((renderer = view->GetCurrentRenderer()) == NULL)
    return;

  vtkActorCollection*   actorCollection = renderer->GetActors();
  vtkActor*             actor;
  vtkPolyDataMapper*    mapper;
  vtkPolyData*          input;
  vtkPolyDataSource*    source;
  vtkDepthSortPolyData* depthSorter;
  vtkProperty*          frontProperty;
  vtkProperty*          backProperty;

  vtkTraversal          traversal;
  vtkProcessObject*     ptr;

  for ( actorCollection->InitTraversal();
        (actor = actorCollection->GetNextActor()) != NULL; )
    {
    if ((mapper = vtkPolyDataMapper::SafeDownCast(actor->GetMapper())) != NULL)
      {
      traversal.UpdateTop(mapper);

      if ((input = mapper->GetInput()) != NULL)
        {
        if ((ptr = traversal.FindBySupertype("vtkDepthSortPolyData")) == NULL)
          {
          if ( ( (frontProperty = actor->GetProperty()) != NULL &&
                 frontProperty->GetOpacity() < 1.f ) ||
               ( (backProperty = actor->GetBackfaceProperty()) != NULL &&
                 backProperty->GetOpacity() < 1.f ) )
            {
            depthSorter = vtkDepthSortPolyData::New();
              {
              depthSorter->SetInput(input);
              depthSorter->SetProp3D(actor);
              depthSorter->SetDepthSortModeToParametricCenter();
              depthSorter->SetDirectionToBackToFront();
              depthSorter->SetCamera(renderer->GetActiveCamera());
              }
            vtkTraversal::Splice(depthSorter, mapper);
            mapper->Update();
            depthSorter->Delete();
            }
          }
        else
          {
          vtkTraversal::Remove(ptr);
          }
        }
      }
    }
}

void
VtkAbstractToolBarDepthSortToggleCb (Fl_Button* aButton, void* aPtr)
{ VtkAbstractToolBarDepthSortToggleCb(static_cast<Fl_Widget*>(aButton), aPtr); }

void
VtkAbstractToolBarDepthSortToggleCb (Fl_Menu_* aMenu, void*)
{ VtkAbstractToolBarDepthSortToggleCb( static_cast<Fl_Widget*>(aMenu),
                                       aMenu->user_data() ); }

// ----------------------------------------------------------------------------
void
VtkAbstractToolBarFileMenuCb (Fl_Menu_* aMenu, long aEnum)
{
  switch (aEnum)
    {
    case SVV_MENU_FILE_WRITE_IMAGE:
      VtkAbstractToolBarWriteImageCb(aMenu,0);
      break;
    case SVV_MENU_FILE_LOAD_SURFACE:
      SvvLoadSurfaceCb(aMenu,0);
      break;
    case SVV_MENU_FILE_LOAD_VOLUME:
      SvvLoadVolumeCb(aMenu,0);
      break;
    case SVV_MENU_FILE_LOAD_LIST:
      SvvLoadListCb(aMenu,0);
      break;
    case SVV_MENU_FILE_SAVE_SURFACE:
      VtkAbstractToolBarSaveSurfaceCb(aMenu,0);
      break;
    case SVV_MENU_FILE_SAVE_VOLUME:
      VtkAbstractToolBarSaveVolumeCb(aMenu,0);
      break;
    case SVV_MENU_FILE_SAVE_LIST:
      SvvSaveListCb(aMenu,0);
      break;
    case SVV_MENU_FILE_IMPORT:
      SvvImportCb(aMenu,0);
      break;
    case SVV_MENU_FILE_EXPORT:
      SvvExportCb(aMenu,0);
      break;
    case SVV_MENU_FILE_EXIT:
      VtkAbstractToolBarExitCb(aMenu,0);
      break;
    default:
      return;
    } // switch (aEnum)
}

void
VtkAbstractToolBarSourcesMenuCb (Fl_Menu_* aMenu, long aEnum)
{
  switch (aEnum)
    {
    case SVV_MENU_VISTAS_SOURCES_LOAD_SURFACE:
      break;
    case SVV_MENU_VISTAS_SOURCES_LOAD_VOLUME:
      break;
    case SVV_MENU_VISTAS_SOURCES_LOAD_LIST:
      break;
    case SVV_MENU_VISTAS_SOURCES_REMOVE:
      break;
    case SVV_MENU_VISTAS_SOURCES_SHOW:
      VtkAbstractToolBarSourceBrowserCb(aMenu,0);
      break;
    default:
      return;
    } // switch (aEnum)
}

void
VtkAbstractToolBarNodesMenuCb (Fl_Menu_* aMenu, long aEnum)
{
  switch (aEnum)
    {
    case SVV_MENU_VISTAS_NODES_PROPERTIES:
      VtkAbstractToolBarSurfacePropertiesCb(aMenu,0);
      break;
    case SVV_MENU_VISTAS_NODES_ATTRIBUTES:
      SvvNodeAttributesCb(aMenu,0);
      break;
    case SVV_MENU_VISTAS_NODES_FILTERING:
      SvvNodeFilteringCb(aMenu,0);
      break;
    case SVV_MENU_VISTAS_NODES_GROUP:
      SvvNodeGroupCb(aMenu,0);
      break;
    case SVV_MENU_VISTAS_NODES_REMOVE:
      SvvNodeRemoveCb(aMenu,0);
      break;
    case SVV_MENU_VISTAS_NODES_SHOW:
      VtkAbstractToolBarNodeBrowserCb(aMenu,0);
      break;
    default:
      return;
    } // switch (aEnum)
}

void
VtkAbstractToolBarRendererMenuCb (Fl_Menu_* aMenu, long aEnum)
{
  switch (aEnum)
    {
    case SVV_MENU_VISTAS_RENDERER_LIGHTING:
      VtkAbstractToolBarLightingCb(aMenu,0);
      break;
    case SVV_MENU_VISTAS_RENDERER_CAMERA:
      VtkAbstractToolBarCameraCb(aMenu,0);
      break;
    case SVV_MENU_VISTAS_RENDERER_VIEWPORT:
      VtkAbstractToolBarViewportCb(aMenu,0);
      break;
    case SVV_MENU_VISTAS_RENDERER_SHOW:
      VtkAbstractToolBarViewCb(aMenu,0);
      break;
    default:
      return;
    } // switch (aEnum)
}

void
VtkAbstractToolBarVistasMenuCb (Fl_Menu_* aMenu, long aEnum)
{
  switch (aEnum)
    {
    case SVV_MENU_VISTAS_MESSAGE_CONSOLE:
      VtkAbstractToolBarMessagesCb(aMenu,0);
      break;
    default:
      return;
    } // switch (aEnum)
}

void
VtkAbstractToolBarHelpMenuCb (Fl_Menu_* aMenu, long aEnum)
{
  switch (aEnum)
    {
    case SVV_MENU_HELP_USER:
      SvvHelpUserCb(aMenu,0);
      break;
    case SVV_MENU_HELP_DEVELOPER:
      SvvHelpDeveloperCb(aMenu,0);
      break;
    case SVV_MENU_HELP_ABOUT:
      SvvHelpAboutCb(aMenu,0);
      break;
    default:
      return;
    } // switch (aEnum)
}

/* 
 * End of: $Id: vtkAbstractToolBarCb.cxx,v 1.1.1.1 2006/12/19 22:59:46 christianh Exp $.
 * 
 */
