/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractUI.h,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_ABSTRACT_UI_H_
#  define VTK_ABSTRACT_UI_H_
// SVV
#  include "svvMacros.h"
// vtkExtensions
#  include "vtkRenderingContextFwd.h"
// VTK Common
#  include "vtkObject.h"

class vtkProp;
class vtkAssembly;
class vtkCamera;
class vtkLightCollection;
class vtkRenderer;
class vtkRenderWindow;
class vtkRenderWindowInteractor;
class Fl_Window;

class vtkAbstractUI : public vtkObject
{
public:
  vtkTypeRevisionMacro (vtkAbstractUI, vtkObject);
  void PrintSelf (ostream&, vtkIndent);

  /*@{*/
  /** Set/Get a name to associate with this interface. */
  void SetName (const char* name);
  vtkGetStringMacro (Name);
  /*@}*/

  /*@{*/
  /** Set/Get the label of the interface widget. */
  void SetLabel (const char* label);
  const char* GetLabel (void);
  /*@}*/

  /** Bring the client up-to-date with the interface. */
  void          UpdateClientRenderingContext (void);

  /*@{*/
  /** Set/Get the RenderingContext which is the client of this interface. */
  void          SetClientRenderingContext (VTK_EXTENSIONS_NAMESPACE_QUALIFIER
                                           vtkRenderingContext*
                                           aRenderingContext);
  vtkGetObjectMacro (ClientRenderingContext,
                     VTK_EXTENSIONS_NAMESPACE_QUALIFIER
                     vtkRenderingContext);
  /*@}*/

  /** Get the current client RenderWindowInteractor. */
  vtkRenderWindowInteractor*    GetClientInteractor (void);

  /** Get the current client RenderWindow. */
  vtkRenderWindow*              GetClientRenderWindow (void);

  /** Get the current client Renderer. */
  vtkRenderer*                  GetCurrentClientRenderer (void);

  /** Get the active Camera held by the current client Renderer. */
  vtkLightCollection*           GetCurrentClientLights (void);

  /** Get the LightCollection held by the current client Renderer. */
  vtkCamera*                    GetCurrentClientCamera (void);

  /** Get current Prop in current client Renderer or an Assembly therein. */
  vtkProp*                      GetCurrentClientProp (void);

  /** Get current Assembly in current client Renderer or an Assembly therein. */
  vtkAssembly*                  GetCurrentClientAssembly (void);

  /** Reset the active camera of the current client Renderer. */
  void                          ResetCurrentClientCamera (void);

  /** Reset clipping range of active camera of the current client Renderer. */
  void                          ResetCurrentClientCameraClippingRange (void);

  /** Get the FLTK widget. */
  Fl_Window*                    GetFltkWindow (void) const;

  /** Show the FLTK widget. */
  virtual void  Show (int argc, char* argv[]);

  /** Show the FLTK widget. */
  virtual void  Show (void);

  /** Returns whether the FLTK widget window is shown. */
  int           Shown (void);

  /** Hide the FLTK widget. */
  virtual void  Hide (void);

  void          Show (int argc, char* argv[], int wait);
  void          Show (int wait);
  void          Hide (int wait);

  virtual void  Default (vtkObject* = 0) = 0;
  virtual void  Send (vtkObject* = 0) = 0;
  virtual void  Receive (vtkObject* = 0) = 0;

protected:
  vtkAbstractUI (void);
  virtual ~vtkAbstractUI();

  VTK_EXTENSIONS_NAMESPACE_QUALIFIER
  vtkRenderingContext*  ClientRenderingContext;

  void          SetFltkWindow (Fl_Window* a);
  void          UpdateFltkWindowLabel (void);

  Fl_Window*    FltkWindow;
  char*         Name;
  char*         Label;
  char*         FltkWindowLabel;

private:
  vtkAbstractUI (const vtkAbstractUI&); // Not implemented.;
  void operator= (const vtkAbstractUI&); // Not implemented.;
};
#endif /* VTK_ABSTRACT_UI_H_ */
/*
 * End of: $Id: vtkAbstractUI.h,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $.
 *
 */
