/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractViewUI.cxx,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkViewUI.h"
#include "Fl_VTK_View.H"
// VTK
#include "vtkProp.h"
#include "vtkAssembly.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
// VTK Common
#include "vtkDebugLeaks.h"
#include "vtkObjectFactory.h"

// ----------------------------------------------------------------------------
//      v t k A b s t r a c t V i e w U I
// ----------------------------------------------------------------------------
vtkCxxRevisionMacro (vtkAbstractViewUI, "$Revision: 1.1.1.1 $");
vtkInstantiatorNewMacro (vtkAbstractViewUI);

// ----------------------------------------------------------------------------
vtkAbstractViewUI*
vtkAbstractViewUI::New (void)
{
  vtkObject* result = vtkObjectFactory::CreateInstance("vtkAbstractViewUI");

  if (result != NULL)
    {
    return static_cast<vtkAbstractViewUI*>(result);
    }

  vtkDebugLeaks::DestructClass("vtkAbstractViewUI");

  return vtkViewUI::New();
}

// ----------------------------------------------------------------------------
void
vtkAbstractViewUI::Default (vtkObject* vtkNotUsed(a))
{
  //this->Check();
}

void
vtkAbstractViewUI::Receive (vtkObject* vtkNotUsed(a))
{
  //this->Check();
}

void
vtkAbstractViewUI::Send (vtkObject* vtkNotUsed(a))
{
  //this->Check();
}

// ----------------------------------------------------------------------------
void
vtkAbstractViewUI::SetCurrentClientRenderer (vtkRenderer* aRenderer)
{
  Fl_VTK_View* view;

  if ((view = this->GetView()) != NULL)
    view->SetCurrentRenderer(aRenderer);
}

void
vtkAbstractViewUI::SetCurrentClientAssembly (vtkAssembly* aAssembly)
{
  Fl_VTK_View* view;

  if ((view = this->GetView()) != NULL)
    view->SetCurrentAssembly(aAssembly);
}

void
vtkAbstractViewUI::SetCurrentClientProp (vtkProp* aProp)
{
  Fl_VTK_View* view;

  if ((view = this->GetView()) != NULL)
    view->SetCurrentProp(aProp);
}

void
vtkAbstractViewUI::AddRendererToClient (vtkRenderer* aRenderer)
{
  Fl_VTK_View* view;

  if ((view = this->GetView()) != NULL)
    view->AddRenderer(aRenderer);
}

void
vtkAbstractViewUI::RemoveRendererFromClient (vtkRenderer* aRenderer)
{
  Fl_VTK_View* view;

  if ((view = this->GetView()) != NULL)
    view->RemoveRenderer(aRenderer);
}

void
vtkAbstractViewUI::AddPropToClient (vtkProp* aProp)
{
  Fl_VTK_View* view;

  if ((view = this->GetView()) != NULL)
    view->AddProp(aProp);
}

void
vtkAbstractViewUI::RemovePropFromClient (vtkProp* aProp)
{
  Fl_VTK_View* view;

  if ((view = this->GetView()) != NULL)
    view->RemoveProp(aProp);
}

void
vtkAbstractViewUI::RedrawView (void)
{
  this->UpdateClientRenderingContext();
}

void
vtkAbstractViewUI::ResetView (void)
{
  this->ResetCurrentClientCamera();
  this->UpdateClientRenderingContext();
}

void
vtkAbstractViewUI::Show (int argc, char* argv[])
{
  this->UpdateClientRenderingContext();

  if (this->FltkWindow != (Fl_Window *) 0)
    this->FltkWindow->show(argc, argv);
}

void
vtkAbstractViewUI::Show (void)
{
  this->UpdateClientRenderingContext();

  if (this->FltkWindow != (Fl_Window *) 0)
    this->FltkWindow->show();
}

void
vtkAbstractViewUI::PrintSelf (ostream& aTarget, vtkIndent aIndent)
{
  this->Superclass::PrintSelf(aTarget, aIndent);
}

/*
 * End of: $Id: vtkAbstractViewUI.cxx,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $.
 *
 */
