/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractViewUI.h,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_ABSTRACT_VIEW_UI_H_
#  define VTK_ABSTRACT_VIEW_UI_H_
#  include "vtkAbstractUI.h"

class Fl_VTK_View;

class vtkAbstractViewUI : public vtkAbstractUI
{
public:
  static vtkAbstractViewUI* New (void);
  vtkTypeRevisionMacro (vtkAbstractViewUI, vtkAbstractUI);
  void PrintSelf (ostream& aTarget, vtkIndent aIndent);

  void Default(vtkObject* = 0);
  void Receive(vtkObject* = 0);
  void Send(vtkObject* = 0);

  virtual void          Check (void) = 0;
  virtual Fl_VTK_View*  GetView (void) = 0;

  void                  SetCurrentClientRenderer (vtkRenderer*);
  void                  SetCurrentClientAssembly (vtkAssembly*);
  void                  SetCurrentClientProp (vtkProp*);
  void                  AddRendererToClient (vtkRenderer*);
  void                  RemoveRendererFromClient (vtkRenderer*);
  void                  AddPropToClient (vtkProp*);
  void                  RemovePropFromClient (vtkProp*);

  void                  RedrawView (void);
  void                  ResetView (void);

  void                  Show (int argc, char* argv[]);
  void                  Show (void);

protected:
  vtkAbstractViewUI (void) {}
  ~vtkAbstractViewUI() {}

private:
  vtkAbstractViewUI (const vtkAbstractViewUI&); // Not implemented.
  void operator= (const vtkAbstractViewUI&); // Not implemented.
};

#  define VTK_VIEW_UI_INTERFACE         \
  void          Check (void);           \
  Fl_VTK_View*  GetView (void)

#endif /* VTK_ABSTRACT_VIEW_UI_H_ */
/*
 * End of: $Id: vtkAbstractViewUI.h,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $.
 *
 */
