/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractViewportUI.h,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_ABSTRACT_VIEWPORT_UI_H_
#  define VTK_ABSTRACT_VIEWPORT_UI_H_
#  include "vtkAbstractUI.h"

class vtkAbstractViewportUI : public vtkAbstractUI
{
public:
  static vtkAbstractViewportUI* New (void);
  vtkTypeRevisionMacro (vtkAbstractViewportUI,vtkAbstractUI);

  void Send (vtkObject* = 0);
  void Receive (vtkObject* = 0);
  void Default (vtkObject* = 0);

  virtual void  Check (void) = 0;

  /** \name Culler methods */
  /*@{*/
  virtual void  GetSortingStyle (int&) = 0;
  virtual void  SetSortingStyle (int) = 0;
  /*@}*/

  /** \name Renderer methods */
  /*@{*/
  virtual void  GetViewport (float [4]) = 0;
  virtual void  SetViewport (float [4]) = 0;

  virtual void  GetTwoSidedLighting (int&) = 0;
  virtual void  SetTwoSidedLighting (int) = 0;

  virtual void  GetLightFollowCamera (int&) = 0;
  virtual void  SetLightFollowCamera (int) = 0;

  virtual void  GetBackingStore (int&) = 0;
  virtual void  SetBackingStore (int) = 0;
  /*@}*/

  /** \name RenderWindow methods */
  /*@{*/
  virtual void  GetPointSmoothing (int&) = 0;
  virtual void  SetPointSmoothing (int) = 0;

  virtual void  GetLineSmoothing (int&) = 0;
  virtual void  SetLineSmoothing (int) = 0;

  virtual void  GetPolygonSmoothing (int&) = 0;
  virtual void  SetPolygonSmoothing (int) = 0;
  /*@}*/

  /** \name RenderingContext methods */
  /*@{*/
  virtual void  GetDesiredUpdateRate (float&) = 0;
  virtual void  SetDesiredUpdateRate (float) = 0;

  virtual void  GetStillUpdateRate (float&) = 0;
  virtual void  SetStillUpdateRate (float) = 0;
  /*@}*/

protected:
  vtkAbstractViewportUI (void) {}
  ~vtkAbstractViewportUI() {}

private:
  vtkAbstractViewportUI (const vtkAbstractViewportUI&); // Not implemented.;
  void operator= (const vtkAbstractViewportUI&); // Not implemented.;
};

#  define VTK_VIEWPORT_UI_INTERFACE     \
  void  Check (void);                   \
  void  GetSortingStyle (int&);         \
  void  SetSortingStyle (int);          \
  void  GetViewport (float [4]);        \
  void  SetViewport (float [4]);        \
  void  GetTwoSidedLighting (int&);     \
  void  SetTwoSidedLighting (int);      \
  void  GetLightFollowCamera (int&);    \
  void  SetLightFollowCamera (int);     \
  void  GetBackingStore (int&);         \
  void  SetBackingStore (int);          \
  void  GetPointSmoothing (int&);       \
  void  SetPointSmoothing (int);        \
  void  GetLineSmoothing (int&);        \
  void  SetLineSmoothing (int);         \
  void  GetPolygonSmoothing (int&);     \
  void  SetPolygonSmoothing (int);      \
  void  GetDesiredUpdateRate (float&);  \
  void  SetDesiredUpdateRate (float);   \
  void  GetStillUpdateRate (float&);    \
  void  SetStillUpdateRate (float)

#endif /* VTK_ABSTRACT_VIEWPORT_UI_H_ */
/*
 * End of: $Id: vtkAbstractViewportUI.h,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $.
 *
 */
