/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkCameraUIImpl.cxx,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

void
vtkCameraUI::Check (void)
{
  Fl::check();
}

void
vtkCameraUI::GetWindowCenter (double a[2])
{
  a[0] = this->mWindowCenterX->value();
  a[1] = this->mWindowCenterY->value();
}

void
vtkCameraUI::SetWindowCenter (double a[2])
{
  this->mWindowCenterX->value(a[0]);
  this->mWindowCenterY->value(a[1]);
}

void
vtkCameraUI::GetFocalPoint (double a[3])
{
  a[0] = this->mFocalPointX->value();
  a[1] = this->mFocalPointY->value();
  a[2] = this->mFocalPointZ->value();
}

void
vtkCameraUI::SetFocalPoint (double a[3])
{
  this->mFocalPointX->value(a[0]);
  this->mFocalPointY->value(a[1]);
  this->mFocalPointZ->value(a[2]);
}

void
vtkCameraUI::GetPosition (double a[3])
{
  a[0] = this->mPositionX->value();
  a[1] = this->mPositionY->value();
  a[2] = this->mPositionZ->value();
}

void
vtkCameraUI::SetPosition (double a[3])
{
  this->mPositionX->value(a[0]);
  this->mPositionY->value(a[1]);
  this->mPositionZ->value(a[2]);
}

void
vtkCameraUI::GetClippingRange (double a[2])
{
  a[0] = this->mClippingRangeLow->value();
  a[1] = this->mClippingRangeHigh->value();
}

void
vtkCameraUI::SetClippingRange (double a[2])
{
  this->mClippingRangeLow->value(a[0]);
  this->mClippingRangeHigh->value(a[1]);
}

void
vtkCameraUI::GetViewUp (double a[3])
{
  a[0] = this->mViewUpX->value();
  a[1] = this->mViewUpY->value();
  a[2] = this->mViewUpZ->value();
}

void
vtkCameraUI::SetViewUp (double a[3])
{
  this->mViewUpX->value(a[0]);
  this->mViewUpY->value(a[1]);
  this->mViewUpZ->value(a[2]);
}

void
vtkCameraUI::GetViewAngle (double& a)
{
  a = this->mViewAngle->value();
}

void
vtkCameraUI::SetViewAngle (double a)
{
  this->mViewAngle->value(a);
}

void
vtkCameraUI::GetViewShear (double a[3])
{
  a[0] = this->mViewShearDXDZ->value();
  a[1] = this->mViewShearDYDZ->value();
  a[2] = this->mViewShearCenter->value();
}

void
vtkCameraUI::SetViewShear (double a[3])
{
  this->mViewShearDXDZ->value(a[0]);
  this->mViewShearDYDZ->value(a[1]);
  this->mViewShearCenter->value(a[2]);
}

void
vtkCameraUI::GetFocalDisk (double& a)
{
  a = this->mFocalDisk->value();
}

void
vtkCameraUI::SetFocalDisk (double a)
{
  this->mFocalDisk->value(a);
}

void
vtkCameraUI::GetEyeAngle (double& a)
{
  a = this->mEyeAngle->value();
}

void
vtkCameraUI::SetEyeAngle (double a)
{
  this->mEyeAngle->value(a);
}

void
vtkCameraUI::GetParallelProjection (int& a)
{
  a = this->mParallelProjection->value();

  if (a != 0) this->mParallelScaleGroup->activate();
  else        this->mParallelScaleGroup->deactivate();
}

void
vtkCameraUI::SetParallelProjection (int a)
{
  this->mParallelProjection->value(a);

  if (a != 0) this->mParallelScaleGroup->activate();
  else        this->mParallelScaleGroup->deactivate();
}

void
vtkCameraUI::GetUseHorizontalViewAngle (int& a)
{
  a = this->mUseHorizontalViewAngle->value();
}

void
vtkCameraUI::SetUseHorizontalViewAngle (int a)
{
  this->mUseHorizontalViewAngle->value(a);
}

void
vtkCameraUI::GetParallelScale (double& a)
{
  a = this->mParallelScale->value();
}

void
vtkCameraUI::SetParallelScale (double a)
{
  this->mParallelScale->value(a);
}

void
vtkCameraUI::GetObliqueAngles (double a[2])
{
  a[0] = this->mAlphaAngle->value();
  a[1] = this->mBetaAngle->value();
}

void
vtkCameraUI::SetObliqueAngles (double a[2])
{
  this->mAlphaAngle->value(a[0]);
  this->mBetaAngle->value(a[1]);
}

void
vtkCameraUI::GetDolly (double& a)
{
  a = this->mDolly->value();
}

void
vtkCameraUI::SetDolly (double a)
{
  this->mDolly->value(a);
}

void
vtkCameraUI::GetRoll (double& a)
{
  a = this->mRoll->value();
}

void
vtkCameraUI::SetRoll (double a)
{
  this->mRoll->value(a);
}

void
vtkCameraUI::GetElevation (double& a)
{
  a = this->mElevation->value();
}

void
vtkCameraUI::SetElevation (double a)
{
  this->mElevation->value(a);
}

void
vtkCameraUI::GetPitch (double& a)
{
  a = this->mPitch->value();
}

void
vtkCameraUI::SetPitch (double a)
{
  this->mPitch->value(a);
}

void
vtkCameraUI::GetAzimuth (double& a)
{
  a = this->mAzimuth->value();
}

void
vtkCameraUI::SetAzimuth (double a)
{
  this->mAzimuth->value(a);
}

void
vtkCameraUI::GetYaw (double& a)
{
  a = this->mYaw->value();
}

void
vtkCameraUI::SetYaw (double a)
{
  this->mYaw->value(a);
}

void
vtkCameraUI::GetZoom (double& a)
{
  a = this->mZoom->value();
}

void
vtkCameraUI::SetZoom (double a)
{
  this->mZoom->value(a);
}

/*
 * End of: $Id: vtkCameraUIImpl.cxx,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $.
 *
 */
