/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkMatrix4x4Cb.cxx,v 1.1.1.1 2006/12/19 22:59:49 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkMatrix4x4UI.h"
// VTK Common
#include "vtkMatrix4x4.h"
// FLTK
#include <FL/fl_ask.H>  // fl_message()

// ----------------------------------------------------------------------------
void
Matrix4x4UIValue00Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(0, 0, double(aInput->value()));
}

void
Matrix4x4UIValue01Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(0, 1, double(aInput->value()));
}

void
Matrix4x4UIValue02Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(0, 2, double(aInput->value()));
}

void
Matrix4x4UIValue03Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(0, 3, double(aInput->value()));
}

void
Matrix4x4UIValue10Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(1, 0, double(aInput->value()));
}

void
Matrix4x4UIValue11Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(1, 1, double(aInput->value()));
}

void
Matrix4x4UIValue12Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(1, 2, double(aInput->value()));
}

void
Matrix4x4UIValue13Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(1, 3, double(aInput->value()));
}

void
Matrix4x4UIValue20Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(2, 0, double(aInput->value()));
}

void
Matrix4x4UIValue21Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(2, 1, double(aInput->value()));
}

void
Matrix4x4UIValue22Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(2, 2, double(aInput->value()));
}

void
Matrix4x4UIValue23Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(2, 3, double(aInput->value()));
}

void
Matrix4x4UIValue30Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(3, 0, double(aInput->value()));
}

void
Matrix4x4UIValue31Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(3, 1, double(aInput->value()));
}

void
Matrix4x4UIValue32Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(3, 2, double(aInput->value()));
}

void
Matrix4x4UIValue33Cb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if (aInput == (Fl_Value_Input *) 0)
    return;
  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;
  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    return;

  matrix->SetElement(3, 3, double(aInput->value()));
}


// ----------------------------------------------------------------------------
void
Matrix4x4UIIdentityCb (Fl_Button*, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;

  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    {
    matrix->Identity();
    matrixUI->ReceiveInternal();
    }
}

void
Matrix4x4UIInvertCb (Fl_Button*, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;

  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    {
    matrix->Invert();
    matrixUI->ReceiveInternal();
    }
}

void
Matrix4x4UITransposeCb (Fl_Button*, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;
  vtkMatrix4x4*   matrix;

  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;

  if ((matrix = matrixUI->GetMatrix()) == (vtkMatrix4x4 *) 0)
    {
    matrix->Transpose();
    matrixUI->ReceiveInternal();
    }
}

// ----------------------------------------------------------------------------
void
Matrix4x4UIHelpCb (Fl_Button*, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;

  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;

  fl_message("Sorry, the 4x4 Transformation Matrix Help is not yet helpful.");
}

void
Matrix4x4UIApplyCb (Fl_Button*, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;

  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;

  matrixUI->Send();
  matrixUI->UpdateClientRenderingContext();
}

void
Matrix4x4UIUpdateCb (Fl_Button*, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;

  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;

  matrixUI->UpdateClientRenderingContext();
  matrixUI->Receive();
}

void
Matrix4x4UICloseCb (Fl_Button*, void* aPtr)
{
  vtkMatrix4x4UI* matrixUI;

  if ( (matrixUI = reinterpret_cast<vtkMatrix4x4UI*>(aPtr))
       == (vtkMatrix4x4UI *) 0 )
    return;

  matrixUI->Hide();
}

/*
 * End of: $Id: vtkMatrix4x4Cb.cxx,v 1.1.1.1 2006/12/19 22:59:49 christianh Exp $.
 *
 */
