/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkSurfacePropertiesCb.cxx,v 1.1.1.1 2006/12/19 22:59:49 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkSurfacePropertiesUI.h"
// FLTK
#include <FL/Fl.H>
#include <FL/Fl_Tabs.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Return_Button.H>
#include <FL/fl_ask.H>  // fl_message()
// VTK Rendering
#include "vtkActor.h"
#include "vtkProperty.h"
// vtkExtensions
#include "vtkRenderingContext.h"
// SVV
#include "svvModelSource.h"

#if 0
#  include "vtkUpstream.h"
#  include "vtkTransformTextureCoords.h"
#  include "vtkDataSetToDataSetFilter.h"
#  include "vtkMapper.h"
#  include "vtkDataSetMapper.h"
#  include "vtkPolyDataMapper.h"
#  include "vtkTextureMapToCylinder.h"
#  include "vtkTextureMapToSphere.h"
#  include "vtkTextureMapToPlane.h"
#endif /* 0 */

VTK_EXTENSIONS_NAMESPACE_USING(vtkRenderingContext);
SVV_NAMESPACE_USING(svvModelSource);

// ----------------------------------------------------------------------------
void
SurfacePropertiesTabsGroupCb (Fl_Tabs* aTabs, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  Fl_Widget*              activeWidget;

  if (aTabs == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((activeWidget = aTabs->value()) == NULL)
    return;

  if      (activeWidget == gui->mCompositeChooserGroup)
    {
    gui->ReceiveComposite();
    }
  else if (activeWidget == gui->mReflectanceGroup)
    {
    gui->ReceiveReflectance();
    }
  else if (activeWidget == gui->mFeaturesGroup)
    {
    gui->ReceiveFeatures();
    }
  else if (activeWidget == gui->mTextureGroup)
    {
    gui->ReceiveTexture();
    }
}

// ----------------------------------------------------------------------------
void
SeparateFacesCb (Fl_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aButton == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  vtkProperty* backProperty     = gui->GetDemoBackProperty();
  vtkProperty* stashedProperty  = gui->GetStashedProperty();

  if (aButton->value())
    {
    
    if ((backProperty == NULL) || (backProperty == frontProperty))
      {
      if ((stashedProperty == NULL) || (stashedProperty == frontProperty))
        {
        backProperty = vtkProperty::New();
        gui->SetDemoBackProperty(backProperty);
        backProperty->Delete();
        }
      else
        {
        gui->SetDemoBackProperty(stashedProperty);
        }
      }

    // Activate the interface for the back face groups.
    gui->ActivateBackGroups();
    }
  else
    {
    // Deactivate the interface for the back face groups.
    gui->DeactivateBackGroups();

    if (backProperty = gui->GetDemoBackProperty())
      {
      gui->SetStashedProperty(backProperty);
      }
    gui->SetDemoBackProperty(0);
    }

  // Sync Demo properties with those held by the interface.
  gui->ReceiveBack();
  gui->UpdateDemoGroups();
  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
SetModelCb (Fl_Menu_Button* aMenu, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  svvModelSource* modelSource;

  if (aMenu == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((modelSource = gui->GetModelSource()) == NULL)
    return;

  switch (aMenu->value())
    {
    case 0:  modelSource->SetModelToTeapot(); break;
    case 1:  modelSource->SetModelToCow(); break;
    case 2:  modelSource->SetModelToFace(); break;
    case 3:  modelSource->SetModelToBoiler(); break;
    case 4:  modelSource->SetModelToMotor(); break;
    case 5:  modelSource->SetModelToPialSurface(); break;
    case 6:  modelSource->SetModelToSphereSurface(); break;
    case 7:  modelSource->SetModelToInflatedSurface(); break;
    case 8:  modelSource->SetModelToCortexSurface(); break;
    default: modelSource->SetModelToTeapot(); break; /* should not happen */
    }

  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
HelpCb (Fl_Button*, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;

  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;

  fl_message("Sorry, the Surface Properties Help is not yet helpful.");
}

void
ApplySurfacePropertiesCb (Fl_Button*, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkActor*               demoActor;
  vtkActor*               clientActor;
  vtkProperty*            clientFrontProperty;
  vtkProperty*            demoFrontProperty;

  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = gui->GetDemoActor()) == NULL)
    return;
  if ((clientActor = gui->GetCurrentClientActor()) == NULL)
    return;
  if ((clientFrontProperty = clientActor->GetProperty()) == NULL)
    return;
  if ((demoFrontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  clientFrontProperty->DeepCopy(demoFrontProperty);

  vtkProperty* demoBackProperty;

  if ((demoBackProperty = gui->GetDemoBackProperty()) != NULL)
    {
    vtkProperty* clientBackProperty;

    if ((clientBackProperty = clientActor->GetBackfaceProperty()) == NULL)
      {
      clientBackProperty = vtkProperty::New();
      clientActor->SetBackfaceProperty(clientBackProperty);
      clientBackProperty->Delete();
      }

    clientBackProperty->DeepCopy(demoBackProperty);
    }
  else
    {
    clientActor->SetBackfaceProperty(NULL);
    }

#if 0
  vtkTexture* texture;

  if ((texture = gui->GetDemoTexture()) != (vtkTexture *) 0)
    {
    clientActor->SetTexture(texture);
    }
  else
    {
    clientActor->SetTexture((vtkTexture *) 0);
    }

  vtkTransformTextureCoords* demoTx  = NULL;
  vtkDataSetToDataSetFilter* demoFilter =
    vtkSurfacePropertiesUI::FindTextureCoordsGenerator(demoActor,&demoTx);
  
  vtkTransformTextureCoords* clientTx  = NULL;
  vtkDataSetToDataSetFilter* clientFilter =
    vtkSurfacePropertiesUI::FindTextureCoordsGenerator(clientActor,&clientTx);

  if      (demoFilter != NULL)
    {
    // Remove any non-matching client filter.
    if ( (clientFilter != NULL) &&
         (clientFilter->IsA(demoFilter->GetClassName()) == 0) )
      {
      vtkUpstream* upstream = vtkUpstream::New();
      
      upstream->SetSource(clientActor);
      
      if (upstream->RemovePipelineSource(clientFilter) == 0)
        Fl::error( "ApplySurfacePropertiesCb() failed to remove source"
                   " (0x%p).", clientFilter );

      upstream->Delete();
      clientFilter = NULL;
      }

    if      (demoTx == NULL && clientTx != NULL)
      {
      vtkUpstream* upstream = vtkUpstream::New();
      
      upstream->SetSource(clientActor);
      
      if (upstream->RemovePipelineSource(clientTx) == 0)
        Fl::error( "ApplySurfacePropertiesCb() failed to remove source"
                   " (0x%p).", clientTx );

      upstream->Delete();
      clientTx = NULL;
      }
    else if (demoTx != NULL && clientTx == NULL)
      {
      clientTx = vtkTransformTextureCoords::New();

      vtkMapper*         mapper = clientActor->GetMapper();
      vtkDataSetMapper*  dataSetMapper;
      vtkPolyDataMapper* polyDataMapper;

      clientTx->SetInput(mapper->GetInput());

      if      (polyDataMapper = vtkPolyDataMapper::SafeDownCast(mapper))
        {
        polyDataMapper->SetInput(clientTx->GetPolyDataOutput());
        }
      else if (dataSetMapper = vtkDataSetMapper::SafeDownCast(mapper))
        {
        dataSetMapper->SetInput(clientTx->GetOutput());
        }

      clientTx->Delete();
      }

    // Ensure existence of matching client filter.
    if (clientFilter == NULL)
      {
      vtkTextureMapToCylinder* mapToCylinder;
      vtkTextureMapToSphere*   mapToSphere;
      vtkTextureMapToPlane*    mapToPlane;

      if      (demoFilter->IsA("vtkTextureMapToPlane"))
        {
        clientFilter = mapToPlane = vtkTextureMapToPlane::New();
        mapToPlane->AutomaticPlaneGenerationOn();
        }
      else if (demoFilter->IsA("vtkTextureMapToCylinder"))
        {
        clientFilter = mapToCylinder = vtkTextureMapToCylinder::New();
        mapToCylinder->AutomaticCylinderGenerationOn();
        }
      else if (demoFilter->IsA("vtkTextureMapToSphere"))
        {
        clientFilter = mapToSphere = vtkTextureMapToSphere::New();
        mapToSphere->AutomaticSphereGenerationOn();
        }

      if (clientTx != NULL)
        {
        clientFilter->SetInput(clientTx->GetInput());
        clientTx->SetInput(clientFilter->GetOutput());
        }
      else
        {
        vtkMapper*         mapper = demoActor->GetMapper();
        vtkDataSetMapper*  dataSetMapper;
        vtkPolyDataMapper* polyDataMapper;

        clientFilter->SetInput(mapper->GetInput());

        if      (polyDataMapper = vtkPolyDataMapper::SafeDownCast(mapper))
          {
          polyDataMapper->SetInput(clientFilter->GetPolyDataOutput());
          }
        else if (dataSetMapper = vtkDataSetMapper::SafeDownCast(mapper))
          {
          dataSetMapper->SetInput(clientFilter->GetOutput());
          }
        }

      clientFilter->Delete();
      }

    if      (demoFilter->IsA("vtkTextureMapToCylinder"))
      (static_cast<vtkTextureMapToCylinder*>(clientFilter))->
        SetPreventSeam((static_cast<vtkTextureMapToCylinder*>(demoFilter))->
                       GetPreventSeam());
    else if (demoFilter->IsA("vtkTextureMapToSphere"))
      (static_cast<vtkTextureMapToSphere*>(clientFilter))->
        SetPreventSeam((static_cast<vtkTextureMapToSphere*>(demoFilter))->
                       GetPreventSeam());

    if (demoTx != NULL && clientTx != NULL)
      {
      float tmp[3];

      demoTx->GetPosition(tmp);
      clientTx->SetPosition(tmp);
      demoTx->GetOrigin(tmp);
      clientTx->SetOrigin(tmp);
      demoTx->GetScale(tmp);
      clientTx->SetScale(tmp);

      clientTx->SetFlipR(demoTx->GetFlipR());
      clientTx->SetFlipS(demoTx->GetFlipS());
      clientTx->SetFlipT(demoTx->GetFlipT());
      }
    }
  else if (clientFilter != NULL)
    {
    vtkUpstream* upstream = vtkUpstream::New();
      
    upstream->SetSource(clientActor);
      
    if (upstream->RemovePipelineSource(clientFilter) == 0)
      Fl::warning( "ApplySurfacePropertiesCb() failed to remove source"
                   " (0x%p).", clientFilter );

    upstream->Delete();
    }
#endif /* 0 */

  gui->UpdateClientRenderingContext();
  gui->UpdateDemoRenderingContext();
}

void
UpdateSurfacePropertiesCb (Fl_Button*, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;

  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;

  gui->Update();
}

void
RevertSurfacePropertiesCb (Fl_Button*, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkActor*               clientActor;
  vtkProperty*            clientFrontProperty;
  vtkProperty*            originalFrontProperty;

  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((clientActor = gui->GetCurrentClientActor()) == NULL)
    return;
  if ((clientFrontProperty = clientActor->GetProperty()) == NULL)
    return;
  if ((originalFrontProperty = gui->GetOriginalFrontProperty()) == NULL)
    return;

  clientFrontProperty->DeepCopy(originalFrontProperty);

  vtkProperty* originalBackProperty;

  if ((originalBackProperty = gui->GetOriginalBackProperty()) != NULL)
    {
    vtkProperty* clientBackProperty;

    if ((clientBackProperty = clientActor->GetBackfaceProperty()) == NULL)
      {
      clientBackProperty = vtkProperty::New();
      clientActor->SetBackfaceProperty(clientBackProperty);
      clientBackProperty->Delete();
      }

    clientBackProperty->DeepCopy(originalBackProperty);
    }
  else
    {
    clientActor->SetBackfaceProperty(NULL);
    }

  gui->Receive(clientActor);

  gui->InitializeDemo();
  gui->UpdateClientRenderingContext();
  gui->UpdateDemoRenderingContext();
}

void
AcceptSurfacePropertiesCb (Fl_Return_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;

  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;

  ApplySurfacePropertiesCb(aButton, aPtr);
  
  gui->Hide();
}

/* 
 * End of: $Id: vtkSurfacePropertiesCb.cxx,v 1.1.1.1 2006/12/19 22:59:49 christianh Exp $.
 * 
 */
