/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkSurfacePropertiesFeaturesCb.cxx,v 1.1.1.1 2006/12/19 22:59:49 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkSurfacePropertiesUI.h"
// FLTK
#include <FL/Fl.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Value_Input.H>
// VTK Rendering
#include "vtkProperty.h"

// ----------------------------------------------------------------------------
void
FrontInterpolationCb (Fl_Choice* aChoice, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aChoice == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  switch (aChoice->value())
    {
    case 0: frontProperty->SetInterpolationToFlat(); break;
    case 1: frontProperty->SetInterpolationToGouraud(); break;
    case 2: frontProperty->SetInterpolationToPhong(); break;
    }

  gui->UpdateDemoRenderingContext();
}

void
BackInterpolationCb (Fl_Choice* aChoice, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aChoice == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty  = gui->GetDemoBackProperty()) == NULL)
    return;

  switch (aChoice->value())
    {
    case 0: backProperty->SetInterpolationToFlat(); break;
    case 1: backProperty->SetInterpolationToGouraud(); break;
    case 2: backProperty->SetInterpolationToPhong(); break;
    }

  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontRepresentationCb (Fl_Choice* aChoice, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aChoice == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  switch (aChoice->value())
    {
    case 0: frontProperty->SetRepresentationToPoints(); break;
    case 1: frontProperty->SetRepresentationToWireframe(); break;
    case 2: frontProperty->SetRepresentationToSurface(); break;
    }
  
  gui->UpdateDemoRenderingContext();
}

void
BackRepresentationCb (Fl_Choice* aChoice, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aChoice == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  switch (aChoice->value())
    {
    case 0: backProperty->SetRepresentationToPoints(); break;
    case 1: backProperty->SetRepresentationToWireframe(); break;
    case 2: backProperty->SetRepresentationToSurface(); break;
    }

  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontPointSizeCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  frontProperty->SetPointSize(float(aInput->value()));

  gui->UpdateDemoRenderingContext();
}

void
BackPointSizeCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty  = gui->GetDemoBackProperty()) == NULL)
    return;

  backProperty->SetPointSize(float(aInput->value()));

  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontLineWidthCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  frontProperty->SetLineWidth(float(aInput->value()));

  gui->UpdateDemoRenderingContext();
}

void
BackLineWidthCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty  = gui->GetDemoBackProperty()) == NULL)
    return;

  backProperty->SetLineWidth(float(aInput->value()));

  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontFaceCullingCb (Fl_Choice* aChoice, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aChoice == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  switch (aChoice->value())
    {
    case 0: // none
      frontProperty->BackfaceCullingOff();
      frontProperty->FrontfaceCullingOff();
      break;
    case 1: // back
      frontProperty->BackfaceCullingOn();
      frontProperty->FrontfaceCullingOff();
      break;
    case 2: // front
      frontProperty->BackfaceCullingOff();
      frontProperty->FrontfaceCullingOn();
      break;
    }

  gui->UpdateDemoRenderingContext();
}

void
BackFaceCullingCb (Fl_Choice* aChoice, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aChoice == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  switch (aChoice->value())
    {
    case 0: // none
      backProperty->BackfaceCullingOff();
      backProperty->FrontfaceCullingOff();
      break;
    case 1: // back
      backProperty->BackfaceCullingOn();
      backProperty->FrontfaceCullingOff();
      break;
    case 2: // front
      backProperty->BackfaceCullingOff();
      backProperty->FrontfaceCullingOn();
      break;
    }

  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontEdgesToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aButton == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  if (aButton->value())
    {
    frontProperty->EdgeVisibilityOn();
    gui->mFrontEdgesColorGroup->activate();
    frontProperty->SetEdgeColor( float(gui->mFrontEdgesRed->value()),
                                 float(gui->mFrontEdgesGreen->value()),
                                 float(gui->mFrontEdgesBlue->value()) );
    }
  else
    {
    frontProperty->EdgeVisibilityOff();
    gui->mFrontEdgesColorGroup->deactivate();
    }

  gui->UpdateDemoRenderingContext();
}

void
FrontEdgesRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetEdgeColor(rgb);
  frontProperty->SetEdgeColor(float(aInput->value()),rgb[1],rgb[2]);

  gui->UpdateDemoRenderingContext();
}

void
FrontEdgesGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetEdgeColor(rgb);
  frontProperty->SetEdgeColor(rgb[0],float(aInput->value()),rgb[2]);

  gui->UpdateDemoRenderingContext();
}

void
FrontEdgesBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetEdgeColor(rgb);
  frontProperty->SetEdgeColor(rgb[0],rgb[1],float(aInput->value()));

  gui->UpdateDemoRenderingContext();
}

void
BackEdgesToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aButton == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  if (aButton->value())
    {
    backProperty->EdgeVisibilityOn();
    gui->mBackEdgesColorGroup->activate();
    backProperty->SetEdgeColor( float(gui->mBackEdgesRed->value()),
                                float(gui->mBackEdgesGreen->value()),
                                float(gui->mBackEdgesBlue->value()) );
    }
  else
    {
    backProperty->EdgeVisibilityOff();
    gui->mBackEdgesColorGroup->deactivate();
    }

  gui->UpdateDemoRenderingContext();
}

void
BackEdgesRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetEdgeColor(rgb);
  backProperty->SetEdgeColor(float(aInput->value()),rgb[1],rgb[2]);

  gui->UpdateDemoRenderingContext();
}

void
BackEdgesGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetEdgeColor(rgb);
  backProperty->SetEdgeColor(rgb[0],float(aInput->value()),rgb[2]);

  gui->UpdateDemoRenderingContext();
}

void
BackEdgesBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetEdgeColor(rgb);
  backProperty->SetEdgeColor(rgb[0],rgb[1],float(aInput->value()));

  gui->UpdateDemoRenderingContext();
}

/* 
 * End of: $Id: vtkSurfacePropertiesFeaturesCb.cxx,v 1.1.1.1 2006/12/19 22:59:49 christianh Exp $.
 * 
 */
