/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkSurfacePropertiesTextureCb.cxx,v 1.1.1.1 2006/12/19 22:59:50 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkSurfacePropertiesUI.h"
// IOStreams
#include <iostream>
// FLTK
#include <FL/Fl.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_File_Chooser.H>
// VTK
#include "vtkDataSet.h"
#include "vtkImageData.h"
#include "vtkStructuredPoints.h"
#include "vtkPolyData.h"
#include "vtkRectilinearGrid.h"
#include "vtkStructuredGrid.h"
#include "vtkUnstructuredGrid.h"
#include "vtkSource.h"
#include "vtkTexture.h"
#include "vtkMapper.h"
#include "vtkDataSetMapper.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkTextureMapToPlane.h"
#include "vtkTextureMapToCylinder.h"
#include "vtkTextureMapToSphere.h"
#include "vtkTransformTextureCoords.h"
#include "vtkDataSetToDataSetFilter.h"

#include "vtkDataSetToImageFilter.h"
#include "vtkImageSource.h"
#include "vtkImageMultipleInputFilter.h"
#include "vtkImageToImageFilter.h"
#include "vtkImageStencilSource.h"
#include "vtkImageToImageStencil.h"
#include "vtkPolyDataToImageStencil.h"
#include "vtkPointSetToPointSetFilter.h"
#include "vtkPolyDataSource.h"
#include "vtkDataSetToPolyDataFilter.h"
#include "vtkPolyDataToPolyDataFilter.h"
#include "vtkRectilinearGridToPolyDataFilter.h"
#include "vtkStructuredGridToPolyDataFilter.h"
#include "vtkStructuredPointsToPolyDataFilter.h"
#include "vtkUnstructuredGridToPolyDataFilter.h"
#include "vtkStructuredPointsSource.h"
#include "vtkDataSetToStructuredPointsFilter.h"
#include "vtkStructuredPointsToStructuredPointsFilter.h"
#include "vtkUnstructuredGridSource.h"
#include "vtkDataSetToUnstructuredGridFilter.h"
#include "vtkStructuredPointsToUnstructuredGridFilter.h"
// vtkExtensions
#include "vtkUpstream.h"
#include "vtkRenderingContext.h"

VTK_EXTENSIONS_NAMESPACE_USING(vtkRenderingContext);

// ----------------------------------------------------------------------------
void
TextureLoad2DCb (Fl_Button*, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkRenderingContext*    renderingContext;

  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((renderingContext = GUI->GetClientRenderingContext()) == NULL)
    return;

  vtkTexture* texture  = NULL;
  char*       fileName = NULL;

  if ( fileName = fl_file_chooser(
         "Read 2D image as texture data.",
         "Image Files (*.{bmp,jpg,jpeg,pgm,png,ppm,ps,eps,tif,tiff})",
         0/*NULL ... defaults to last filename*/) )
    {
    if ((texture = renderingContext->MakeTexture(fileName)) != NULL)
      {
      GUI->SetDemoTexture(texture);
      texture->SetRepeat(int(GUI->mTextureRepeatToggle->value()));
      texture->SetInterpolate(int(GUI->mTextureInterpolateToggle->value()));

      switch (GUI->mTextureQualityMenu->value())
        {
        case 1:  texture->SetQualityTo16Bit(); break;
        case 2:  texture->SetQualityTo32Bit(); break;
        case 0:
        default: texture->SetQualityToDefault(); break;
        }

      texture->Delete();

      GUI->UpdateDemoRenderingContext();
      }
    else
      {
      fl_alert("Failed to create texture from file: '%s'", fileName);
      }
    }
}

void
TextureUnloadCb (Fl_Button*, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;

  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;

  GUI->SetDemoTexture((vtkTexture *) 0);
  GUI->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
TextureRepeatToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkTexture*             texture;

  if (aButton == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((texture = GUI->GetDemoTexture()) == NULL)
    return;

  texture->SetRepeat(int(aButton->value()));

  GUI->UpdateDemoRenderingContext();
}

void
TextureInterpolateToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkTexture*             texture;

  if (aButton == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((texture = GUI->GetDemoTexture()) == NULL)
    return;

  texture->SetInterpolate(int(aButton->value()));

  GUI->UpdateDemoRenderingContext();
}

void
TextureQualityCb (Fl_Choice* aChoice, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkTexture*             texture;

  if (aChoice == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((texture = GUI->GetDemoTexture()) == NULL)
    return;

  switch (aChoice->value())
    {
    case 1:  texture->SetQualityTo16Bit(); break;
    case 2:  texture->SetQualityTo32Bit(); break;
    case 0:
    default: texture->SetQualityToDefault(); break;
    }

  GUI->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
TextureMappingToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aButton == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  vtkTransformTextureCoords* texTx = 0;
  vtkDataSetToDataSetFilter* filter =
    vtkSurfacePropertiesUI::FindTextureCoordsGenerator(demoActor, &texTx);

  if (aButton->value())
    {
    GUI->mTextureMappingGroup->activate();

    if (filter == NULL)
      {
      vtkTextureMapToCylinder* mapToCylinder;
      vtkTextureMapToSphere*   mapToSphere;
      vtkTextureMapToPlane*    mapToPlane;

      switch (GUI->mTextureMappingMenu->value())
        {
        case 1:
          filter = mapToCylinder = vtkTextureMapToCylinder::New();
          mapToCylinder->AutomaticCylinderGenerationOn();
          mapToCylinder->
            SetPreventSeam(int(GUI->mTexturePreventSeamToggle->value()));
          break;
        case 2:
          filter = mapToSphere = vtkTextureMapToSphere::New();
          mapToSphere->AutomaticSphereGenerationOn();
          mapToSphere->
            SetPreventSeam(int(GUI->mTexturePreventSeamToggle->value()));
          break;
        case 0:
        default:
          filter = mapToPlane = vtkTextureMapToPlane::New();
          mapToPlane->AutomaticPlaneGenerationOn();
          break;
        }

      if (texTx != NULL)
        {
	filter->SetInput(texTx->GetInput());
	texTx->SetInput(filter->GetOutput());
        }
      else
        {
	vtkMapper*         mapper = demoActor->GetMapper();
	vtkDataSetMapper*  dataSetMapper;
	vtkPolyDataMapper* polyDataMapper;

	filter->SetInput(mapper->GetInput());

	if      (polyDataMapper = vtkPolyDataMapper::SafeDownCast(mapper))
          {
	  polyDataMapper->SetInput(filter->GetPolyDataOutput());
          }
	else if (dataSetMapper = vtkDataSetMapper::SafeDownCast(mapper))
          {
	  dataSetMapper->SetInput(filter->GetOutput());
          }
        }

      filter->Delete();
      }
    }
  else
    {
    GUI->mTextureMappingGroup->deactivate();

    if (filter != NULL)
      {
      vtkUpstream* upstream = vtkUpstream::New();

      upstream->SetSource(demoActor);

      if (!(upstream->RemovePipelineSource(filter)))
        {
	fl_alert("TextureMappingToggleCb() failed to remove source (0x%p).",
		 filter);
        }
      upstream->Delete();
      }

    }

  GUI->UpdateDemoRenderingContext();
}

void
TextureMappingCb (Fl_Choice* aChoice, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aChoice == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  vtkDataSetToDataSetFilter* filter = 0;

  switch (aChoice->value())
    {

    case 1:
      //filter = mapToCylinder = vtkTextureMapToCylinder::New();
      //mapToCylinder->AutomaticCylinderGenerationOn();
      GUI->mTexturePreventSeamToggle->activate();
      //mapToCylinder->
      //  SetPreventSeam(int(GUI->mTexturePreventSeamToggle->value()));
      break;

    case 2:
      //filter = mapToSphere = vtkTextureMapToSphere::New();
      //mapToSphere->AutomaticSphereGenerationOn();
      GUI->mTexturePreventSeamToggle->activate();
      //mapToSphere->
      //  SetPreventSeam(int(GUI->mTexturePreventSeamToggle->value()));
      break;

    case 0:
    default:
      //filter = mapToPlane = vtkTextureMapToPlane::New();
      //mapToPlane->AutomaticPlaneGenerationOn();

      GUI->mTexturePreventSeamToggle->deactivate();
      break;

    } // switch (aChoice->value())

  GUI->UpdateDemoRenderingContext();
}

void
TexturePreventSeamToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aButton == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  vtkDataSetToDataSetFilter* filter;

  if (!(filter = vtkSurfacePropertiesUI::FindTextureCoordsGenerator(demoActor)))
    {
    vtkGenericWarningMacro(<< "TexturePreventSeamToggleCb() couldn't"
                           << " find upstream texture coord. generator.");
    return;
    }

  vtkTextureMapToCylinder* mapToCylinder;
  vtkTextureMapToSphere*   mapToSphere;

  if (mapToCylinder=vtkTextureMapToCylinder::SafeDownCast(filter))
    {
    mapToCylinder->SetPreventSeam(int(aButton->value()));
    }
  else if (mapToSphere=vtkTextureMapToSphere::SafeDownCast(filter))
    {
    mapToSphere->SetPreventSeam(int(aButton->value()));
    }

  GUI->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
TextureTransformToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aButton == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  vtkDataSetToDataSetFilter* filter;
  vtkTransformTextureCoords* texTx = 0;

  if (!(filter = vtkSurfacePropertiesUI::FindTextureCoordsGenerator(demoActor,
                                                                    &texTx)))
    {
    if (aButton->value())
      {
      vtkTextureMapToCylinder* mapToCylinder;
      vtkTextureMapToSphere*   mapToSphere;
      vtkTextureMapToPlane*    mapToPlane;

      switch (GUI->mTextureMappingMenu->value())
        {
        case 1:
          filter = mapToCylinder = vtkTextureMapToCylinder::New();
          mapToCylinder->AutomaticCylinderGenerationOn();
          mapToCylinder->
            SetPreventSeam(int(GUI->mTexturePreventSeamToggle->value()));
          break;
        case 2:
          filter = mapToSphere = vtkTextureMapToSphere::New();
          mapToSphere->AutomaticSphereGenerationOn();
          mapToSphere->
            SetPreventSeam(int(GUI->mTexturePreventSeamToggle->value()));
          break;
        case 0:
        default:
          filter = mapToPlane = vtkTextureMapToPlane::New();
          mapToPlane->AutomaticPlaneGenerationOn();
          break;
        } // switch (MappingType)
      
      if (texTx != NULL)
        {
        filter->SetInput(texTx->GetInput());
        texTx->SetInput(filter->GetOutput());
        }
      else
        {
	vtkMapper*         mapper = demoActor->GetMapper();
	vtkDataSetMapper*  dataSetMapper;
	vtkPolyDataMapper* polyDataMapper;

	filter->SetInput(mapper->GetInput());

        texTx = vtkTransformTextureCoords::New();
        texTx->SetInput(filter->GetOutput());

	if (polyDataMapper = vtkPolyDataMapper::SafeDownCast(mapper))
          {
	  polyDataMapper->SetInput(texTx->GetPolyDataOutput());
          }
	else if (dataSetMapper = vtkDataSetMapper::SafeDownCast(mapper))
          {
	  dataSetMapper->SetInput(texTx->GetOutput());
          }

        texTx->Delete();
        }
      }
    }

  if ((aButton->value() == 0) && (texTx != NULL))
    {
    int        nconsumers  = texTx->GetOutput()->GetNumberOfConsumers();
    vtkSource* inputSource = texTx->GetInput()->GetSource();
    vtkObject* consumer;

    vtkDataSetToDataSetFilter* dataSetToDataSetFilter;
    vtkDataSetToImageFilter* dataSetToImageFilter;
    vtkImageSource* imageSource;
    vtkImageMultipleInputFilter* imageMultipleInputFilter;
    vtkImageToImageFilter* imageToImageFilter;
    vtkImageStencilSource* imageStencilSource;
    vtkImageToImageStencil* imageToImageStencil;
    vtkPolyDataToImageStencil* polyDataToImageStencil;
    vtkPointSetToPointSetFilter* pointSetToPointSetFilter;
    vtkPolyDataSource* polyDataSource;
    vtkDataSetToPolyDataFilter* dataSetToPolyDataFilter;
    vtkPolyDataToPolyDataFilter* polyDataToPolyDataFilter;
    vtkRectilinearGridToPolyDataFilter* rectilinearGridToPolyDataFilter;
    vtkStructuredGridToPolyDataFilter* structuredGridToPolyDataFilter;
    vtkStructuredPointsToPolyDataFilter* structuredPointsToPolyDataFilter;
    vtkUnstructuredGridToPolyDataFilter* unstructuredGridToPolyDataFilter;
    vtkStructuredPointsSource* structuredPointsSource;
    vtkDataSetToStructuredPointsFilter* dataSetToStructuredPointsFilter;
    vtkStructuredPointsToStructuredPointsFilter*
      structuredPointsToStructuredPointsFilter;
    vtkUnstructuredGridSource* unstructuredGridSource;
    vtkDataSetToUnstructuredGridFilter* dataSetToUnstructuredGridFilter;
    vtkStructuredPointsToUnstructuredGridFilter*
      structuredPointsToUnstructuredGridFilter;
    vtkMapper* mapper;
    vtkDataSetMapper*  dataSetMapper;
    vtkPolyDataMapper* polyDataMapper;

    texTx->DebugOn();

    for (int n=0; n<nconsumers; n++)
      {
      consumer = texTx->GetOutput()->GetConsumer(n);

      if ( dataSetToDataSetFilter =
           vtkDataSetToDataSetFilter::SafeDownCast(consumer) )
        {
        dataSetToDataSetFilter->SetInput(texTx->GetInput());
        }
      else if ( dataSetToImageFilter =
                vtkDataSetToImageFilter::SafeDownCast(consumer) )
        {
        dataSetToImageFilter->SetInput(texTx->GetInput());
        }
      else if ( unstructuredGridSource =
                vtkUnstructuredGridSource::SafeDownCast(consumer) )
        {
        if ( dataSetToUnstructuredGridFilter =
             vtkDataSetToUnstructuredGridFilter::
             SafeDownCast(unstructuredGridSource) )
          {
          dataSetToUnstructuredGridFilter->SetInput(texTx->GetInput());
          }
        else if ( structuredPointsToUnstructuredGridFilter =
                  vtkStructuredPointsToUnstructuredGridFilter::
                  SafeDownCast(unstructuredGridSource) )
          {
          vtkImageData* imageData;

          if (imageData = vtkImageData::SafeDownCast(texTx->GetInput()))
            {
            structuredPointsToUnstructuredGridFilter->SetInput(imageData);
            }
          }
        }
      else if ( structuredPointsSource =
                vtkStructuredPointsSource::SafeDownCast(consumer) )
        {
        if ( dataSetToStructuredPointsFilter =
             vtkDataSetToStructuredPointsFilter::
             SafeDownCast(structuredPointsSource))
          {
          dataSetToStructuredPointsFilter->SetInput(texTx->GetInput());
          }
        else if ( structuredPointsToStructuredPointsFilter =
                  vtkStructuredPointsToStructuredPointsFilter::
                  SafeDownCast(structuredPointsSource))
          {
          vtkStructuredPoints* structuredPoints;

          if ( structuredPoints =
               vtkStructuredPoints::SafeDownCast(texTx->GetInput()) )
            {
            structuredPointsToStructuredPointsFilter->
              SetInput(structuredPoints);
            }
          }
        }
      else if (polyDataSource = vtkPolyDataSource::SafeDownCast(consumer))
        {
        if ( dataSetToPolyDataFilter =
             vtkDataSetToPolyDataFilter::SafeDownCast(polyDataSource) )
          {
          dataSetToPolyDataFilter->SetInput(texTx->GetInput());
          }
        else if ( polyDataToPolyDataFilter =
                  vtkPolyDataToPolyDataFilter::
                  SafeDownCast(polyDataSource) )
          {
          vtkPolyData* polyData;

          if (polyData = vtkPolyData::SafeDownCast(texTx->GetInput()))
            {
            polyDataToPolyDataFilter->SetInput(polyData);
            }
          }
        else if ( rectilinearGridToPolyDataFilter =
                  vtkRectilinearGridToPolyDataFilter::
                  SafeDownCast(polyDataSource) )
          {
          vtkRectilinearGrid* rectilinearGrid;

          if ( rectilinearGrid =
               vtkRectilinearGrid::SafeDownCast(texTx->GetInput()) )
            {
            rectilinearGridToPolyDataFilter->SetInput(rectilinearGrid);
            }
          }
        else if ( structuredGridToPolyDataFilter =
                  vtkStructuredGridToPolyDataFilter::
                  SafeDownCast(polyDataSource) )
          {
          vtkStructuredGrid* structuredGrid;

          if ( structuredGrid =
               vtkStructuredGrid::SafeDownCast(texTx->GetInput()) )
            {
            structuredGridToPolyDataFilter->SetInput(structuredGrid);
            }
          }
        else if ( structuredPointsToPolyDataFilter =
                  vtkStructuredPointsToPolyDataFilter::
                  SafeDownCast(polyDataSource) )
          {
          vtkStructuredPoints* structuredPoints;

          if ( structuredPoints =
               vtkStructuredPoints::SafeDownCast(texTx->GetInput()) )
            {
            structuredPointsToPolyDataFilter->SetInput(structuredPoints);
            }
          }
        else if ( unstructuredGridToPolyDataFilter =
                  vtkUnstructuredGridToPolyDataFilter::
                  SafeDownCast(polyDataSource) )
          {
          vtkUnstructuredGrid* unstructuredGrid;

          if ( unstructuredGrid =
               vtkUnstructuredGrid::SafeDownCast(texTx->GetInput()) )
            {
            unstructuredGridToPolyDataFilter->SetInput(unstructuredGrid);
            }
          }
        }
      else if (imageSource = vtkImageSource::SafeDownCast(consumer))
        {
        vtkImageData* imageDataInput;

        if (imageDataInput = vtkImageData::SafeDownCast(texTx->GetInput()))
          {
          if ( imageMultipleInputFilter =
               vtkImageMultipleInputFilter::SafeDownCast(imageSource) )
            {
            inputSource->Register(0);
            imageMultipleInputFilter->
              RemoveInput(texTx->GetStructuredPointsOutput());
            imageMultipleInputFilter->AddInput(imageDataInput);
            inputSource->Delete();
            }
          else if ( imageToImageFilter =
                    vtkImageToImageFilter::SafeDownCast(imageSource) )
            {
            imageToImageFilter->SetInput(imageDataInput);
            }
          }

        }
      else if ( imageStencilSource =
                vtkImageStencilSource::SafeDownCast(consumer) )
        {
        vtkImageData* imageDataInput;

        if (imageDataInput = vtkImageData::SafeDownCast(texTx->GetInput()))
          {
          if ( imageToImageStencil =
               vtkImageToImageStencil::SafeDownCast(imageStencilSource) )
            {
              
            }
          }
        }
      else if ( polyDataToImageStencil =
                vtkPolyDataToImageStencil::SafeDownCast(consumer) )
        {
        vtkPolyData* polyDataInput;

        if (polyDataInput = vtkPolyData::SafeDownCast(texTx->GetInput()))
          {
          polyDataToImageStencil->SetInput(polyDataInput);
          }
        }
      else if (pointSetToPointSetFilter =
               vtkPointSetToPointSetFilter::SafeDownCast(consumer))
        {
        vtkPointSet* pointSet;

        if (pointSet = vtkPointSet::SafeDownCast(texTx->GetInput()))
          {
          pointSetToPointSetFilter->SetInput(pointSet);
          }
        }
      else if (dataSetMapper = vtkDataSetMapper::SafeDownCast(consumer))
        {
        dataSetMapper->SetInput(texTx->GetInput());
        }
      else if (polyDataMapper = vtkPolyDataMapper::SafeDownCast(consumer))
        {
        polyDataMapper->
          SetInput(vtkPolyData::SafeDownCast(texTx->GetInput()));
        }

      } // for each consumer

    }

  GUI->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
TextureOriginXCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aInput == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TextureOriginXCb() not implemented");
}

void
TextureOriginYCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aInput == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TextureOriginYCb() not implemented");
}

void
TextureOriginZCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aInput == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TextureOriginZCb() not implemented");
}

void
TexturePositionXCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aInput == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TexturePositionXCb() not implemented");
}

void
TexturePositionYCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aInput == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TexturePositionYCb() not implemented");
}

void
TexturePositionZCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aInput == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TexturePositionZCb() not implemented");
}

void
TextureScaleXCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aInput == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TextureScaleXCb() not implemented");
}

void
TextureScaleYCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aInput == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TextureScaleYCb() not implemented");
}

void
TextureScaleZCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aInput == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TextureScaleZCb() not implemented");
}

void
TextureFlipRToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aButton == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TextureFlipRToggleCb() not implemented");
}

void
TextureFlipSToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aButton == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TextureFlipSToggleCb() not implemented");
}

void
TextureFlipTToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkSurfacePropertiesUI* GUI;
  vtkActor*               demoActor;

  if (aButton == NULL)
    return;
  if ((GUI = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((demoActor = GUI->GetDemoActor()) == NULL)
    return;

  Fl::warning("TextureFlipTToggleCb() not implemented");
}

/* 
 * End of: $Id: vtkSurfacePropertiesTextureCb.cxx,v 1.1.1.1 2006/12/19 22:59:50 christianh Exp $.
 * 
 */
