/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkViewportUIImpl.cxx,v 1.1.1.1 2006/12/19 22:59:52 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkFrustumCoverageCuller.h"

void
vtkViewportUI::Check (void)
{
  Fl::check();
}

void
vtkViewportUI::GetSortingStyle (int& a)
{
  switch (this->mCullerSortingMenu->value())
    {
    case 1:
      a = VTK_CULLER_SORT_BACK_TO_FRONT; break;
    case 2:
      a = VTK_CULLER_SORT_FRONT_TO_BACK; break;
    case 0:
    default:
      a = VTK_CULLER_SORT_NONE;          break;
    }
}

void
vtkViewportUI::SetSortingStyle (int a)
{
  switch (a)
    {
    case VTK_CULLER_SORT_BACK_TO_FRONT:
      this->mCullerSortingMenu->value(1); break;
    case VTK_CULLER_SORT_FRONT_TO_BACK:
      this->mCullerSortingMenu->value(2); break;
    case VTK_CULLER_SORT_NONE:
    default:
      this->mCullerSortingMenu->value(0); break;
    }
}

void
vtkViewportUI::GetViewport (float a[4])
{
  a[0] = this->mExtentX0->value();
  a[1] = this->mExtentY0->value();
  a[2] = this->mExtentX1->value();
  a[3] = this->mExtentY1->value();
}

void
vtkViewportUI::SetViewport (float a[4])
{
  this->mExtentX0->value(a[0]);
  this->mExtentY0->value(a[1]);
  this->mExtentX1->value(a[2]);
  this->mExtentY1->value(a[3]);
}

void
vtkViewportUI::GetTwoSidedLighting (int& a)
{ a = this->mTwoSidedLightingToggle->value(); }

void
vtkViewportUI::SetTwoSidedLighting (int a)
{ this->mTwoSidedLightingToggle->value(a); }

void
vtkViewportUI::GetLightFollowCamera (int& a)
{ a = this->mLightFollowsCameraToggle->value(); }

void
vtkViewportUI::SetLightFollowCamera (int a)
{ this->mLightFollowsCameraToggle->value(a); }

void
vtkViewportUI::GetBackingStore (int& a)
{ a = this->mBackingStoreToggle->value(); }

void
vtkViewportUI::SetBackingStore (int a)
{ this->mBackingStoreToggle->value(a); }

void
vtkViewportUI::GetPointSmoothing (int& a)
{ a = this->mPointSmoothingToggle->value(); }

void
vtkViewportUI::SetPointSmoothing (int a)
{ this->mPointSmoothingToggle->value(a); }

void
vtkViewportUI::GetLineSmoothing (int& a)
{ a = this->mLineSmoothingToggle->value(); }

void
vtkViewportUI::SetLineSmoothing (int a)
{ this->mLineSmoothingToggle->value(a); }

void
vtkViewportUI::GetPolygonSmoothing (int& a)
{ a = this->mPolygonSmoothingToggle->value(); }

void
vtkViewportUI::SetPolygonSmoothing (int a)
{ this->mPolygonSmoothingToggle->value(a); }

void
vtkViewportUI::GetDesiredUpdateRate (float& a)
{ a = this->mDesiredUpdateRate->value(); }

void
vtkViewportUI::SetDesiredUpdateRate (float a)
{
  this->mDesiredUpdateRate->value(a);
  this->mDesiredUpdateRateAdjuster->value(a);
}

void
vtkViewportUI::GetStillUpdateRate (float& a)
{ a = this->mStillUpdateRate->value(); }

void
vtkViewportUI::SetStillUpdateRate (float a)
{
  this->mStillUpdateRate->value(a);
  this->mStillUpdateRateAdjuster->value(a);
}

/*
 * End of: $Id: vtkViewportUIImpl.cxx,v 1.1.1.1 2006/12/19 22:59:52 christianh Exp $.
 *
 */
