/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * $Id: vtkWidgets.h,v 1.1.1.1 2006/12/19 22:59:52 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_WIDGETS_H_
#  define VTK_WIDGETS_H_
#  include "svvMacros.h"
#  include "vtkRenderingContextFwd.h"
#  include "vtkObject.h"

class Fl_VTK_View;
class vtkViewUI;
class vtkToolBarUI;
class vtkNodeBrowserUI;
class vtkLightingUI;
class vtkViewportUI;
class vtkCameraUI;
class vtkSurfacePropertiesUI;
class vtkMatrix4x4UI;

/** \class   vtkWidgets
 *  \brief   Container for the main application interface widgets.
 * 
 * vtkWidgets is a ...
 * 
 * \author  $Author: christianh $
 * \version $Revision: 1.1.1.1 $
 * \date    $Date: 2006/12/19 22:59:52 $
 * 
 * \sa
 * vtkObject
 */
class SVV_EXPORT vtkWidgets : public vtkObject
{
public:
  /** Return pointer to the singleton instance. */
  static vtkWidgets* New (void);

  /*@{*/
  /** The vtkObject subclass methods. */
  vtkTypeRevisionMacro (vtkWidgets, vtkObject);
  /*@}*/

  /** Invoked by print to print information about object including superclasses.
   * Typically not called by the user (use Print() instead), but used in the 
   * hierarchical print process to combine the output of several classes.
   */
  void PrintSelf (ostream&, vtkIndent);

  /*@{*/
  /** The instance owns itself and may not be registered by other objects. */
  void Register (vtkObjectBase*) {}
  void UnRegister (vtkObjectBase*) {}
  /*@}*/

  /** Get the tool bar widget. */
  vtkViewUI*                    GetViewUI (void);

  /** Get the toggle tree widget. */
  vtkToolBarUI*                 GetToolBarUI (void);

  /** Get the toggle tree widget. */
  vtkNodeBrowserUI*             GetNodeBrowserUI (void);

  /** Get the lighting widget. */
  vtkLightingUI*                GetLightingUI (void);

  /** Get the viewport widget. */
  vtkViewportUI*                GetViewportUI (void);

  /** Get the camera widget. */
  vtkCameraUI*                  GetCameraUI (void);

  /** Get the surface properties widget. */
  vtkSurfacePropertiesUI*       GetSurfacePropertiesUI (void);

  /** Get the transformation matrix widget. */
  vtkMatrix4x4UI*               GetMatrix4x4UI (void);

  /** Get the View associated with the ViewUI. */
  Fl_VTK_View*                  GetView (void);

  /** Get the RenderingContext associated with the View of the ViewUI. */
  VTK_EXTENSIONS_NAMESPACE_QUALIFIER vtkRenderingContext*
  GetRenderingContext (void);

  /** Get the RenderingContext associated with the View of the ViewUI. */
  VTK_EXTENSIONS_NAMESPACE_QUALIFIER vtkRenderingContext*
  GetCurrentRenderingContext (void);

protected:
  vtkWidgets (void);
  ~vtkWidgets();

  static void   ClassInitialize (void);
  static void   ClassFinalize (void);

#if 0
  /** Set the view widget. */
  void  SetViewUI (vtkViewUI*);

  /** Set the tool bar widget. */
  void  SetToolBarUI (vtkToolBarUI*);

  /** Set the toggle tree widget. */
  void  SetNodeBrowserUI (vtkNodeBrowserUI*);

  /** Set the lighting widget. */
  void  SetLightingUI (vtkLightingUI*);

  /** Set the viewport widget. */
  void  SetViewportUI (vtkViewportUI*);

  /** Set the camera widget. */
  void  SetCameraUI (vtkCameraUI*);

  /** Set the surface properties widget. */
  void  SetSurfacePropertiesUI (vtkSurfacePropertiesUI*);

  /** Set the transformation matrix widget. */
  void  SetMatrix4x4UI (vtkMatrix4x4UI*);
#endif /* 0 */

  vtkViewUI*                    ViewUI;
  vtkToolBarUI*                 ToolBarUI;
  vtkNodeBrowserUI*             NodeBrowserUI;
  vtkLightingUI*                LightingUI;
  vtkViewportUI*                ViewportUI;
  vtkCameraUI*                  CameraUI;
  vtkSurfacePropertiesUI*       SurfacePropertiesUI;
  vtkMatrix4x4UI*               Matrix4x4UI;

public:
  /** \internal
   * Nested initializer class.
   * The static initializer object is declared below.
   */
  class Init
  {
  public:
    Init (void);
    ~Init();
  private:
    static long s_translation_units_;
    friend class vtkWidgets;
  };

  friend class Init;

private:
  /*@{*/
  /** \internal
   * Invalidate the copy constructor and assignment operator.
   */
  vtkWidgets (const vtkWidgets&); // Not implemented.
  void operator= (const vtkWidgets&); // Not implemented.
  /*@}*/
};

#  ifndef VTK_WIDGETS_INITIALIZED_
#    define VTK_WIDGETS_INITIALIZED_
/** \internal
 * Global initializer object, to ensure construction of static objects.
 */
static vtkWidgets::Init vtkWidgetsInitInstance;
#  endif /* VTK_WIDGETS_INITIALIZED_ */

/** Singleton instance reference. */
extern vtkWidgets& widgets;

#endif /* VTK_WIDGETS_H_ */
/* 
 * End of: $Id: vtkWidgets.h,v 1.1.1.1 2006/12/19 22:59:52 christianh Exp $.
 * 
 */
