/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: indent_stream.h,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $
 * 
 */
#ifndef _INDENT_STREAM_H_
#  define _INDENT_STREAM_H_
#  include <iostream>

class indent_stream
{
  int indent_;

public:
  static const int max = 72;

  /** Default constructor. */
  indent_stream(void) : indent_(0) { }

  /*@{*/
  /** Copy constructor and assignment operator. */
  indent_stream(const indent_stream& o) : indent_(o.indent_) { }
  indent_stream& operator=(const indent_stream& o)
    { this->indent_ = o.indent_; return *this; }
  /*@}*/

  /*@{*/
  /** Pseudo-copy constructor and assignment operator. */
  indent_stream(int n) : indent_(n<0 ? 0 : (n>max ? max : n)) { }
  indent_stream& operator=(int n)
    { this->indent_ = (n<0 ? 0 : (n>max ? max : n)); return *this; }
  /*@}*/
  
  /*@{*/
  /** Increment / decrement the indentation level. */
  indent_stream& operator+=(int n)
    {if((max-n)>=this->indent_) this->indent_ += n; else this->indent_ = max;}
  indent_stream& operator-=(int n)
    {if(n<=this->indent_) this->indent_ -= n; else this->indent_ = 0;}
  /*@}*/
  
  /** Print out the indentation. Basically output a bunch of spaces. */
  friend std::ostream& operator<<(std::ostream&, indent_stream&);
};

#endif /* _INDENT_STREAM_H_ */
/* 
 * End of: $Id: indent_stream.h,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $.
 * 
 */
