/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: session_header_types.h,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $
 * 
 */
#ifndef _SESSION_HEADER_TYPES_H_
#  define _SESSION_HEADER_TYPES_H_

#  include <string>
#  include <list>

struct AuthorRec
{
  std::string   Author;
  int           Id;
  std::string   Signature;
  enum eSignatureType
  { eNoneSignature = 0x0, eDSASignature, eRSASignature, } SignatureType;
  
  AuthorRec(const std::string& author = "",
            int                id     = -1,
            const std::string& sign   = "",
            eSignatureType     type   = eNoneSignature) :
    Author(author), Id(id), Signature(sign), SignatureType(type) { }
};

typedef std::list<AuthorRec> AuthorList;

struct HeaderRec
{
  std::string Base;
  std::string Link;
  std::string Meta;
  std::string Title;
  std::string Description;
  AuthorList  Authors;
};

#endif /* _SESSION_HEADER_TYPES_H_ */
/* 
 * End of: $Id: session_header_types.h,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $.
 * 
 */
