/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svSimpleSessionImporter.cxx,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
// vtkExtensions
#include "svSimpleSessionImporter.h"
#include "vtkXMLString.h"
// VTK Common
#include "vtkObjectFactory.h"

VTK_EXTENSIONS_NAMESPACE_USE

// ----------------------------------------------------------------------------
//      v t k E x p a t E x a m p l e
// ----------------------------------------------------------------------------

vtkCxxRevisionMacro(svSimpleSessionImporter, "$Revision: 1.1.1.1 $");
vtkStandardNewMacro(svSimpleSessionImporter);

// ----------------------------------------------------------------------------

static const XML_Char* gSessionTag =
{ ASCII_latin_s, ASCII_latin_e, ASCII_latin_s, ASCII_latin_s, ASCII_latin_i,
  ASCII_latin_o, ASCII_latin_n, ASCII_NUL };

static const XML_Char* gHeaderTag =
{ ASCII_latin_h, ASCII_latin_e, ASCII_latin_a, ASCII_latin_d, ASCII_latin_e,
  ASCII_latin_r, ASCII_NUL };

static const XML_Char* gTitleTag =
{ ASCII_latin_t, ASCII_latin_i, ASCII_latin_t, ASCII_latin_l, ASCII_latin_e,
  ASCII_NUL };

static const XML_Char* gDescriptionTag =
{ ASCII_latin_d, ASCII_latin_e, ASCII_latin_s, ASCII_latin_c, ASCII_latin_r,
  ASCII_latin_i, ASCII_latin_p, ASCII_latin_t, ASCII_latin_i, ASCII_latin_o,
  ASCII_latin_n, ASCII_NUL };

static const XML_Char* gAuthorTag =
{ ASCII_latin_a, ASCII_latin_u, ASCII_latin_t, ASCII_latin_h, ASCII_latin_o,
  ASCII_latin_r, ASCII_NUL };

static const XML_Char* gMetaTag =
{ ASCII_latin_m, ASCII_latin_e, ASCII_latin_t, ASCII_latin_a, ASCII_NUL };

static const XML_Char* gLinkTag =
{ ASCII_latin_l, ASCII_latin_i, ASCII_latin_n, ASCII_latin_k, ASCII_NUL };

static const XML_Char* gPaletteTag =
{ ASCII_latin_p, ASCII_latin_a, ASCII_latin_l, ASCII_latin_e, ASCII_latin_t,
  ASCII_latin_t, ASCII_latin_e, ASCII_NUL };

static const XML_Char* gColorTag =
{ ASCII_latin_c, ASCII_latin_o, ASCII_latin_l, ASCII_latin_o, ASCII_latin_r,
  ASCII_NUL };

static const XML_Char* gMaterialTag =
{ ASCII_latin_m, ASCII_latin_a, ASCII_latin_t, ASCII_latin_e, ASCII_latin_r,
  ASCII_latin_i, ASCII_latin_a, ASCII_latin_l, ASCII_NUL };

static const XML_Char* gAmbientTag =
{ ASCII_latin_a, ASCII_latin_m, ASCII_latin_b, ASCII_latin_i, ASCII_latin_e,
  ASCII_latin_n, ASCII_latin_t, ASCII_NUL };

static const XML_Char* gDiffuseTag =
{ ASCII_latin_d, ASCII_latin_i, ASCII_latin_f, ASCII_latin_f, ASCII_latin_u,
  ASCII_latin_s, ASCII_latin_e, ASCII_NUL };

static const XML_Char* gSpecularTag =
{ ASCII_latin_s, ASCII_latin_p, ASCII_latin_e, ASCII_latin_c, ASCII_latin_u,
  ASCII_latin_l, ASCII_latin_a, ASCII_latin_r, ASCII_NUL };

static const XML_Char* gIdAttr =
{ ASCII_latin_i, ASCII_latin_d, ASCII_NUL };

static const XML_Char* gVersionAttr =
{ ASCII_latin_v, ASCII_latin_e, ASCII_latin_r, ASCII_latin_s, ASCII_latin_i,
  ASCII_latin_o, ASCII_latin_n, ASCII_NUL };

static const XML_Char* gSpaceAttr =
{ ASCII_latin_s, ASCII_latin_p, ASCII_latin_a, ASCII_latin_c, ASCII_latin_e,
  ASCII_NUL };

static const XML_Char* gLangAttr =
{ ASCII_latin_l, ASCII_latin_a, ASCII_latin_n, ASCII_latin_g, ASCII_NUL };

static const XML_Char* gBaseAttr =
{ ASCII_latin_b, ASCII_latin_a, ASCII_latin_s, ASCII_latin_e, ASCII_NUL };

static const XML_Char* gCreatedAttr =
{ ASCII_latin_c, ASCII_latin_r, ASCII_latin_e, ASCII_latin_a, ASCII_latin_t,
  ASCII_latin_e, ASCII_latin_d, ASCII_NUL };

static const XML_Char* gModifiedAttr =
{ ASCII_latin_m, ASCII_latin_o, ASCII_latin_d, ASCII_latin_i, ASCII_latin_f,
  ASCII_latin_i, ASCII_latin_e, ASCII_latin_d, ASCII_NUL };

static const XML_Char* gUsernameAttr =
{ ASCII_latin_u, ASCII_latin_s, ASCII_latin_e, ASCII_latin_r, ASCII_latin_n,
  ASCII_latin_a, ASCII_latin_m, ASCII_latin_e, ASCII_NUL };

static const XML_Char* gPasswordAttr =
{ ASCII_latin_p, ASCII_latin_a, ASCII_latin_s, ASCII_latin_s, ASCII_latin_w,
  ASCII_latin_o, ASCII_latin_r, ASCII_latin_d, ASCII_NUL };

static const XML_Char* gUidAttr =
{ ASCII_latin_u, ASCII_latin_i, ASCII_latin_d, ASCII_NUL };

static const XML_Char* gGidAttr =
{ ASCII_latin_g, ASCII_latin_i, ASCII_latin_d, ASCII_NUL };

static const XML_Char* gGecosAttr =
{ ASCII_latin_g, ASCII_latin_e, ASCII_latin_c, ASCII_latin_o, ASCII_latin_s,
  ASCII_NUL };

static const XML_Char* gHomeAttr =
{ ASCII_latin_h, ASCII_latin_o, ASCII_latin_m, ASCII_latin_e, ASCII_NUL };

static const XML_Char* gShellAttr =
{ ASCII_latin_s, ASCII_latin_h, ASCII_latin_e, ASCII_latin_l, ASCII_latin_l,
  ASCII_NUL };

static const XML_Char* gPropertyAttr =
{ ASCII_latin_p, ASCII_latin_r, ASCII_latin_o, ASCII_latin_p, ASCII_latin_e,
  ASCII_latin_r, ASCII_latin_t, ASCII_latin_y, ASCII_NUL };

static const XML_Char* gValueAttr =
{ ASCII_latin_v, ASCII_latin_a, ASCII_latin_l, ASCII_latin_u, ASCII_latin_e,
  ASCII_NUL };

static const XML_Char* gProfileAttr =
{ ASCII_latin_p, ASCII_latin_r, ASCII_latin_o, ASCII_latin_f, ASCII_latin_i,
  ASCII_latin_l, ASCII_latin_e, ASCII_NUL };

static const XML_Char* gSchemeAttr =
{ ASCII_latin_s, ASCII_latin_c, ASCII_latin_h, ASCII_latin_e, ASCII_latin_m,
  ASCII_latin_e, ASCII_NUL };

static const XML_Char* gTypeAttr =
{ ASCII_latin_t, ASCII_latin_y, ASCII_latin_p, ASCII_latin_e, ASCII_NUL };

static const XML_Char* gHrefAttr =
{ ASCII_latin_h, ASCII_latin_r, ASCII_latin_e, ASCII_latin_f, ASCII_NUL };

static const XML_Char* gRoleAttr =
{ ASCII_latin_r, ASCII_latin_o, ASCII_latin_l, ASCII_latin_e, ASCII_NUL };

static const XML_Char* gShowAttr =
{ ASCII_latin_s, ASCII_latin_h, ASCII_latin_o, ASCII_latin_w, ASCII_NUL };

static const XML_Char* gArcroleAttr =
{ ASCII_latin_a, ASCII_latin_r, ASCII_latin_c, ASCII_latin_r, ASCII_latin_o,
  ASCII_latin_l, ASCII_latin_e, ASCII_NUL };

static const XML_Char* gActuateAttr =
{ ASCII_latin_a, ASCII_latin_c, ASCII_latin_t, ASCII_latin_u, ASCII_latin_a,
  ASCII_latin_t, ASCII_latin_e, ASCII_NUL };

static const XML_Char* gXrefAttr =
{ ASCII_latin_x, ASCII_latin_r, ASCII_latin_e, ASCII_latin_f, ASCII_NUL };

static const XML_Char* gOpacityAttr =
{ ASCII_latin_o, ASCII_latin_p, ASCII_latin_a, ASCII_latin_c, ASCII_latin_i,
  ASCII_latin_t, ASCII_latin_y, ASCII_NUL };

static const XML_Char* gShininessAttr =
{ ASCII_latin_s, ASCII_latin_h, ASCII_latin_i, ASCII_latin_n, ASCII_latin_i,
  ASCII_latin_n, ASCII_latin_e, ASCII_latin_s, ASCII_latin_s, ASCII_NUL };

// ----------------------------------------------------------------------------
svSimpleSessionImporter::svSimpleSessionImporter(bool aCreateParser)
{
  svSimpleSessionImporter::CheckFeatures();
}

// ----------------------------------------------------------------------------
svSimpleSessionImporter::~svSimpleSessionImporter(void)
{
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::ResetHandlers(void)
{
  if (this->parser_ == NULL)
    {
    vtkErrorMacro(<< "ResetHandlers() called with NULL parser instance.");
    return;
    }

  this->XML_SetReturnNSTriplet(XML_TRUE);
  // 
  // Set the expat library handler callbacks to the static methods.
  // 

  ::XML_SetElementDeclHandler( this->parser_,
                               svSimpleSessionImporter::ElementDeclCb );

  ::XML_SetAttlistDeclHandler( this->parser_,
                               svSimpleSessionImporter::AttlistDeclCb );

  ::XML_SetXmlDeclHandler( this->parser_, svSimpleSessionImporter::XmlDeclCb );

  ::XML_SetEntityDeclHandler( this->parser_,
                              svSimpleSessionImporter::EntityDeclCb );

  ::XML_SetElementHandler( this->parser_,
                           svSimpleSessionImporter::StartElementCb,
                           svSimpleSessionImporter::EndElementCb );

  ::XML_SetCharacterDataHandler( this->parser_,
                                 svSimpleSessionImporter::CharacterDataCb );

  ::XML_SetProcessingInstructionHandler( this->parser_,
                                         svSimpleSessionImporter::
                                         ProcessingInstructionCb );

  ::XML_SetCommentHandler( this->parser_, svSimpleSessionImporter::CommentCb );

  ::XML_SetCdataSectionHandler( this->parser_,
                                svSimpleSessionImporter::StartCdataSectionCb,
                                svSimpleSessionImporter::EndCdataSectionCb );

#if 0
  ::XML_SetDefaultHandler( this->parser_, svSimpleSessionImporter::DefaultCb );
#else
  ::XML_SetDefaultHandlerExpand( this->parser_,
                                 svSimpleSessionImporter::DefaultCb );
#endif /* 0 */

  ::XML_SetDoctypeDeclHandler( this->parser_,
                               svSimpleSessionImporter::StartDoctypeDeclCb,
                               svSimpleSessionImporter::EndDoctypeDeclCb );

#if 1
  ::XML_SetUnparsedEntityDeclHandler( this->parser_,
                                      svSimpleSessionImporter::
                                      UnparsedEntityDeclCb );
#endif /* 0 */

  ::XML_SetNotationDeclHandler( this->parser_,
                                svSimpleSessionImporter::NotationDeclCb );

  ::XML_SetNamespaceDeclHandler( this->parser_,
                                 svSimpleSessionImporter::StartNamespaceDeclCb,
                                 svSimpleSessionImporter::EndNamespaceDeclCb );

  ::XML_SetNotStandaloneHandler( this->parser_,
                                 svSimpleSessionImporter::NotStandaloneCb );

#if 1
  ::XML_SetExternalEntityRefHandler( this->parser_,
                                     svSimpleSessionImporter::
                                     ExternalEntityRefCb );
#else
  ::XML_SetExternalEntityRefHandler( this->parser_,
                                     svSimpleSessionImporter::
                                     ExternalEntityRefCb );
  // If a non-NULL value for arg is specified here, then it will be
  // passed as the first argument to the external entity ref handler
  // instead of the parser object.
  ::XML_SetExternalEntityRefHandlerArg( this->parser_, this );
#endif /* 0 */

  ::XML_SetSkippedEntityHandler( this->parser_,
                                 svSimpleSessionImporter::SkippedEntityCb );

  ::XML_SetUnknownEncodingHandler( this->parser_,
                                   svSimpleSessionImporter::UnknownEncodingCb,
                                   this->encodingDataPtr_ );
}

// ----------------------------------------------------------------------------
// Expat callback methods
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
void 
svSimpleSessionImporter::StartElement(const XML_Char* aElem,
                                      const XML_Char** aAttrs)
{
  if (vtkXMLString::Equals(aElem,gSessionTag))
    {
    }
  else if (vtkXMLString::Equals(aElem,gHeaderTag))
    {
    }
  else if (vtkXMLString::Equals(aElem,gPaletteTag))
    {
    }


  std::cout <<"StartElement( <" << vtkXMLString::ToLatin1(aElem) << ">\n";

  while(*aAttrs)
    {
    std::cout << "\t" << vtkXMLString::ToLatin1(aAttrs[0]) << "\t= \""
              << vtkXMLString::ToLatin1(aAttrs[1]) << "\"" << std::endl;
    aAttrs += 2;
    }

  std::cout << " )" << std::endl;
}

void 
svSimpleSessionImporter::EndElement(const XML_Char* aElem)
{
  std::cout << "EndElement( <" << vtkXMLString::ToLatin1(aElem) << "> )"
            << std::endl;
}

// ----------------------------------------------------------------------------
void 
svSimpleSessionImporter::CharacterData(const XML_Char* aData, int aLen)
{
  if (!this->EmptyCharacterData(aData,aLen))
    {
    XML_Char* data = new XML_Char[aLen + 1];
    
    vtkXMLString::SubString(data,aData,0,aLen);
    
    std::cout << "CharacterData( " << vtkXMLString::ToLatin1(data)
              << ", " << aLen << " )" << std::endl;
    
    delete [] data;
    }
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::ProcessingInstruction(const XML_Char* aTarget,
                                               const XML_Char* aData)
{
  std::cout << "ProcessingInstruction( " << vtkXMLString::ToLatin1(aTarget)
            << ", " << vtkXMLString::ToLatin1(aData) << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::Comment(const XML_Char* aData)
{
  std::cout << "Comment( " << vtkXMLString::ToLatin1(aData) << " )"
            << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::StartCdataSection(void)
{
  std::cout << "StartCdataSection()" << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::EndCdataSection(void)
{
  std::cout << "EndCdataSection()" << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::Default(const XML_Char* aData, int aLen)
{
  if (!this->EmptyCharacterData(aData,aLen))
    {
    XML_Char* data = new XML_Char[aLen + 1];
    
    vtkXMLString::SubString(data,aData,0,aLen);
    
    std::cout << "Default( " << vtkXMLString::ToLatin1(data)
              << ", " << aLen << " )" << std::endl;
    
    delete [] data;
    }
}

// ----------------------------------------------------------------------------
int
svSimpleSessionImporter::ExternalEntityRef(const XML_Char* aContext,
                                           const XML_Char* aBase,
                                           const XML_Char* aSystemId,
                                           const XML_Char* aPublicId)
{
  std::cout << "ExternalEntityRef( " << vtkXMLString::ToLatin1(aContext)
            << ", " << vtkXMLString::ToLatin1(aBase) << ", "
            << vtkXMLString::ToLatin1(aSystemId) << ", "
            << vtkXMLString::ToLatin1(aPublicId) << " ) returning 1"
            << std::endl;

  return 1;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::SkippedEntity(const XML_Char* aName,
                                       int aIsParamEntity)
{
  std::cout << "SkippedEntity( " << vtkXMLString::ToLatin1(aName)
            << ", " << aIsParamEntity << " )" << std::endl;
}

// ----------------------------------------------------------------------------
int
svSimpleSessionImporter::UnknownEncoding(const XML_Char* aName,
                                         XML_Encoding* aInfo)
{
  std::cout << "UnknownEncoding( " << vtkXMLString::ToLatin1(aName)
            << ", " << aInfo << " ) returning 0" << std::endl;

  return 0;
}

// ----------------------------------------------------------------------------
void 
svSimpleSessionImporter::StartNamespaceDecl(const XML_Char* aPrefix,
                                            const XML_Char* aURI)
{
  std::cout << "StartNamespaceDecl( " << vtkXMLString::ToLatin1(aPrefix)
            << ", " << vtkXMLString::ToLatin1(aURI) << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void 
svSimpleSessionImporter::EndNamespaceDecl(const XML_Char* aPrefix)
{
  std::cout << "EndNamespaceDecl( " << vtkXMLString::ToLatin1(aPrefix)
            << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::XmlDecl(const XML_Char* aVersion,
                                 const XML_Char* aEncoding,
                                 int             aStandalone)
{
  std::cout << "XmlDecl( " << vtkXMLString::ToLatin1(aVersion) << ", "
            << vtkXMLString::ToLatin1(aEncoding) << ", "
            << aStandalone << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::StartDoctypeDecl(const XML_Char* aDoctypeName,
                                          const XML_Char* aSystemId,
                                          const XML_Char* aPublicId,
                                          int             aHasInternalSubset)
{
  std::cout << "StartDoctypeDecl( " << vtkXMLString::ToLatin1(aDoctypeName)
            << ", " << vtkXMLString::ToLatin1(aSystemId) << ", "
            << vtkXMLString::ToLatin1(aPublicId) << ", "
            << aHasInternalSubset << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::EndDoctypeDecl(void)
{
  std::cout <<"EndDoctypeDecl()" << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::ElementDecl(const XML_Char* aName, XML_Content* aModel)
{
  std::cout << "ElementDecl( " << vtkXMLString::ToLatin1(aName)
            << ", " << aModel << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::AttlistDecl(const XML_Char* aElemName,
                                     const XML_Char* aAttrName,
                                     const XML_Char* aAttrType,
                                     const XML_Char* aDefault,
                                     int             aIsRequired)
{
  std::cout << "AttlistDecl( " << vtkXMLString::ToLatin1(aElemName)
            << ", " << vtkXMLString::ToLatin1(aAttrName)
            << ", " << vtkXMLString::ToLatin1(aAttrType)
            << ", " << vtkXMLString::ToLatin1(aDefault)
            << ", " << aIsRequired << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::EntityDecl(const XML_Char* aEntityName,
                                    int             aIsParameterEntity,
                                    const XML_Char* aValue,
                                    int             aValueLength,
                                    const XML_Char* aBase,
                                    const XML_Char* aSystemId,
                                    const XML_Char* aPublicId,
                                    const XML_Char* aNotationName)
{
  std::cout << "EntityDecl( " << vtkXMLString::ToLatin1(aEntityName)
            << ", " << aIsParameterEntity
            << ", " << vtkXMLString::ToLatin1(aValue)
            << ", " << aValueLength
            << ", " << vtkXMLString::ToLatin1(aBase)
            << ", " << vtkXMLString::ToLatin1(aSystemId)
            << ", " << vtkXMLString::ToLatin1(aPublicId)
            << ", " << vtkXMLString::ToLatin1(aNotationName) << " )"
            << std::endl;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::NotationDecl(const XML_Char* aNotationName,
                                      const XML_Char* aBase,
                                      const XML_Char* aSystemId,
                                      const XML_Char* aPublicId)
{
  std::cout << "NotationDecl( " << vtkXMLString::ToLatin1(aNotationName)
            << ", " << vtkXMLString::ToLatin1(aBase)
            << ", " << vtkXMLString::ToLatin1(aSystemId)
            << ", " << vtkXMLString::ToLatin1(aPublicId) << " )" << std::endl;
}

// ----------------------------------------------------------------------------
int
svSimpleSessionImporter::NotStandalone(void)
{
  std::cout <<"NotStandalone() returning XML_STATUS_OK." << std::endl;

  return XML_STATUS_OK;
}

// ----------------------------------------------------------------------------
void
svSimpleSessionImporter::PrintSelf(std::ostream& aTarget, vtkIndent aIndent)
{
  this->Superclass::PrintSelf(aTarget,aIndent);
}

/*
 * End of: $Id: svSimpleSessionImporter.cxx,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $.
 * 
 */
