/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkPaletteParser.cxx,v 1.1.1.1 2006/12/19 23:00:08 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
// vtkExtensions
#include "vtkPaletteParser.h"
#include "vtkXMLChar.h"
#include "vtkXMLString.h"
// VTK Common
#include "vtkObjectFactory.h"

VTK_EXTENSIONS_NAMESPACE_USE

// ----------------------------------------------------------------------------
//      v t k P a l e t t e P a r s e r
// ----------------------------------------------------------------------------

vtkCxxRevisionMacro(vtkPaletteParser, "$Revision: 1.1.1.1 $");
vtkStandardNewMacro(vtkPaletteParser);

// ----------------------------------------------------------------------------
vtkPaletteParser::vtkPaletteParser(bool aCreateParser)
{
  vtkPaletteParser::CheckFeatures();
}

// ----------------------------------------------------------------------------
vtkPaletteParser::~vtkPaletteParser(void)
{
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::ResetHandlers(void)
{
  if (this->parser_ == NULL)
    {
    vtkErrorMacro(<< "ResetHandlers() called with NULL parser instance.");
    return;
    }

  this->XML_SetReturnNSTriplet(XML_TRUE);
  // 
  // Set the expat library handler callbacks to the static methods.
  // 

  ::XML_SetElementDeclHandler( this->parser_,
                               vtkPaletteParser::ElementDeclCb );

  ::XML_SetAttlistDeclHandler( this->parser_,
                               vtkPaletteParser::AttlistDeclCb );

  ::XML_SetXmlDeclHandler( this->parser_, vtkPaletteParser::XmlDeclCb );

  ::XML_SetEntityDeclHandler( this->parser_, vtkPaletteParser::EntityDeclCb );

  ::XML_SetElementHandler( this->parser_,
                           vtkPaletteParser::StartElementCb,
                           vtkPaletteParser::EndElementCb );

  ::XML_SetCharacterDataHandler( this->parser_,
                                 vtkPaletteParser::CharacterDataCb );

  ::XML_SetProcessingInstructionHandler( this->parser_,
                                         vtkPaletteParser::
                                         ProcessingInstructionCb );

  ::XML_SetCommentHandler( this->parser_, vtkPaletteParser::CommentCb );

  ::XML_SetCdataSectionHandler( this->parser_,
                                vtkPaletteParser::StartCdataSectionCb,
                                vtkPaletteParser::EndCdataSectionCb );

#if 0
  ::XML_SetDefaultHandler( this->parser_, vtkPaletteParser::DefaultCb );
#else
  ::XML_SetDefaultHandlerExpand( this->parser_, vtkPaletteParser::DefaultCb );
#endif /* 0 */

  ::XML_SetDoctypeDeclHandler( this->parser_,
                               vtkPaletteParser::StartDoctypeDeclCb,
                               vtkPaletteParser::EndDoctypeDeclCb );

#if 1
  ::XML_SetUnparsedEntityDeclHandler( this->parser_,
                                      vtkPaletteParser::UnparsedEntityDeclCb);
#endif /* 0 */

  ::XML_SetNotationDeclHandler( this->parser_,
                                vtkPaletteParser::NotationDeclCb );

  ::XML_SetNamespaceDeclHandler( this->parser_,
                                 vtkPaletteParser::StartNamespaceDeclCb,
                                 vtkPaletteParser::EndNamespaceDeclCb );

  ::XML_SetNotStandaloneHandler( this->parser_,
                                 vtkPaletteParser::NotStandaloneCb );

#if 1
  ::XML_SetExternalEntityRefHandler( this->parser_,
                                     vtkPaletteParser::ExternalEntityRefCb );
#else
  ::XML_SetExternalEntityRefHandler( this->parser_,
                                     vtkPaletteParser::ExternalEntityRefCb );
  // If a non-NULL value for arg is specified here, then it will be
  // passed as the first argument to the external entity ref handler
  // instead of the parser object.
  ::XML_SetExternalEntityRefHandlerArg( this->parser_, this );
#endif /* 0 */

  ::XML_SetSkippedEntityHandler( this->parser_,
                                 vtkPaletteParser::SkippedEntityCb );

  ::XML_SetUnknownEncodingHandler( this->parser_,
                                   vtkPaletteParser::UnknownEncodingCb,
                                   this->encodingDataPtr_ );
}

// ----------------------------------------------------------------------------
// Expat callback methods
// ----------------------------------------------------------------------------

static const XML_Char palletteStr[] =
{ ASCII_latin_p, ASCII_latin_a, ASCII_latin_l, ASCII_latin_e, ASCII_latin_t,
  ASCII_latin_t, ASCII_latin_e };

static const XML_Char colorStr[] =
{ ASCII_latin_c, ASCII_latin_o, ASCII_latin_l, ASCII_latin_o, ASCII_latin_r };

static const XML_Char materialStr[] =
{ ASCII_latin_m, ASCII_latin_a, ASCII_latin_t, ASCII_latin_e, ASCII_latin_r,
  ASCII_latin_i, ASCII_latin_a, ASCII_latin_l };

// ----------------------------------------------------------------------------
void 
vtkPaletteParser::StartElement(const XML_Char* aElem, const XML_Char** aAttrs)
{
  if (vtkXMLString::Equals(aElem,palletteStr))          // <palette>
    {
    }
  else if (vtkXMLString::Equals(aElem,colorStr))        // <color>
    {
    }
  else if (vtkXMLString::Equals(aElem,materialStr))     // <material>
    {
    }

  std::cout <<"StartElement( <" << vtkXMLString::ToLatin1(aElem) << ">\n";

  while(*aAttrs)
    {
    std::cout << "\t" << vtkXMLString::ToLatin1(aAttrs[0]) << "\t= \""
              << vtkXMLString::ToLatin1(aAttrs[1]) << "\"" << std::endl;
    aAttrs += 2;
    }

  std::cout << " )" << std::endl;
}

void 
vtkPaletteParser::EndElement(const XML_Char* aElem)
{
  std::cout << "EndElement( <" << vtkXMLString::ToLatin1(aElem) << "> )"
            << std::endl;
}

// ----------------------------------------------------------------------------
void 
vtkPaletteParser::CharacterData(const XML_Char* aData, int aLen)
{
  if (!this->EmptyCharacterData(aData,aLen))
    {
    XML_Char* data = new XML_Char[aLen + 1];
    
    vtkXMLString::SubString(data,aData,0,aLen);
    
    std::cout << "CharacterData( " << vtkXMLString::ToLatin1(data)
              << ", " << aLen << " )" << std::endl;
    
    delete [] data;
    }
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::ProcessingInstruction(const XML_Char* aTarget,
                                       const XML_Char* aData)
{
  std::cout << "ProcessingInstruction( " << vtkXMLString::ToLatin1(aTarget)
            << ", " << vtkXMLString::ToLatin1(aData) << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::Comment(const XML_Char* aData)
{
  std::cout << "Comment( " << vtkXMLString::ToLatin1(aData) << " )"
            << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::StartCdataSection(void)
{
  std::cout << "StartCdataSection()" << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::EndCdataSection(void)
{
  std::cout << "EndCdataSection()" << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::Default(const XML_Char* aData, int aLen)
{
  if (!this->EmptyCharacterData(aData,aLen))
    {
    XML_Char* data = new XML_Char[aLen + 1];
    
    vtkXMLString::SubString(data,aData,0,aLen);
    
    std::cout << "Default( " << vtkXMLString::ToLatin1(data)
              << ", " << aLen << " )" << std::endl;
    
    delete [] data;
    }
}

// ----------------------------------------------------------------------------
int
vtkPaletteParser::ExternalEntityRef(const XML_Char* aContext,
                                   const XML_Char* aBase,
                                   const XML_Char* aSystemId,
                                   const XML_Char* aPublicId)
{
  std::cout << "ExternalEntityRef( " << vtkXMLString::ToLatin1(aContext)
            << ", " << vtkXMLString::ToLatin1(aBase) << ", "
            << vtkXMLString::ToLatin1(aSystemId) << ", "
            << vtkXMLString::ToLatin1(aPublicId) << " ) returning 1"
            << std::endl;

  return 1;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::SkippedEntity(const XML_Char* aName, int aIsParamEntity)
{
  std::cout << "SkippedEntity( " << vtkXMLString::ToLatin1(aName)
            << ", " << aIsParamEntity << " )" << std::endl;
}

// ----------------------------------------------------------------------------
int
vtkPaletteParser::UnknownEncoding(const XML_Char* aName, XML_Encoding* aInfo)
{
  std::cout << "UnknownEncoding( " << vtkXMLString::ToLatin1(aName)
            << ", " << aInfo << " ) returning 0" << std::endl;

  return 0;
}

// ----------------------------------------------------------------------------
void 
vtkPaletteParser::StartNamespaceDecl(const XML_Char* aPrefix,
                                    const XML_Char* aURI)
{
  std::cout << "StartNamespaceDecl( " << vtkXMLString::ToLatin1(aPrefix)
            << ", " << vtkXMLString::ToLatin1(aURI) << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void 
vtkPaletteParser::EndNamespaceDecl(const XML_Char* aPrefix)
{
  std::cout << "EndNamespaceDecl( " << vtkXMLString::ToLatin1(aPrefix)
            << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::XmlDecl(const XML_Char* aVersion,
                         const XML_Char* aEncoding,
                         int             aStandalone)
{
  std::cout << "XmlDecl( " << vtkXMLString::ToLatin1(aVersion) << ", "
            << vtkXMLString::ToLatin1(aEncoding) << ", "
            << aStandalone << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::StartDoctypeDecl(const XML_Char* aDoctypeName,
                                  const XML_Char* aSystemId,
                                  const XML_Char* aPublicId,
                                  int             aHasInternalSubset)
{
  std::cout << "StartDoctypeDecl( " << vtkXMLString::ToLatin1(aDoctypeName)
            << ", " << vtkXMLString::ToLatin1(aSystemId) << ", "
            << vtkXMLString::ToLatin1(aPublicId) << ", "
            << aHasInternalSubset << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::EndDoctypeDecl(void)
{
  std::cout <<"EndDoctypeDecl()" << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::ElementDecl(const XML_Char* aName, XML_Content* aModel)
{
  std::cout << "ElementDecl( " << vtkXMLString::ToLatin1(aName)
            << ", " << aModel << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::AttlistDecl(const XML_Char* aElemName,
                             const XML_Char* aAttrName,
                             const XML_Char* aAttrType,
                             const XML_Char* aDefault,
                             int             aIsRequired)
{
  std::cout << "AttlistDecl( " << vtkXMLString::ToLatin1(aElemName)
            << ", " << vtkXMLString::ToLatin1(aAttrName)
            << ", " << vtkXMLString::ToLatin1(aAttrType)
            << ", " << vtkXMLString::ToLatin1(aDefault)
            << ", " << aIsRequired << " )" << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::EntityDecl(const XML_Char* aEntityName,
                            int             aIsParameterEntity,
                            const XML_Char* aValue,
                            int             aValueLength,
                            const XML_Char* aBase,
                            const XML_Char* aSystemId,
                            const XML_Char* aPublicId,
                            const XML_Char* aNotationName)
{
  std::cout << "EntityDecl( " << vtkXMLString::ToLatin1(aEntityName)
            << ", " << aIsParameterEntity
            << ", " << vtkXMLString::ToLatin1(aValue)
            << ", " << aValueLength
            << ", " << vtkXMLString::ToLatin1(aBase)
            << ", " << vtkXMLString::ToLatin1(aSystemId)
            << ", " << vtkXMLString::ToLatin1(aPublicId)
            << ", " << vtkXMLString::ToLatin1(aNotationName) << " )"
            << std::endl;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::NotationDecl(const XML_Char* aNotationName,
                              const XML_Char* aBase,
                              const XML_Char* aSystemId,
                              const XML_Char* aPublicId)
{
  std::cout << "NotationDecl( " << vtkXMLString::ToLatin1(aNotationName)
            << ", " << vtkXMLString::ToLatin1(aBase)
            << ", " << vtkXMLString::ToLatin1(aSystemId)
            << ", " << vtkXMLString::ToLatin1(aPublicId) << " )" << std::endl;
}

// ----------------------------------------------------------------------------
int
vtkPaletteParser::NotStandalone(void)
{
  std::cout <<"NotStandalone() returning XML_STATUS_OK." << std::endl;

  return XML_STATUS_OK;
}

// ----------------------------------------------------------------------------
void
vtkPaletteParser::PrintSelf(std::ostream& aTarget, vtkIndent aIndent)
{
  this->Superclass::PrintSelf(aTarget,aIndent);
}

/*
 * End of: $Id: vtkPaletteParser.cxx,v 1.1.1.1 2006/12/19 23:00:08 christianh Exp $.
 * 
 */
