#!/bin/bash
#
# $Id: build.sh,v 1.2 2007/10/31 17:23:42 chcma Exp $
#

# 

# Name of the executable.
as_me=`(basename "$0") 2>/dev/null ||
$as_expr X/"$0" : '.*/\([^/][^/]*\)/*$' \| \
	 X"$0" : 'X\(//\)$' \| \
	 X"$0" : 'X\(/\)$' \| \
	 .     : '\(.\)' 2>/dev/null ||
echo X/"$0" |
    sed '/^.*\/\([^/][^/]*\)\/*$/{ s//\1/; q; }
  	  /^X\/\(\/\/\)$/{ s//\1/; q; }
  	  /^X\/\(\/\).*/{ s//\1/; q; }
  	  s/.*/./; q'`

#
# setup
#
realclean=
clean=
depend=
help=

findvtkfltk=
findvtkextensions=
findvtkmrml=

if [ "$MAKE" ] ; then
  make_exe=$MAKE
else
  make_exe="make"
fi

#
# built / installed CMake
#

cmakesource=NONE
cmakedir=NONE

if [ "$CMAKE_CMD" ] ; then
  cmake_exe=$CMAKE_CMD
else
  cmake_exe='cmake'
fi

if [ "$CMAKE_BUILD_TYPE" ] ; then
  buildtype=$CMAKE_BUILD_TYPE
else
  buildtype='Release'
fi

#
# built / installed VTK and FLTK
#

fltksource=NONE
vtksource=NONE

if [ "$VTK_DIR" ] ; then
  vtkdir=$VTK_DIR
else
  vtkdir='/usr/local/lib/vtk'
fi

if [ "$FLTK_INCLUDE_DIR" ] ; then
  fltkdir=$FLTK_INCLUDE_DIR
else
  fltkdir='/usr/local/include'
fi

#
# source directories
#

if [ "$SOURCE_ROOT" ] ; then
  sourceroot=$SOURCE_ROOT
else
  sourceroot=$PWD
fi

if [ "$VTK_FLTK_SRC" ] ; then
  vtkfltksource=$VTK_FLTK_SRC
else
  vtkfltksource='${sourceroot}/vtkFLTK'
fi
if [ "$VTK_EXTENSIONS_SRC" ] ; then
  vtkextensionssource=$VTK_EXTENSIONS_SRC
else
  vtkextensionssource='${sourceroot}/vtkExtensions'
fi
if [ "$VTK_MRML_SRC" ] ; then
  vtkmrmlsource=$VTK_MRML_SRC
else
  vtkmrmlsource='${sourceroot}/vtkMrml'
fi
if [ "$SVV_SRC" ] ; then
  svvsource=$SVV_SRC
else
  svvsource='${sourceroot}/SV'
fi

#
# build directories
#

if [ "$BUILD_ROOT" ] ; then
  buildroot=$BUILD_ROOT
else
  buildroot=$PWD
fi

if [ $VTK_FLTK_DIR ] ; then
  vtkfltkdir=$VTK_FLTK_DIR
else
  vtkfltkdir='${buildroot}/vtkFLTK-${buildtype}'
fi
if [ $VTK_EXTENSIONS_DIR ] ; then
  vtkextensionsdir=$VTK_EXTENSIONS_DIR
else
  vtkextensionsdir='${buildroot}/vtkExtensions-${buildtype}'
fi
if [ $VTK_MRML_DIR ] ; then
  vtkmrmldir=$VTK_MRML_DIR
else
  vtkmrmldir='${buildroot}/vtkMrml-${buildtype}'
fi
if [ $SVV_DIR ] ; then
  svvdir=$SVV_DIR
else
  svvdir='${buildroot}/SV-${buildtype}'
fi


previous=
for option
do
  # If the previous option needs an argument, assign it.
  if test -n "$previous"; then
    eval "$previous=\$option"
    previous=
    continue
  fi

  optarg=`expr "x$option" : 'x[^=]*=\(.*\)'`

  case $option in

  -buildroot | --buildroot | --buildroo | --buildro | --buildr)
    previous=buildroot ;;
  -buildroot=* | --buildroot=* | --buildroo=* | --buildro=* | --buildr=*)
    buildroot=$optarg ;;

  -buildtype | --buildtype | --buildtyp | --buildty | --buildt)
    previous=buildtype ;;
  -buildtype=* | --buildtype=* | --buildtyp=* | --buildty=* | --buildt=*)
    buildtype=$optarg ;;

  -clean | --clean | --clea | --cle | --cl)
    clean=yes ;;

  -cmake | --cmake | --cmak | --cma | --cm)
    previous=cmake_exe ;;
  -cmake=* | --cmake=* | --cmak=* | --cma=* | --cm=*)
    cmake_exe=$optarg ;;

  -cmakesource | --cmakesource | --cmakesourc | --cmakesour | --cmakesou \
  | --cmakeso | --cmakes )
    previous=cmakesource ;;
  -cmakesource=* | --cmakesource=* | --cmakesourc=* | --cmakesour=* \
  | --cmakesou=* | --cmakeso=* | --cmakes=* )
    cmakesource=$optarg ;;

  -depend | --depend | --depen | --depe | --dep | --de | --d)
    depend=yes ;;

  -fltkdir | --fltkdir | --fltkdi | --fltkd)
    previous=fltkdir ;;
  -fltkdir=* | --fltkdir=* | --fltkdi=* | --fltkd=*)
    fltkdir=$optarg ;;

  -fltksource | --fltksource | --fltksourc | --fltksour | --fltksou \
  | --fltkso | --fltks)
    previous=fltksource ;;
  -fltksource=* | --fltksource=* | --fltksourc=* | --fltksour=* | --fltksou=* \
  | --fltkso=* | --fltks=*)
    fltksource=$optarg ;;

  -help | --help | --hel | --he | -h)
    help=yes ;;

  -make | --make | --mak | --ma | --m)
    previous=make_exe ;;
  -make=* | --make=* | --mak=* | --ma=* | --m=*)
    make_exe=$optarg ;;

  -realclean | --realclean | --realclea | --realcle | --realcl | --realc)
    realclean=yes ; depend=yes ;;

  -sourceroot | --sourceroot | --sourceroo | --sourcero | --sourcer \
  | --source | --sourc | --sour | --sou | --so | --s)
    previous=sourceroot ;;
  -sourceroot=* | --sourceroot=* | --sourceroo=* | --sourcero=* | --sourcer=* \
  | --source=* | --sourc=* | --sour=* | --sou=* | --so=* | --s=*)
    sourceroot=$optarg ;;

  -svvdir | --svvdir | --svvdi | --svvd)
    previous=svvdir ;;
  -svvdir=* | --svvdir=* | --svvdi=* | --svvd=*)
    svvdir=$optarg ;;

  -svvsource | --svvsource | --svvsourc | --svvsour | --svvsou \
  | --svvso | --svvs)
    previous=svvsource ;;
  -svvsource=* | --svvsource=* | --svvsourc=* | --svvsour=* | --svvsou=* \
  | --svvso=* | --svvs=*)
    svvsource=$optarg ;;

  -vtkdir | --vtkdir | --vtkdi | --vtkd)
    previous=vtkdir ;;
  -vtkdir=* | --vtkdir=* | --vtkdi=* | --vtkd=*)
    vtkdir=$optarg ;;

  -vtkextensionsdir | --vtkextensionsdir | --vtkextensionsdi \
  | --vtkextensionsd)
    previous=vtkextensionsdir ;;
  -vtkextensionsdir=* | --vtkextensionsdir=* | --vtkextensionsdi=* \
  | --vtkextensionsd=*)
    vtkextensionsdir=$optarg ;;

  -vtkextensionssource | --vtkextensionssource | --vtkextensionssourc \
  | --vtkextensionssour | --vtkextensionssou | --vtkextensionsso \
  | --vtkextensionss)
    previous=vtkextensionssource ;;
  -vtkextensionssource=* | --vtkextensionssource=* | --vtkextensionssourc=* \
  | --vtkextensionssour=* | --vtkextensionssou=* | --vtkextensionsso=* \
  | --vtkextensionss=*)
    vtkextensionssource=$optarg ;;

  -vtkfltkdir | --vtkfltkdir | --vtkfltkdi | --vtkfltkd)
    previous=vtkfltkdir ;;
  -vtkfltkdir=* | --vtkfltkdir=* | --vtkfltkdi=* | --vtkfltkd=*)
    vtkfltkdir=$optarg ;;

  -vtkfltksource | --vtkfltksource | --vtkfltksourc \
  | --vtkfltksour | --vtkfltksou | --vtkfltkso \
  | --vtkfltks)
    previous=vtkfltksource ;;
  -vtkfltksource=* | --vtkfltksource=* | --vtkfltksourc=* \
  | --vtkfltksour=* | --vtkfltksou=* | --vtkfltkso=* \
  | --vtkfltks=*)
    vtkfltksource=$optarg ;;

  -vtkmrmldir | --vtkmrmldir | --vtkmrmldi | --vtkmrmld)
    previous=vtkmrmldir ;;
  -vtkmrmldir=* | --vtkmrmldir=* | --vtkmrmldi=* | --vtkmrmld=*)
    vtkmrmldir=$optarg ;;

  -vtkmrmlsource | --vtkmrmlsource | --vtkmrmlsourc \
  | --vtkmrmlsour | --vtkmrmlsou | --vtkmrmlso \
  | --vtkmrmls)
    previous=vtkmrmlsource ;;
  -vtkmrmlsource=* | --vtkmrmlsource=* | --vtkmrmlsourc=* \
  | --vtkmrmlsour=* | --vtkmrmlsou=* | --vtkmrmlso=* \
  | --vtkmrmls=*)
    vtkmrmlsource=$optarg ;;

  -vtksource | --vtksource | --vtksourc | --vtksour | --vtksou \
  | --vtkso | --vtks)
    previous=vtksource ;;
  -vtksource=* | --vtksource=* | --vtksourc=* | --vtksour=* | --vtksou=* \
  | --vtkso=* | --vtks=*)
    vtksource=$optarg ;;

  esac
done

if test -n "$previous"; then
  option=--`echo $previous | sed 's/_/-/g'`
  { echo "$as_me: error: missing argument to $option" >&2
   { (exit 1); exit 1; }; }
fi

# Be sure to have absolute paths.
for var in vtksource fltksource
do
  eval val=$`echo $var`
  case $val in
    [\\/$]* | ?:[\\/]* | NONE | '' ) ;;
    *)  { echo "$as_me: error: expected an absolute directory name for --$var: $val" >&2
   { (exit 1); exit 1; }; };;
  esac
done

# Be sure to have absolute paths.
for var in vtkdir fltkdir vtkfltksource vtkextensionssource vtkmrmlsource \
           svvsource vtkfltkdir vtkextensionsdir vtkmrmldir svvdir \
           sourceroot buildroot
do
  eval val=$`echo $var`
  case $val in
    [\\/$]* | ?:[\\/]* ) ;;
    *)  { echo "$as_me: error: expected an absolute directory name for --$var: $val" >&2
   { (exit 1); exit 1; }; };;
  esac
done


#
# functions
#
find_dir_or_exit ()
{
  if [ $# -lt 1 ]; then
    echo "find_dir_or_exit() called with 0 arguments!" >&2
    exit 1
  elif [ ! -d $1 ] ; then
    echo "Directory '$1' not found!" >&2
    exit 1
  fi
  return
}

find_file_or_exit ()
{
  if [ $# -lt 1 ]; then
    echo "find_file_or_exit() called with 0 arguments!" >&2
    exit 1
  elif [ ! -f $1 ] ; then
    echo "File '$1' not found!" >&2
    exit 1
  fi
  return
}

create_dir_or_exit ()
{
  if [ $# -lt 1 ]; then
    echo "create_dir_or_exit() called with 0 arguments!" >&2
    exit 1
  elif ! eval mkdir -p $1 >&2 ; then
    echo "Failed to make directory '$1'." >&2
    exit 1
  fi
  return
}

do_make_clean ()
{
  if [ "x$clean" == xyes ] ; then
    if ! eval $make_exe clean >&2 ; then
      echo "'$make_exe clean' failed for '$PWD'." >&2
      exit 1
    fi
  fi
  return
}

do_make_depend ()
{
  if [ "x$depend" == xyes ] ; then
    if ! eval $make_exe depend >&2 ; then
      echo "'$make_exe depend' failed for '$PWD'." >&2
      exit 1
    fi
  fi
  return
}

do_make ()
{
  if ! eval $make_exe -k >&2 ; then
    echo "'$make_exe -k' failed for '$PWD'." >&2
    exit 1
  fi
  return
}

do_make_cmds ()
{
  do_make_clean
  do_make_depend
  do_make
  return
}


#
# Be sure that there is either a CMake build, source, or source archive.
#

if ! eval $cmake_exe --version >/dev/null 2>&1; then

  cmake_exe=NONE

  if [ -f $buildroot/cmake-1.8.2-build/bin/cmake ] ; then

    cmake_exe=$buildroot/cmake-1.8.2-build/bin/cmake

  elif [ -d $cmakesource ] ; then

    cmakedir=$buildroot/cmake-build

  elif [ -d $sourceroot/cmake-1.8.2 ] ; then

    cmakesource=$sourceroot/cmake-1.8.2
    cmakedir=$buildroot/cmake-1.8.2-build

  elif [ -f $sourceroot/cmake-1.8.2.tar.gz ] ; then

    cmakearchive=$sourceroot/cmake-1.8.2.tar.gz
    
    if [ "x$help" == x ] ; then

      if ! eval gzip -dc $cmakearchive | tar -xf - >&2 ; then
        echo "Failed to unpack CMake archive '$cmakearchive'." >&2
        exit 1
      fi

    fi

    cmakesource=$sourceroot/cmake-1.8.2
    cmakedir=$buildroot/cmake-1.8.2-build

  fi

  if [ "x$help" == x ] ; then
    create_dir_or_exit $cmakedir
  elif [ "x$cmake_exe" == xNONE ] ; then
    cmake_exe=$cmakedir/bin/cmake
  fi

fi

#
# Be sure that there is either a FLTK build, source, or source archive.
#

if [ "x$fltksource" != xNONE -a ! -f $fltksource/lib/libfltk.a ] ; then

  fltkdir=$fltksource

elif [ "x$fltksource" == xNONE -a ! -f $fltkdir/lib/libfltk.a ] ; then

  if [ -d $sourceroot/fltk-1.1.4-${buildtype} ] ; then

    fltksource=$sourceroot/fltk-1.1.4-${buildtype}
    fltkdir=$fltksource

  elif [ -f $sourceroot/fltk-1.1.4-source.tar.gz ] ; then

    fltkarchive=$sourceroot/fltk-1.1.4-source.tar.gz

    if [ "x$help" == x ] ; then

      if ! eval gzip -dc $fltkarchive | tar -xf - >&2 ; then
        echo "Failed to unpack FLTK archive '$fltkarchive'." >&2
        exit 1
      else
        mv $sourceroot/fltk-1.1.4 $sourceroot/fltk-1.1.4-${buildtype}
      fi

    fi

    fltksource=$sourceroot/fltk-1.1.4-${buildtype}
    fltkdir=$fltksource

  fi

fi


#
# Be sure that there is either a VTK build, source, or source archive.
#

if [ "x$vtksource" == xNONE -a ! -f $vtkdir/UseVTK.cmake ] ; then

  if [ -d $sourceroot/VTK-4.2.5 ] ; then

    vtksource=$sourceroot/VTK-4.2.5
    vtkdir=$buildroot/VTK-4.2.5-${buildtype}

  elif [ -f $sourceroot/VTK-4.2.5.tar.gz ] ; then

    vtkarchive=$sourceroot/VTK-4.2.5.tar.gz

    if [ "x$help" == x ] ; then

      if ! eval gzip -dc $vtkarchive | tar -xf - >&2 ; then
        echo "Failed to unpack VTK archive '$vtkarchive'." >&2
        exit 1
      else
        mv $sourceroot/VTK $sourceroot/VTK-4.2.5
      fi

    fi

    vtksource=$sourceroot/VTK-4.2.5
    vtkdir=$buildroot/VTK-4.2.5-${buildtype}

  fi

fi


eval vtkfltksource=`echo $vtkfltksource`
eval vtkextensionssource=`echo $vtkextensionssource`
eval vtkmrmlsource=`echo $vtkmrmlsource`
eval svvsource=`echo $svvsource`
eval vtkfltkdir=`echo $vtkfltkdir`
eval vtkextensionsdir=`echo $vtkextensionsdir`
eval vtkmrmldir=`echo $vtkmrmldir`
eval svvdir=`echo $svvdir`

#echo "" >&2
#echo " make_exe            '$make_exe'" >&2
#echo " cmake_exe           '$cmake_exe'" >&2
#echo " buildtype           '$buildtype'" >&2
#echo "" >&2
#echo " realclean           '${realclean:-no}'" >&2
#echo " clean               '${clean:-no}'" >&2
#echo " depend              '${depend:-no}'" >&2
#echo "" >&2
#echo " cmakesource         '$cmakesource'" >&2
#echo " cmakedir            '$cmakedir'" >&2
#echo "" >&2
#echo " fltksource          '$fltksource'" >&2
#echo " fltkdir             '$fltkdir'" >&2
#echo "" >&2
#echo " vtksource           '$vtksource'" >&2
#echo " vtkdir              '$vtkdir'" >&2
#echo "" >&2
#echo " vtkfltksource       '$vtkfltksource'" >&2
#echo " vtkextensionssource '$vtkextensionssource'" >&2
#echo " vtkmrmlsource       '$vtkmrmlsource'" >&2
#echo " svvsource           '$svvsource'" >&2
#echo "" >&2
#echo " vtkfltkdir          '$vtkfltkdir'" >&2
#echo " vtkextensionsdir    '$vtkextensionsdir'" >&2
#echo " vtkmrmldir          '$vtkmrmldir'" >&2
#echo " svvdir              '$svvdir'" >&2
#echo "" >&2

#
# Report the --help message.
#
if [ "$help" ] ; then

  cat <<_EOF

Usage: $0 [OPTION]... [VAR=VALUE]...

Defaults for the options are specified in brackets.

Configuration:
  -h, --help              display this help and exit

  --make=EXE              location of the make executable
                          [$make_exe]

  --cmakesource=DIR       build CMake from source in DIR
                          [$cmakesource]

  --cmake=EXE             location of the cmake executable
                          [$cmake_exe]
  --buildtype=NAME        CMake build type where NAME is one of Debug,
                          Release, RelWithDebInfo, or MinSizeRel.
                          [$buildtype]

  --realclean             trash and reconfigure build directories
  --clean                 clean build directories before building
  --depend                generate dependencies before building

VTK and FLTK Source directories:
  --fltksource=DIR        build FLTK from source in DIR
                          [$fltksource]
  --vtksource=DIR         build VTK from source in DIR
                          [$vtksource]

VTK and FLTK Build directories:
  --fltkdir=DIR           root directory of built FLTK is DIR
                          [$fltkdir]
  --vtkdir=DIR            root directory of built VTK is DIR
                          [$vtkdir]

Source directories:
  --sourceroot=DIR           The source directories are in DIR
                             [$sourceroot]

  --vtkfltksource=DIR        build vtkFLTK from source in DIR
                             [$vtkfltksource]
  --vtkextensionssource=DIR  build vtkExtensions from source in DIR
                             [$vtkextensionssource]
  --vtkmrmlsource=DIR        build vtkMrml from source in DIR
                             [$vtkmrmlsource]
  --svvsource=DIR            build SVV from source in DIR
                             [$svvsource]

Build directories:
  --buildroot=DIR            The build directories are in DIR
                             [$buildroot]

  --vtkfltkdir=DIR           root directory of built vtkFLTK is DIR
                             [$vtkfltkdir]
  --vtkextensionsdir=DIR     root directory of built vtkExtensions is DIR
                             [$vtkextensionsdir]
  --vtkmrmldir=DIR           root directory of built vtkMrml is DIR
                             [$vtkmrmldir]
  --svvdir=DIR               root directory of built SVV is DIR
                             [$svvdir]

Some influential environment variables:

  MAKE                  the make command

  CMAKE_CMD             the cmake command
  CMAKE_BUILD_TYPE      the cmake build type

  VTK_DIR               root directory of built VTK
  FLTK_INCLUDE_DIR      root directory of built FLTK

  SOURCE_ROOT           directory containing the source directories
  VTK_FLTK_SRC          directory containing the vtkFLTK source
  VTK_EXTENSIONS_SRC    directory containing the vtkExtensions source
  VTK_MRML_SRC          directory containing the vtkMrml source
  SVV_SRC               directory containing the SVV source

  BUILD_ROOT            directory containing the build directories
  VTK_FLTK_DIR          the vtkFLTK build directory
  VTK_EXTENSIONS_DIR    the vtkExtensions build directory
  VTK_MRML_DIR          the vtkMrml build directory
  SVV_DIR               the SVV build directory

_EOF
  exit 0
fi

#
# CMake
#
if [ "x$cmake_exe" == xNONE ] ; then

  if [ "x$cmakesource" == xNONE -o "x$cmakedir" == xNONE ] ; then
    echo "Failed to find 'cmake' executable or source." >&2
    exit 1
  fi

  cd $cmakedir
  
  if [ ! -f $cmakedir/bin/cmake ] ; then

    if [ ! -f $cmakesource/configure ] ; then
      echo "Failed to find '$cmakesource/configure'." >&2
      exit 1
    fi

    if ! eval $cmakesource/configure >&2 ; then
      echo "'$cmakesource/configure' failed for '$PWD'." >&2
      exit 1
    fi

    do_make

  fi

  cmake_exe=$cmakedir/bin/cmake

fi

if [ ! -f $cmake_exe ] ; then
  echo "Failed to find '$cmake_exe'." >&2
  exit 1
fi


#
# FLTK
#
echo ""  >&2
echo "*** FLTK          ***" >&2
echo ""  >&2

if [ "x$fltksource" == xNONE ] ; then
  find_dir_or_exit $fltkdir
else

  cd $fltkdir

  if [ ! -f $fltksource/config.h ] ; then
    if [ ! -f $fltksource/configure ] ; then
      echo "Failed to find '$fltksource/configure'." >&2
      exit 1
    fi
    if [ "x$buildtype" == xDebug ]
    then
      if ! eval $fltksource/configure --enable-debug --enable-gl \
        --enable-threads --enable-xdbe --with-x>&2
      then
        echo "'$configure_cmd' failed for '$PWD'." >&2
        exit 1
      fi
    else
      if ! eval $fltksource/configure --enable-gl \
        --enable-threads --enable-xdbe --with-x>&2
      then
        echo "'$configure_cmd' failed for '$PWD'." >&2
        exit 1
      fi
    fi
  fi

  if [ ! -f $fltkdir/../lib/libfltk.a -a \
       ! -f $fltkdir/lib/libfltk.a ] ; then
    do_make
  fi

fi


#
# VTK
#
echo ""  >&2
echo "*** VTK           ***" >&2
echo ""  >&2

if [ "x$vtksource" == xNONE ] ; then
  find_dir_or_exit $vtkdir
  find_file_or_exit $vtkdir/UseVTK.cmake
else
  if [ ! -d $vtkdir ] ; then
    create_dir_or_exit $vtkdir
  fi
  if [ ! -f $vtkdir/UseVTK.cmake ] ; then
    cd $vtkdir
    if [ ! -f Makefile ] ; then
      if [ ! -f $vtksource/CMakeLists.txt ] ; then
        echo "Failed to find '$vtksource/CMakeLists.txt'." >&2
        exit 1
      fi
      if ! eval $cmake_exe -DCMAKE_BUILD_TYPE:STRING=${buildtype} \
        -DBUILD_EXAMPLES:BOOL=OFF \
        -DVTK_USE_HYBRID:BOOL=ON \
        -DVTK_USE_PARALLEL:BOOL=ON \
        ${vtksource} >&2
      then
        echo "'$cmake_exe' failed to configure $PWD." >&2
        exit 1
      fi
    fi
    do_make_cmds
  fi
fi


#
# vtkFLTK
#
echo ""  >&2
echo "*** vtkFLTK       ***" >&2
echo ""  >&2

if [ -d $vtkfltksource ] ; then

  findvtkfltk="${vtkfltksource}/FindvtkFLTK.cmake"

  if [ "x$realclean" == xyes -a -d $vtkfltkdir ] ; then
    rm -rf $vtkfltkdir/* >&2
  fi

  create_dir_or_exit $vtkfltkdir

  cd $vtkfltkdir

  if ! eval $cmake_exe -DCMAKE_BUILD_TYPE:STRING=${buildtype} \
    -DBUILD_EXAMPLES:BOOL=OFF \
    -DVTK_DIR:PATH=${vtkdir} \
    -DFLTK_INCLUDE_DIR:PATH=${fltkdir} \
    ${vtkfltksource} >&2
  then
    echo "'$cmake_exe' failed to configure $PWD." >&2
    exit 1
  fi

  do_make_cmds

elif [ ! -d $vtkfltkdir ] ; then
  echo "Could not find vtkFLTK source '$vtkfltksource'." >&2
  echo "Could not find vtkFLTK build '$vtkfltkdir'." >&2
fi

#
# vtkExtensions
#
echo ""  >&2
echo "*** vtkExtensions ***" >&2
echo ""  >&2

if [ -d $vtkextensionssource ] ; then

  findvtkextensions="${vtkextensionssource}/FindvtkExtensions.cmake"

  if [ "x$realclean" == xyes -a -d $vtkextensionsdir ] ; then
    rm -rf $vtkextensionsdir/* >&2
  fi

  create_dir_or_exit $vtkextensionsdir

  cd $vtkextensionsdir

  if ! eval $cmake_exe -DCMAKE_BUILD_TYPE:STRING=${buildtype} \
    -DBUILD_EXAMPLES:BOOL=OFF \
    -DVTK_DIR:PATH=${vtkdir} \
    ${vtkextensionssource} >&2
  then
    echo "'$cmake_exe' failed to configure $PWD." >&2
    exit 1
  fi

  do_make_cmds

elif [ ! -d $vtkextensionsdir ] ; then
  echo "Could not find vtkExtensions source '$vtkextensionssource'." >&2
  echo "Could not find vtkExtensions build '$vtkextensionsdir'." >&2
fi

#
# vtkMrml
#
echo ""  >&2
echo "*** vtkMrml       ***" >&2
echo ""  >&2

if [ -d $vtkmrmlsource ] ; then

  findvtkmrml="${vtkmrmlsource}/FindvtkMrml.cmake"

  if [ "x$realclean" == xyes -a -d $vtkmrmldir ] ; then
    rm -rf $vtkmrmldir/* >&2
  fi

  create_dir_or_exit $vtkmrmldir

  cd $vtkmrmldir

  if ! eval $cmake_exe -DCMAKE_BUILD_TYPE:STRING=${buildtype} \
    -DBUILD_EXAMPLES:BOOL=OFF \
    -DVTK_DIR:PATH=${vtkdir} \
    -DFIND_VTK_EXTENSIONS_FILE:FILEPATH=${findvtkextensions} \
    -DVTK_EXTENSIONS_DIR:PATH=${vtkextensionsdir} \
    ${vtkmrmlsource} >&2
  then
    echo "'$cmake_exe' failed to configure $PWD." >&2
    exit 1
  fi

  do_make_cmds

elif [ ! -d $vtkmrmldir ] ; then
  echo "Could not find vtkMrml source '$vtkmrmlsource'." >&2
  echo "Could not find vtkMrml build '$vtkmrmldir'." >&2
fi

#
# SVV
#
echo ""  >&2
echo "*** SVV           ***" >&2
echo ""  >&2

if [ -d $svvsource ] ; then

  if [ "x$realclean" == xyes -a -d $svvdir ] ; then
    rm -rf $svvdir/* >&2
  fi

  create_dir_or_exit $svvdir

  cd $svvdir ;

  if ! eval $cmake_exe -DCMAKE_BUILD_TYPE:STRING=${buildtype} \
    -DVTK_DIR:PATH=${vtkdir} \
    -DFLTK_INCLUDE_DIR:PATH=${fltkdir} \
    -DVTK_FLTK_DIR:PATH=${vtkfltkdir} \
    -DFIND_VTK_EXTENSIONS_FILE:FILEPATH=${findvtkextensions} \
    -DVTK_EXTENSIONS_DIR:PATH=${vtkextensionsdir} \
    -DFIND_VTK_MRML_FILE:FILEPATH=${findvtkmrml} \
    -DVTK_MRML_DIR:PATH=${vtkmrmldir} \
    ${svvsource} >&2
  then
    echo "'$cmake_exe' failed to configure $PWD." >&2
    exit 1
  fi

  do_make_cmds

elif [ ! -d $svvdir ] ; then
  echo "Could not find SV source '$svvsource'." >&2
  echo "Could not find SV build '$svvdir'." >&2
fi

if [ -d $svvdir/bin ] ; then

  bindir='${buildroot}/bin-${buildtype}'

  create_dir_or_exit $bindir

  if [ -f $bindir/svv ] ; then
    mv -f $bindir/svv $bindir/svv.bak
  fi

  if [ -f $bindir/xminisv ] ; then
    mv -f $bindir/xminisv $bindir/xminisv.bak
  fi

  mv -f $svvdir/bin/vtkToolBarTest $bindir/svv
  mv -f $svvdir/bin/xminisv $bindir/xminisv

fi

#
# end
#

exit 0
#
# End of $Id: build.sh,v 1.2 2007/10/31 17:23:42 chcma Exp $.
#
