#
# $Id: svvMacros.cmake,v 1.1.1.1 2006/12/19 22:58:33 christianh Exp $
#

#
# Macro to find the "Find" module of a package created by CMake.
# Example invocation:
#
#   FIND_MODULE_FINDER (VTK_FLTK VTKFLTK vtkFLTK)
#
# Parameters:
#   project     The name used as a psuedo-namespace in variables.
#   module      The name used to name "Find" and "Use" CMake modules.
#   library     The library name sans prefix and suffix (e.g. libQ.a is Q).
#
# If the "Find" module is successfully located, its path is placed in
# the variable FIND_${project}_FILE.
#
IF (COMMAND FIND_MODULE_FINDER)
  MESSAGE (STATUS "Using previously recorded macro 'FIND_MODULE_FINDER'.")
ELSE (COMMAND FIND_MODULE_FINDER)
  MACRO (FIND_MODULE_FINDER project module library)
    #
    # Construct consistent error messages for use below.
    #
    SET (FIND_MODULE_FINDER_DESCRIPTION "path to Find${module}.cmake.  This is either the root of the source tree plus the filename, or CMAKE_ROOT/Modules/Find${module}.cmake for an installation.")
    SET (FIND_MODULE_FINDER_MESSAGE "Find${module}.cmake not found.  Set the FIND_${project}_FILE cmake cache entry to the ${FIND_MODULE_FINDER_DESCRIPTION}")
    IF (NOT FIND_${project}_FILE)
      # Search (including name variants) at same level as the build top level,
      # at same level as the most recent PROJECT level, and in the user HOME.
      GET_FILENAME_COMPONENT (DIR1 ${CMAKE_BINARY_DIR} PATH)
      GET_FILENAME_COMPONENT (DIR2 ${PROJECT_BINARY_DIR} PATH)

      FILE (GLOB GLOB1 ${DIR1}/${library}*)
      FILE (GLOB GLOB2 ${DIR2}/${library}*)
      FILE (GLOB GLOB3 $ENV{HOME}/${library}*)

      FIND_FILE (FIND_${project}_FILE Find${module}.cmake
        ${CMAKE_ROOT}/Modules
        ${GLOB1}
        ${GLOB2}
        ${GLOB3}
        # Help the user find it if we cannot.
        DOC "The ${FIND_MODULE_FINDER_DESCRIPTION}"
        )
    ENDIF (NOT FIND_${project}_FILE)
  ENDMACRO (FIND_MODULE_FINDER project module library)
ENDIF (COMMAND FIND_MODULE_FINDER)

#
# Macro to find and use a package created by CMake.
# Example invocation:
#
#   FIND_AND_USE_PACKAGE (VTK_FLTK VTKFLTK vtkFLTK)
#
# Parameters:
#   project     The name used as a psuedo-namespace in variables.
#   module      The name used to name "Find" and "Use" CMake modules.
#   library     The library name sans prefix and suffix (e.g. libQ.a is Q).
#
# If the "Find" module is successfully located, it is included. If the
# project is also found, the "Use" file is also included.
#
IF (COMMAND FIND_AND_USE_PACKAGE)
  MESSAGE (STATUS "Using previously recorded macro 'FIND_AND_USE_PACKAGE'.")
ELSE (COMMAND FIND_AND_USE_PACKAGE)
  MACRO (FIND_AND_USE_PACKAGE project module library)
    FIND_MODULE_FINDER (${project} ${module} ${library})

    IF (FIND_${project}_FILE)
      INCLUDE (${FIND_${project}_FILE})
      IF (${project}_FOUND)
        INCLUDE (${${project}_USE_FILE})
      ENDIF (${project}_FOUND)
    ENDIF (FIND_${project}_FILE)
  ENDMACRO (FIND_AND_USE_PACKAGE project module library)
ENDIF (COMMAND FIND_AND_USE_PACKAGE)

#
# End of: $Id: svvMacros.cmake,v 1.1.1.1 2006/12/19 22:58:33 christianh Exp $.
#
