/* 
 * $Id: svCleanPolyData.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 */

#include "vtkObjectFactory.h"
#include "vtkCleanPolyData.h"

#include "svCleanPolyData.H"


//----------------------------------------------------------------------------
svCleanPolyData::svCleanPolyData(void)
{
  this->ResetParameters();
}

//----------------------------------------------------------------------------
svCleanPolyData*
svCleanPolyData::New()
{
  // First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("svCleanPolyData");

  if(ret) {
    return reinterpret_cast<svCleanPolyData*>(ret);
  }
  // If the factory was unable to create the object, then create it here.
  return new svCleanPolyData;
}

//----------------------------------------------------------------------------
void
svCleanPolyData::InstallFilter(void)
{
  if( !(vtkCleanPolyData::SafeDownCast(this->GetFilter())) )
    this->SetFilter(vtkCleanPolyData::New());
}

//----------------------------------------------------------------------------
void
svCleanPolyData::ResetParameters(void)
{
  // this->Active                 = 0;
  this->PointMerging           = int(1);     // VTK default
  this->Tolerance              = float(0.0); // VTK default
  this->AbsoluteTolerance      = float(1.0); // VTK default
  this->ConvertPolysToLines    = int(1);     // VTK default
  this->ConvertLinesToPoints   = int(1);     // VTK default
  this->ConvertStripsToPolys   = int(1);     // VTK default
  this->ToleranceIsAbsolute    = int(0);     // VTK default
  this->PieceInvariant         = int(1);     // VTK default
}

//----------------------------------------------------------------------------
void
svCleanPolyData::ApplyParameters(void)
{
  if(this->Active) {
    vtkCleanPolyData* filter =
      vtkCleanPolyData::SafeDownCast(this->GetFilter());

    filter->SetPointMerging(this->PointMerging);
    filter->SetTolerance(this->Tolerance);
    filter->SetAbsoluteTolerance(this->AbsoluteTolerance);
    filter->SetConvertPolysToLines(this->ConvertPolysToLines);
    filter->SetConvertLinesToPoints(this->ConvertLinesToPoints);
    filter->SetConvertStripsToPolys(this->ConvertStripsToPolys);
    filter->SetToleranceIsAbsolute(this->ToleranceIsAbsolute);
    filter->SetPieceInvariant(this->PieceInvariant);
  }
}

/* 
 * End of: $Id: svCleanPolyData.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
