/* 
 * $Id: svDecimate.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 */

#include "vtkObjectFactory.h"
#include "vtkDecimatePro.h"

#include "svDecimate.H"


//----------------------------------------------------------------------------
svDecimate::svDecimate(void)
{
  this->ResetParameters();
}


//----------------------------------------------------------------------------
svDecimate*
svDecimate::New()
{
  // First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("svDecimate");

  if(ret) {
    return reinterpret_cast<svDecimate*>(ret);
  }
  // If the factory was unable to create the object, then create it here.
  return new svDecimate;
}

//----------------------------------------------------------------------------
void
svDecimate::InstallFilter(void)
{
  if( !(vtkDecimatePro::SafeDownCast(this->GetFilter())) )
    this->SetFilter(vtkDecimatePro::New());
}

//----------------------------------------------------------------------------
void
svDecimate::ResetParameters(void)
{
  // this->Active                 = 0;
  this->TargetReduction        = 0.9f;
  this->FeatureAngle           = 15.f;
  this->MaximumError           = VTK_LARGE_FLOAT;
  this->AbsoluteError          = VTK_LARGE_FLOAT;
  this->ErrorIsAbsolute        = 0;
  this->AccumulateError        = 0;
  this->SplitAngle             = 75.f;
  this->Splitting              = 1;
  this->PreSplitMesh           = 0;
  this->BoundaryVertexDeletion = 1;
  this->PreserveTopology       = 0;
  this->Degree                 = 25;
  this->InflectionPointRatio   = 10.f;
}

//----------------------------------------------------------------------------
void
svDecimate::ApplyParameters(void)
{
  if(this->Active) {
    vtkDecimatePro* filter =
      vtkDecimatePro::SafeDownCast(this->GetFilter());

    filter->SetTargetReduction(this->TargetReduction);
    filter->SetPreserveTopology(this->PreserveTopology);
    filter->SetFeatureAngle(this->FeatureAngle);
    filter->SetSplitting(this->Splitting);
    filter->SetSplitAngle(this->SplitAngle);
    filter->SetPreSplitMesh(this->PreSplitMesh);
    filter->SetMaximumError(this->MaximumError);
    filter->SetAccumulateError(this->AccumulateError);
    filter->SetErrorIsAbsolute(this->ErrorIsAbsolute);
    filter->SetAbsoluteError(this->AbsoluteError);
    filter->SetBoundaryVertexDeletion(this->BoundaryVertexDeletion);
    filter->SetDegree(this->Degree);
    filter->SetInflectionPointRatio(this->InflectionPointRatio);
  }
}

/* 
 * End of: $Id: svDecimate.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
