/* -*- C++ -*-
 * 
 * $Id: svDepthSort.H,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 * 
 * Copyright (c) 2002 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// .NAME svDepthSort - Aggregate filter object for vtkDepthSortPolyData.
// .SECTION Description
// Aggregate filter object for vtkDepthSortPolyData.

#ifndef SV_DEPTHSORT_H_
#  define SV_DEPTHSORT_H_

#  include "vtkCamera.h"
#  include "vtkProp3D.h"

#  include "svPolyDataFilter.H" /* includes svMacros */

// 
// .SECTION See Also
// svPolyDataFilter vtkDepthSortPolyData

class svDepthSort : public svPolyDataFilter
{
public:
  // Description:
  // Creates an instance of svDepthSort.
  static svDepthSort* New();

  vtkTypeMacro(svDepthSort,svPolyDataFilter);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // 
  void   InstallFilter(void);
  void   ResetParameters(void);
  void   ApplyParameters(void);

  // Description:
  // FrontToBack, BackToFront, ToSpecifiedVector
  svSetGetMacro(Direction, int);

  // Description:
  // FirstPoint, BoundsCenter, ParametricCenter
  svSetGetMacro(DepthSortMode, int);

  // Description:
  // 
  vtkCamera* GetCamera(vtkCamera* arg) const {return this->Camera;}
  void       SetCamera(vtkCamera* arg) {this->Camera = arg;}

  // Description:
  // 
  vtkProp3D* GetProp3D(vtkProp3D* arg) const {return this->Prop3D;}
  void       SetProp3D(vtkProp3D* arg) {this->Prop3D = arg;}

  // Description:
  // 
  const double* GetVector() const {return this->Vector;}
  void       SetVector(double x, double y, double z)
    {this->Vector[0]=x; this->Vector[1]=y; this->Vector[2]=z;}

  // Description:
  // 
  const double* GetOrigin() const {return this->Origin;}
  void       SetOrigin(double x, double y, double z)
    {this->Origin[0]=x; this->Origin[1]=y; this->Origin[2]=z;}

  // Description:
  // 
  svSetGetMacro(SortScalars, int);

protected:
  svDepthSort(void);

  int        Direction;
  int        DepthSortMode;
  vtkCamera* Camera;
  vtkProp3D* Prop3D;
  double     Vector[3];
  double     Origin[3];
  int        SortScalars;

private:
  svDepthSort(const svDepthSort&);  // Not implemented.
  void operator=(const svDepthSort&);  // Not implemented.
};

// Description:
// svDepthSort pointer data type.
typedef svDepthSort* svDepthSortPtr;

#endif /* SV_DEPTHSORT_H_ */
/* 
 * End of $Id: svDepthSort.H,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
